'\" @(#)tclStruct:read.n	1.3	95/09/08
.so man.macros
.TH struct_read n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_read \- Read from a stream to an object or field
.SH SYNOPSIS
\fBstruct_read \fI?flags? fileId \fIobj\fR|\fIobj(elem) \fI?length? \fR
.BE

.SH DESCRIPTION
.PP
Read from a file specified by \fIfileId\fR (a Tcl file id)
into an object or field.
\fIfileId\fR must be \fBstdin\fR or the return value from a previous
call to \fBopen\fR; it must refer to a file that was opened for
reading.
The file is read as a binary stream of bytes directly
into the object or field.
.PP
By default, the length to be read is the size of the object.
If a \fIlength\fR is specified, it may either be the integer length,
or a variable that contains the integer length.  When a variable name
is specified, then the number of bytes read is stored in the variable
as well as being returned to the caller.
.PP
The following optional \fIflags\fR may be specified in any order:
.IP "\fB\-eofok\fR"
Normally the struct_read command will generate an error the read
fails because of end-of-file.  Specifying \fB\-eofok\fR will allow
struct_read to return a value of 0 when EOF is read.
.IP "\fB\-unbuffered\fR"
Issue a raw \fBread\fR(2) instead of using \fBfread\fR(3S).
.IP "\fB\-partial\fR"
Normally struct_read will continue reading until it reads the full
number of bytes wanted.  Specifying \fB\-partial\fR will cause
struct_read to return the actual number of bytes read from the first
read.  Note that this will normally be used in conjunction with
\fB\-unbuffered\fR since otherwise the \fBfread\fR(3S) call will
most likely do its own retries.
.IP "\fB\-mod4\fR"
Make sure the \fIlength\fR read is a multiple of 4 by increasing 
the \fIlength\fR read if necessary.  It is the caller's responsibility
to make sure the object is big enough to avoid overwriting the
end of the object buffer.
.PP
struct_read returns the number of bytes read.

.SH EXAMPLES
This example reads in the contents of an object from a file.
.DS
set file [open 'filename' r]
read $file obj
close $file
.DE

.SH WARNINGS
.PP
The data read is not machine independent.
.PP
Intermixing buffered and unbuffered I/O on the same \fIfileID\fR
is a bad idea.

.SH KEYWORDS
file, read, struct
