'\" @(#)tclStruct:info.n	1.4	95/09/12
.so man.macros
.TH struct_info n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_info \- Return information about the state of TclStruct
.SH SYNOPSIS
\fBstruct_info \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command provides information about various internals of
the TclStruct package.
The legal \fIoption\fR's (which may be abbreviated) are:
.TP
\fBstruct_info builtins\fR ?\fIpattern\fR?
If \fIpattern\fR isn't specified,
returns a list of all the built-in types.
If \fIpattern\fR is specified, only those built-in types with names
matching \fIpattern\fR are returned.  Matching is determined using
the same rules as for \fBstring match\fR.
.TP
\fBstruct_info count\fR ?\fIinfo\fR?
Returns a count of some statistics maintained by the tclStruct
package.  These statistics are maintained per interpreter.
.RS
.TP
\fBstruct_info count command\fR
The total number of built-in commands that
have been invoked in this package.
.TP
\fBstruct_info count newtype\fR
The number of unique types created.  This is the running number
of new types
.TP
\fBstruct_info count read\fR
Returns a count of the total number of read accesses to structure objects
through this package.
.TP
\fBstruct_info count write\fR
Returns a count of the total number of write accesses to structure objects
through this package.
.TP
\fBstruct_info count reset\fR
This command resets all the statistics to zero.
.RE
.TP
\fBstruct_info debug \fR?\fB+\fR|\fB-\fIdbgFlagName ...\fR?
Set or reset one or more of the package internal debug flags.
The debug flags are not considered external information and
are not documented here.  If debug is compiled into the package
then this command returns the decimal value of the debug flags,
otherwise it returns no value.
.TP
\fBstruct_info exists \fIobjName\fR
Returns \fB1\fR if the object named \fIobjName\fR exists in the
current context (either as a global or local array), returns \fB0\fR
otherwise.
.TP
\fBstruct_info generate \fIprefix\fR
Generate a unique name.  This generates the same names as are
created for the \fB#auto\fR keyword.
.TP
\fBstruct_info object \fIobj \fR?\fIinfo\fR?
Returns information on the object \fIobj\fR.
.RS
.TP
\fBstruct_info object \fIobj\fR
If the object \fIobj\fR exists then it returns "1", otherwise
it returns "0".
This is equivalent to "struct_info exists \fIobj\fR".
.TP
\fBstruct_info object \fIobj \fBaddress\fR
Returns the address of the object as a simple decimal number.
.TP
\fBstruct_info object \fIobj \fBsize\fR
Returns the size of the object (in bytes).
.TP
\fBstruct_info object \fIobj \fBtype\fR
Returns the name of the type of the object.
It is an error if the object does not have a typedef'd name.
.TP
\fBstruct_info object \fIobj \fBtype \fIinfo\fR
Returns type \fIinfo\fR about the type of an object.
\fIinfo\fR is any of the \fIinfo\fR values from the
.br
	\fBstruct_info type \fItype \fIinfo\fR
.br
command documented further down.
This will work even when the \fIobj\fR has an anonymous type.
.RE
.\" .TP
.\" \fBstruct_info objs\fR ?\fIpattern\fR?
.\" If \fIpattern\fR isn't specified,
.\" returns a list of all the names of currently-visible structure objects,
.\" including both locals and currently-visible globals.
.\" If \fIpattern\fR is specified, only those names matching \fIpattern\fR
.\" are returned.  Matching is determined using the same rules as for
.\" \fBstring match\fR.
.TP
\fBstruct_info patchlevel\fR
Returns the value of the global Tcl variable \fBstruct_patchLevel\fR.
When an interpreter is created tclStruct initializes this variable
to hold a string giving the current patch level for tclStruct.
.TP
\fBstruct_info sizeof \fIobj\fR|\fItype\fR
Returns the size in bytes of the object or type.
.TP
\fBstruct_info type \fItype \fR?\fIinfo\fR?
Returns information on the type \fItype\fR.
Most of the information returned by this command is useful only
when debugging this package.
.RS
.TP
\fBstruct_info type \fItype\fR
If the type \fItype\fR exists then it returns "1", otherwise
it returns "0".
.TP
\fBstruct_info type \fItype \fBaddress\fR
Returns the memory address at which the type structure for
this type is located.
It is returned in a machine dependent format.
.TP
\fBstruct_info type \fItype \fBalign\fR
Returns the required alignment for this type.
.TP
\fBstruct_info type \fItype \fBbasic\fR
If the type \fItype\fR is a basic type it returns "1", otherwise
it returns "0".  A type is \fBbasic\fR if it is a built-in type,
or an array of a built-in type (e.g. a character string) that
is handled specially by the built-in type's conversion routine.
.TP
\fBstruct_info type \fItype \fBbuiltin\fR
If the type \fItype\fR is a built-in type it returns "1", otherwise
it returns "0".  The built-in types are described on the
\fBstructtypes\fR(n) manual page.
Additional built-in types can be added to tclStruct using
the \fBStruct_RegisterBuiltInType\fR(3) function.
.TP
\fBstruct_info type \fItype \fBelemnames\fR
Returns the names of the structure elements if \fItype\fR
is a structure.  If the \fItype\fR is not a structure, or
the structure has no elements, then a null string is returned.
.TP
\fBstruct_info type \fItype \fBelemtype\fR
Returns the type name of the element for arrays and pointers.
If the \fItype\fR is not an array or pointer, or the element type
is anonymous, then a null string is returned.
.TP
\fBstruct_info type \fItype \fBendian\fR
Returns the byte order associated with a binary type.
The endian values returned are "big" or "little",
or "" for non-binary types.
.TP
\fBstruct_info type \fItype \fBfill\fR
Returns the fill string associated with the type.
.TP
\fBstruct_info type \fItype \fBflags\fR
Returns the decimal value of the internal flags associated with
this type.
.\".TP
.\"\fBstruct_info type \fItype \fBjustify\fR
.\"Returns the type of justification for this type.
.\"Its value is one of "left", "right", "center", or "none".
.TP
\fBstruct_info type \fItype \fBkind\fR
The kind of the \fItype\fR.  The possible kinds of a type are:
.RS
.IP "address"
This is a special kind created by the \fB_addr_\fR cast.
.IP "array"
An array of some \fIelemtype\fR.
.IP "builtin"
A built-in type.
.IP "pointer"
A pointer to \fIelemtype\fR.
.IP "struct"
A structure containing delements of \fIelemnames\fR.
.RE
.TP
\fBstruct_info type \fItype \fBname\fR
Returns the typedef'd name of the type.
Returns the empty string if this is an anonymous type.
.TP
\fBstruct_info type \fItype \fBnullok\fR
Returns the state of the nullok flag, either "1" or "0".
.TP
\fBstruct_info type \fItype \fBrefcount\fR
Returns the reference count of the type.  This is the number of active
references to a particular type and is used to free anonymous types
once the last reference to that type is dropped.
.TP
\fBstruct_info type \fItype \fBsize\fR
The size of the \fItype\fR in bytes.
.TP
\fBstruct_info type \fItype \fBstrict\fR
Returns the state of the strict flag, either "1" or "0".
Types with \fBstrict\fR set are subject to more stringent error checking.
.TP
\fBstruct_info type \fItype \fBtraceproc\fR
Returns the address of the C routine to read and write this particular type.
It is returned in a machine dependent format.
.TP
\fBstruct_info type \fItype \fBunsigned\fR
Returns "1" if the type is unsigned,
"0" if the type is signed,
and the empty string if the type has no concept of sign.
.TP
\fBstruct_info type \fItype \fBvarlen\fR
Returns the state of the varlen flag, either "1" or "0".
.RE
.TP
\fBstruct_info typeof \fItype\fR|\fIobj\fR
The typedef name of the \fItype\fR, or the type of \fIobj\fR.
.TP
\fBstruct_info types\fR ?\fIpattern\fR?
If \fIpattern\fR isn't specified,
returns a list of all the typedef'd types.
If \fIpattern\fR is specified, only those names matching \fIpattern\fR
are returned.  Matching is determined using the same rules as for
\fBstring match\fR.
.TP
\fBstruct_info version\fR
Returns the value of the global variable \fBstruct_version\fR.
When an interpreter is created tclStruct initializes this variable
to hold the version number for this version of tclStruct in
the form \fIx.y\fR.  Changes to \fIx\fR represent major changes
with probable incompatibilities and changes to \fIy\fR represent
small enhancements and bug fixes that retain backward compatibility.

.SH KEYWORDS
command, information, struct
