'\" @(#)tclStruct:copy.n	1.2	95/08/29
.so man.macros
.TH struct_copy n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
struct_copy \- Binary copy of structure data
.SH SYNOPSIS
\fBstruct_copy  \fIdestobj\fR|\fIdestobj(elem)  \fIsrcobj\fR|\fIsrcobj(elem)\fR
.BE

.SH DESCRIPTION
.PP
Do a binary copy of data from one structure object to another.
The data is copied from the source object \fIsrcobj\fR to the
destination object \fIdestobj\fR without interpretation or
conversion to its string representation.  The type and size
of the two objects must be identical.
.PP
This command provides an efficient meansto copy structure data.
For example, ``\fBstruct_copy a b\fR'' is much more efficient than
``\fBset a() $b()\fR''.

.SH EXAMPLES
.PP
To make a copy of the object 'important':
.DS
struct_new savedcopy important
struct_copy savedcopy important
.DE
.PP
To copy part of an object use the element name.
This example creates people as an array of person and then
copies person to and from elements of the array:
.DS
struct_new people [struct_info typeof person]*20
struct_copy people(2) person
struct_copy person people(3)
.DE
.PP
Using constructed pointers it is possible to get at the
underlying \fBmemcpy\fR(3C).  Here is a Tcl implementation
of \fBmemcpy\fR:
.DS
proc memcpy {destaddr srcaddr len} {
    struct_copy char*$len#$destaddr char*$len#$srcaddr
}
.DE
.SH KEYWORDS
copy, struct
