/* 
 * strlen.c --
 *
 *	Source code for the "strlen" library routine.
 *		Carl Timmer
 * Copyright (c) 1996 TJNAF
 *
 */

#ifndef lint
static char sccsid[] = "@(#) strlen.c 1.3 96/06/18 11:25:00";
#endif /* not lint */

/*
 *----------------------------------------------------------------------
 *
 * strlen --
 *
 *	Determine the length instance of a null-terminated string 
 *      pointed to by *str.
 *
 * Results:
 *	Returns length of string - 0 if null.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */
#ifdef TCL_VW
#  include <vxWorks.h>
#  include <types/vxTypes.h>
#else
#  include <stdlib.h>
#endif

size_t
strlen(string)
    const char *string;	/* String to search. */
{
    char *a;
    size_t length;

    a      = string;
    length = 0;
    
    if (a == NULL)
	return 0;
	
    while (*a++ != '\0') {
	length += 1;
    }
    return length;
}
