/* # 2 "vme.c" */
/* # 1 "./inc/rol.h" */
/* # 29 */
typedef void (*VOIDFUNCPTR) ();
typedef unsigned long (*FUNCPTR) ();
typedef struct semaphore *SEM_ID;
typedef unsigned long time_t;
static void __download ();
static void __prestart ();
static void __end ();
static void __pause ();
static void __go ();
static void __done ();
static void __status ();
static int theIntHandler ();
/* # 1 "./inc/libpart.h" */
/* # 6 */
/* # 9 */
/* # 13 */
/* # 15 */
extern char	*malloc();
/* # 1 "./inc/mempart.h" */
/* # 4 */
typedef struct danode			       
    {
    struct danode         *n;	               
    struct danode         *p;	               
    struct rol_mem_part   *part;	           
    int                    fd;		       
    char                  *current;	       
    unsigned long          left;	       
    unsigned long          type;               
    unsigned long          source;             
    void                   (*reader)();        
    long                   nevent;             
    unsigned long          length;	       
    unsigned long          data[1];	       
    } DANODE;
typedef struct alist			       
    {
    DANODE        *f;		               
    DANODE        *l;		               
    int            c;			       
    void          (*add_cmd)(void *li);      
    } DALIST;
typedef struct rol_mem_part *ROL_MEM_ID;
typedef struct rol_mem_part{
    DANODE	 node;		 
    DALIST	 list;		 
    char	 name[40];	 
    void         (*free_cmd)();    
    int		 size;		 
    int		 incr;		 
    int		 total;		 
    long         part[1];	 
} ROL_MEM_PART;
/* # 44 */
/* # 49 */
/* # 53 */
/* # 58 */
/* # 60 */
/* # 67 */
/* # 69 */
/* # 71 */
/* # 76 */
/* # 19 "./inc/libpart.h" */
static DALIST  partList;  
libPartInit()
{
   { bzero ( ( char * ) ( & partList ) , sizeof ( DALIST ) ) ; };
}
/* # 32 */
void partIncr (pPart,c)
     ROL_MEM_ID pPart;		 
     int	c;		 
{
  register long *block;
  unsigned bytes;
  int actual = c;		 
  pPart->total += c;
  if ((pPart ==  ( ( void * ) 0 ))||(c == 0)) return;
  while (actual--)
    {
      block = (long *) malloc (pPart->size);
      if (block ==  ( ( void * ) 0 ))
	return;
      bzero((char *) block, pPart->size);
      ((DANODE *)block)->part = pPart;  
{ if ( ! ( & pPart -> list ) -> c ) { ( & pPart -> list ) -> f = ( & pPart -> list ) -> l = ( ( DANODE * ) block ) ; ( ( 
DANODE * ) block ) -> p = 0 ; } else { ( ( DANODE * ) block ) -> p = ( & pPart -> list ) -> l ; ( & pPart -> list ) -> l -> n = ( 
( DANODE * ) block ) ; ( & pPart -> list ) -> l = ( ( DANODE * ) block ) ; } ( ( DANODE * ) block ) -> n = 0 ; ( & pPart 
-> list ) -> c ++ ; if ( ( & pPart -> list ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & pPart -> list ) -> add_cmd ) ) ( ( 
& pPart -> list ) ) ; };     }
}
/* # 58 */
ROL_MEM_ID partCreate (name, size, c, incr)
     char *name;		 
     int size;			 
     int c;			 
     int incr;			 
{
  ROL_MEM_ID pPart;
  pPart = (ROL_MEM_ID) malloc (sizeof(ROL_MEM_PART));
  bzero ((char *) pPart, sizeof(ROL_MEM_PART));
  if (pPart !=  ( ( void * ) 0 ))
    {
       { bzero ( ( char * ) ( & ( pPart -> list ) ) , sizeof ( DALIST ) ) ; };
      pPart->size =  ( size < sizeof ( DANODE ) ? sizeof ( DANODE ) : size );
      pPart->incr =  ( 0 < incr ? incr : 0 ); 
      pPart->total = 0;
      strcpy(pPart->name, name);
      if (name && strlen(name) == 0)
	pPart->name[0] =  ( ( void * ) 0 );
{ if ( ! ( & partList ) -> c ) { ( & partList ) -> f = ( & partList ) -> l = ( ( DANODE * ) pPart ) ; ( ( DANODE * ) 
pPart ) -> p = 0 ; } else { ( ( DANODE * ) pPart ) -> p = ( & partList ) -> l ; ( & partList ) -> l -> n = ( ( DANODE * ) 
pPart ) ; ( & partList ) -> l = ( ( DANODE * ) pPart ) ; } ( ( DANODE * ) pPart ) -> n = 0 ; ( & partList ) -> c ++ ; if ( ( & 
partList ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & partList ) -> add_cmd ) ) ( ( & partList ) ) ; };       partIncr (pPart, c);
      printf("Created new partition -- %s\n",pPart->name);
    }
  return pPart;
}
/* # 90 */
ROL_MEM_ID partFindByName (char *name)
{
  ROL_MEM_ID	pPart = (ROL_MEM_ID)  ( ( & partList ) -> f );
  while (pPart !=  ( ( void * ) 0 ))
    {
      if (pPart->name && strcmp(pPart->name, name) == 0)break;
      pPart = (ROL_MEM_ID)  ( ( ( DANODE * ) pPart ) -> n );
    }
  return (pPart);
}
/* # 108 */
void partFree(ROL_MEM_ID pPart)
{
  DANODE *the_node;
  while (pPart->list.c) {
{ ( the_node ) = 0 ; if ( ( & ( pPart -> list ) ) -> c ) { ( & ( pPart -> list ) ) -> c -- ; ( the_node ) = ( & ( pPart 
-> list ) ) -> f ; ( & ( pPart -> list ) ) -> f = ( & ( pPart -> list ) ) -> f -> n ; } ; if ( ! ( & ( pPart -> list ) ) -> c ) ( 
& ( pPart -> list ) ) -> l = 0 ; };     free(the_node);
    the_node = (DANODE *)0;
  }
{ if ( ( ( DANODE * ) pPart ) -> p ) { ( ( DANODE * ) pPart ) -> p -> n = ( ( DANODE * ) pPart ) -> n ; } else { ( & 
partList ) -> f = ( ( DANODE * ) pPart ) -> n ; } if ( ( ( DANODE * ) pPart ) -> n ) { ( ( DANODE * ) pPart ) -> n -> p = ( ( 
DANODE * ) pPart ) -> p ; } else { ( & partList ) -> l = ( ( DANODE * ) pPart ) -> p ; } ( & partList ) -> c -- ; if ( ( & 
partList ) -> c == 0 ) ( & partList ) -> f = ( & partList ) -> l = ( DANODE * ) 0 ; ( ( DANODE * ) pPart ) -> p = ( ( DANODE * ) 
pPart ) -> n = ( DANODE * ) 0 ; };   free(pPart);
  pPart = 0;
}
/* # 128 */
void partFreeAll()
{
  ROL_MEM_ID	pPart = (ROL_MEM_ID) 0;
  if ( ( ( & partList ) -> c )) {
    pPart = (ROL_MEM_ID)  ( ( & partList ) -> f );    
    while (pPart !=  ( ( void * ) 0 ))
      {
	printf("partFreeAll - Freeing Memory Partition %s \n",pPart->name);
	partFree(pPart);
	pPart = (ROL_MEM_ID)  ( ( & partList ) -> f );
      }
  } else {
    printf("partFreeAll - No Memory Partitions to Free\n");
  }
}
/* # 150 */
static void partHdr ()
{
  printf("Address    total  free  busy   size  incr  (KBytes)  Name\n");
  printf("-------    -----  ----  ----   ----  ----  --------  ----\n");
}
/* # 162 */
static void partPrint (pPart)
     ROL_MEM_ID	pPart;    
{
  int freen;
  printf("0x%08x  ",pPart);
  if (pPart !=  ( ( void * ) 0 ))
    {
      freen =  ( ( & pPart -> list ) -> c ); 
      printf("%4d  %4d  %4d   %4d  %4d  (%d)       %s\n",
	    pPart->total,
	     freen,
	     pPart->total - freen,
	     pPart->size,
	     pPart->incr,
	     (((pPart->total * pPart->size) + 1023) / 1024),
	     pPart->name
	     );
    }
}
/* # 189 */
int partStats (pPart)
     ROL_MEM_ID	pPart;
{
  partHdr ();
  partPrint (pPart);
  return (0);
}
/* # 209 */
int	partStatsAll ()
{
  int lockKey;
  ROL_MEM_ID  pPart;
  partHdr ();
  lockKey = intLock();
  pPart = (ROL_MEM_ID)  ( ( & partList ) -> f );
  while (pPart !=  ( ( void * ) 0 ))
    {
      partPrint (pPart);
      pPart = (ROL_MEM_ID)  ( ( ( DANODE * ) pPart ) -> n );
    }
  intUnlock(lockKey);
  return (0);
}
/* # 231 */
int partPrintList(alist)
     DALIST *alist;
{
  DANODE *theNode;
  printf("dalist->f         %x\n",alist->f);
  printf("dalist->l         %x\n",alist->l);
  printf("dalist->c         %d\n",alist->c);
  theNode =  ( ( alist ) -> f );
  while (theNode) {
    printf ("part %x prev %x self %x next %x left %d fd %d\n",
	    theNode->part,
	    theNode->p,
	    theNode,
	    theNode->n,
	    theNode->left,
	    theNode->fd);
    theNode =  ( ( theNode ) -> n );
  }
  return(0);
}
/* # 48 "./inc/rol.h" */
/* # 1 "./inc/rolInt.h" */
typedef struct rolParameters *rolParam;
typedef struct rolParameters
  {
    char          *name;	      
    char          tclName[20];	       
    char          *listName;	      
    int            runType;	      
    int            runNumber;	      
    VOIDFUNCPTR    rol_code;	      
    int            daproc;	      
    void          *id;		      
    int            nounload;	      
    int            inited;	      
    long          *dabufp;	      
    long          *dabufpi;	      
    ROL_MEM_PART  *pool;              
    ROL_MEM_PART  *output;	      
    ROL_MEM_PART  *input;             
    ROL_MEM_PART  *dispatch;          
    volatile ROL_MEM_PART  *dispQ;    
    unsigned long  recNb;	      
/* # 28 */
    int            wakeup;
/* # 30 */
    char          *usrString;	      
    void          *private;	      
    int            pid;               
    int            poll;              
    int primary;		      
    int doDone;			      
  } ROLPARAMS;
/* # 50 */
/* # 51 "./inc/rol.h" */
extern ROLPARAMS rolP;
static rolParam rol;
static long *bufp;
/* # 1 "./inc/services.h" */
/* # 42 */
/* # 1 "./inc/obj.h" */
/* # 60 */
/* # 1 "./inc/rc.h" */
/* # 26 */
/* # 28 */
/* # 45 */
/* # 62 */
/* # 64 */
/* # 74 */
/* # 77 */
/* # 87 */
/* # 104 */
/* # 111 */
typedef struct rp {
  int a ;
  int b ;
} rpStruct;
typedef struct rp *runparameters;
typedef struct rp rp;
typedef struct reti {
  int a;
  int b;
} retiStruct;
typedef struct arg_rs *retrs;
struct arg_rs {
	int value;
	char *name;
} arg_rsStruct;
typedef struct arg_rs arg_rs;
typedef struct retr {
  int a;
  float b;
} retrStruct;
typedef struct argw_f {
  char *name;
  float value;
} argw_fStruct;
typedef struct argw_i {
  char *name;
  int value;
} argw_iStruct;
typedef struct argw_s {
  char *name;
  char *value;
} argw_sStruct;
extern int xdr_record();
extern int xdr_event();
extern int xdr_rp();
extern int xdr_ri();
extern int xdr_arg_rs();
extern int xdr_retrs();
extern int xdr_rr();
extern int xdr_wf();
extern int xdr_wi();
extern int xdr_ws();
extern int *dacreate();
extern int *daremove();
extern int *dadownload();
extern int *daprestart();
extern int *daend();
extern int *dapause();
extern int *dago();
extern int *daterminate();
extern int *dareport();
extern int daWriteEvent();
extern int rcConnect();
extern struct reti *dareadint();
extern retrs *dareadstring();
extern int daSync();
extern char *rcStates();
extern int *dareqevent();
extern int lastContext();
extern int restoreContext();
extern int daHandleSpy();
/* # 64 "./inc/obj.h" */
/* # 66 */
/* # 72 */
typedef struct classStruct *objClass;
typedef struct classStruct SERVICE;
typedef struct classStruct {
  short     magic;		 
  char     *name;		 
  char     *className;		 
  int       ourId;		 
  int       expId;		 
  rolParam **rol;		 
  char     *rolNames;		 
  int       nrol;		 
  int       action;		 
  int       state;		 
  char     *log;		 
  char     *target;		 
  int       runNumber;		 
  int       runType;		 
} objClassStore;
/* # 44 "./inc/services.h" */
extern SERVICE rc_service_ana_;
extern SERVICE rc_service_eb_;
extern SERVICE rc_service_roc_;
extern SERVICE rc_service_ts_;
/* # 54 */
/* # 57 */
extern void  rcservice_ ( SERVICE * service_name );
extern void  rcexecute_ ( );
/* # 58 "./inc/rol.h" */
/* # 66 */
/* # 70 */
/* # 74 */
/* # 77 */
/* # 79 */
/* # 82 */
/* # 85 */
static int EVENT_type;
static int stream_fd__;
extern int global_env[];
extern long global_env_depth;
extern char *global_routine[100];
extern long evnb;
extern long recPermis;
extern long magic;
extern int doDone;
extern long readout;
extern long data_tx_mode;
extern int async_roc_flag;
extern int rcConnect_mode;
/* # 1 "./inc/BankTools.h" */
/* # 7 */
/* # 14 */
/* # 20 */
/* # 22 */
long *StartOfEvent[ 32 ],event_depth__;
/* # 34 */
/* # 50 */
/* # 57 */
/* # 63 */
/* # 78 */
/* # 90 */
/* # 102 */
/* # 106 */
/* # 108 "./inc/rol.h" */
/* # 113 */
/* # 1 "./inc/trigger_dispatch.h" */
/* # 4 */
/* # 7 */
/* # 12 */
static unsigned char dispatch_busy; 
static int intLockKey,trigId;
static int poolEmpty, NoDone;
static unsigned long theEvMask, currEvMask, currType, evMasks[ 16 ];
static VOIDFUNCPTR wrapperGenerator;
static FUNCPTR trigRtns[ 32 ], syncTRtns[ 32 ], doneRtns[ 32 ], ttypeRtn;
static unsigned long Tcode[ 32 ];
static DANODE *__the_event__, *input_event__;
/* # 34 */
/* # 49 */
/* # 53 */
/* # 55 */
/* # 59 */
/* # 67 */
/* # 71 */
/* # 80 */
/* # 84 */
/* # 86 */
/* # 92 */
/* # 98 */
/* # 100 */
/* # 104 */
/* # 110 */
/* # 126 */
/* # 139 */
/* # 143 */
static void cdodispatch()
{
  unsigned long theType,theSource;
  int ix, go_on;
  DANODE *theNode;
  dispatch_busy = 1;
  go_on = 1;
  while ((rol->dispQ->list.c) && (go_on)) {
{ ( theNode ) = 0 ; if ( ( & rol -> dispQ -> list ) -> c ) { ( & rol -> dispQ -> list ) -> c -- ; ( theNode ) = ( & rol 
-> dispQ -> list ) -> f ; ( & rol -> dispQ -> list ) -> f = ( & rol -> dispQ -> list ) -> f -> n ; } ; if ( ! ( & rol -> 
dispQ -> list ) -> c ) ( & rol -> dispQ -> list ) -> l = 0 ; };     theType = theNode->type;
    theSource = theNode->source;
    if (theEvMask) { 
      if ((theEvMask & (1<<theSource)) && (theType == currType)) {
	theEvMask = theEvMask & ~(1<<theSource);
	input_event__ = theNode;
	rol->dabufpi = (long *) &input_event__->data[1];
	;
	(*theNode->reader)(theType, Tcode[theSource]);
	;
	if (theNode)
	 { { if ( ! ( & theNode -> part -> list ) -> c ) { ( & theNode -> part -> list ) -> f = ( & theNode -> part -> 
list ) -> l = ( theNode ) ; ( theNode ) -> p = 0 ; } else { ( theNode ) -> p = ( & theNode -> part -> list ) -> l ; ( & 
theNode -> part -> list ) -> l -> n = ( theNode ) ; ( & theNode -> part -> list ) -> l = ( theNode ) ; } ( theNode ) -> n = 
0 ; ( & theNode -> part -> list ) -> c ++ ; if ( ( & theNode -> part -> list ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( 
& theNode -> part -> list ) -> add_cmd ) ) ( ( & theNode -> part -> list ) ) ; } ; if ( ( theNode -> part -> 
free_cmd != ( ( void * ) 0 ) ) && ( theNode -> part -> list . c == theNode -> part -> total ) ) ( * ( theNode -> part -> 
free_cmd ) ) ( ) ; }; 	if (!theEvMask) {
	 if (wrapperGenerator) { event_depth__ -- ; * StartOfEvent [ event_depth__ ] = ( long ) ( ( ( char 
* ) ( rol -> dabufp ) ) - ( ( char * ) StartOfEvent [ event_depth__ ] ) ) ; if ( ( * StartOfEvent [ 
event_depth__ ] & 1 ) != 0 ) { ( rol -> dabufp ) = ( ( long * ) ( ( char * ) ( rol -> dabufp ) ) + 1 ) ; * StartOfEvent [ 
event_depth__ ] += 1 ; } ; if ( ( * StartOfEvent [ event_depth__ ] & 2 ) != 0 ) { * StartOfEvent [ event_depth__ ] = * 
StartOfEvent [ event_depth__ ] + 2 ; ( rol -> dabufp ) = ( ( long * ) ( ( short * ) ( rol -> dabufp ) ) + 1 ) ; ; } ; * 
StartOfEvent [ event_depth__ ] = ( ( * StartOfEvent [ event_depth__ ] ) >> 2 ) - 1 ; } ;;	 	 if ( __the_event__ ) { if ( rol -> output ) { * ( rol -> dabufp ) ++ = ( ( 0xcbf00000 ) | ( 0x0300 ) | ( rol 
-> pid & 0xff ) ) ; * ( rol -> dabufp ) ++ = rol -> recNb ; __the_event__ -> length = __the_event__ -> data 
[ 0 ] + 1 ; { if ( ! ( & ( rol -> output -> list ) ) -> c ) { ( & ( rol -> output -> list ) ) -> f = ( & ( rol -> output -> 
list ) ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { ( __the_event__ ) -> p = ( & ( rol -> 
output -> list ) ) -> l ; ( & ( rol -> output -> list ) ) -> l -> n = ( __the_event__ ) ; ( & ( rol -> output -> list ) ) 
-> l = ( __the_event__ ) ; } ( __the_event__ ) -> n = 0 ; ( & ( rol -> output -> list ) ) -> c ++ ; if ( ( & ( rol -> 
output -> list ) ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & ( rol -> output -> list ) ) -> add_cmd ) ) ( ( & ( rol -> 
output -> list ) ) ) ; } ; } else { { { if ( ! ( & __the_event__ -> part -> list ) -> c ) { ( & __the_event__ -> part -> 
list ) -> f = ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { 
( __the_event__ ) -> p = ( & __the_event__ -> part -> list ) -> l ; ( & __the_event__ -> part -> list ) -> 
l -> n = ( __the_event__ ) ; ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; } ( 
__the_event__ ) -> n = 0 ; ( & __the_event__ -> part -> list ) -> c ++ ; if ( ( & __the_event__ -> part -> list ) -> 
add_cmd != ( ( void * ) 0 ) ) ( * ( ( & __the_event__ -> part -> list ) -> add_cmd ) ) ( ( & __the_event__ -> part -> 
list ) ) ; } ; if ( ( __the_event__ -> part -> free_cmd != ( ( void * ) 0 ) ) && ( __the_event__ -> part -> list . 
c == __the_event__ -> part -> total ) ) ( * ( __the_event__ -> part -> free_cmd ) ) ( ) ; } ; } 
__the_event__ = ( DANODE * ) 0 ; }; 	 { int ix ; if ( currEvMask ) for ( ix = 0 ; ix < trigId ; ix ++ ) { if ( currEvMask & ( 1 << ix ) ) ( * doneRtns [ 
ix ] ) ( ) ; } if ( rol -> pool -> list . c ) { currEvMask = 0 ; __done ( ) ; } else { poolEmpty = 1 ; readout = 1 ; 
doDone = 1 ; } }; 	}
      } else {
	 { if ( ! ( & rol -> dispQ -> list ) -> c ) { ( & rol -> dispQ -> list ) -> f = ( & rol -> dispQ -> list ) -> l = ( 
theNode ) ; ( theNode ) -> p = 0 ; } else { ( theNode ) -> p = ( & rol -> dispQ -> list ) -> l ; ( & rol -> dispQ -> list ) -> 
l -> n = ( theNode ) ; ( & rol -> dispQ -> list ) -> l = ( theNode ) ; } ( theNode ) -> n = 0 ; ( & rol -> dispQ -> 
list ) -> c ++ ; if ( ( & rol -> dispQ -> list ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & rol -> dispQ -> list ) -> 
add_cmd ) ) ( ( & rol -> dispQ -> list ) ) ; }; 	go_on = 0;
      }
    } else { 
      if ((1<<theSource) & evMasks[theType]) {
	currEvMask = theEvMask = evMasks[theType];
	currType = theType;
      } else {
        currEvMask = (1<<theSource);
      }
      evnb++;
      if (wrapperGenerator) {
	(*wrapperGenerator)(theType);
      }
      input_event__ = theNode;
      rol->dabufpi = (long *) &input_event__->data[1];
      ;
      (*theNode->reader)(theType, Tcode[theSource]);
      ;
      if (theNode)
	 { { if ( ! ( & theNode -> part -> list ) -> c ) { ( & theNode -> part -> list ) -> f = ( & theNode -> part -> 
list ) -> l = ( theNode ) ; ( theNode ) -> p = 0 ; } else { ( theNode ) -> p = ( & theNode -> part -> list ) -> l ; ( & 
theNode -> part -> list ) -> l -> n = ( theNode ) ; ( & theNode -> part -> list ) -> l = ( theNode ) ; } ( theNode ) -> n = 
0 ; ( & theNode -> part -> list ) -> c ++ ; if ( ( & theNode -> part -> list ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( 
& theNode -> part -> list ) -> add_cmd ) ) ( ( & theNode -> part -> list ) ) ; } ; if ( ( theNode -> part -> 
free_cmd != ( ( void * ) 0 ) ) && ( theNode -> part -> list . c == theNode -> part -> total ) ) ( * ( theNode -> part -> 
free_cmd ) ) ( ) ; };       if (theEvMask) {
	theEvMask = theEvMask & ~(1<<theSource);
      } 
      if (!theEvMask) {
	 if ( __the_event__ ) { if ( rol -> output ) { * ( rol -> dabufp ) ++ = ( ( 0xcbf00000 ) | ( 0x0300 ) | ( rol 
-> pid & 0xff ) ) ; * ( rol -> dabufp ) ++ = rol -> recNb ; __the_event__ -> length = __the_event__ -> data 
[ 0 ] + 1 ; { if ( ! ( & ( rol -> output -> list ) ) -> c ) { ( & ( rol -> output -> list ) ) -> f = ( & ( rol -> output -> 
list ) ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { ( __the_event__ ) -> p = ( & ( rol -> 
output -> list ) ) -> l ; ( & ( rol -> output -> list ) ) -> l -> n = ( __the_event__ ) ; ( & ( rol -> output -> list ) ) 
-> l = ( __the_event__ ) ; } ( __the_event__ ) -> n = 0 ; ( & ( rol -> output -> list ) ) -> c ++ ; if ( ( & ( rol -> 
output -> list ) ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & ( rol -> output -> list ) ) -> add_cmd ) ) ( ( & ( rol -> 
output -> list ) ) ) ; } ; } else { { { if ( ! ( & __the_event__ -> part -> list ) -> c ) { ( & __the_event__ -> part -> 
list ) -> f = ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { 
( __the_event__ ) -> p = ( & __the_event__ -> part -> list ) -> l ; ( & __the_event__ -> part -> list ) -> 
l -> n = ( __the_event__ ) ; ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; } ( 
__the_event__ ) -> n = 0 ; ( & __the_event__ -> part -> list ) -> c ++ ; if ( ( & __the_event__ -> part -> list ) -> 
add_cmd != ( ( void * ) 0 ) ) ( * ( ( & __the_event__ -> part -> list ) -> add_cmd ) ) ( ( & __the_event__ -> part -> 
list ) ) ; } ; if ( ( __the_event__ -> part -> free_cmd != ( ( void * ) 0 ) ) && ( __the_event__ -> part -> list . 
c == __the_event__ -> part -> total ) ) ( * ( __the_event__ -> part -> free_cmd ) ) ( ) ; } ; } 
__the_event__ = ( DANODE * ) 0 ; }; 	 { int ix ; if ( currEvMask ) for ( ix = 0 ; ix < trigId ; ix ++ ) { if ( currEvMask & ( 1 << ix ) ) ( * doneRtns [ 
ix ] ) ( ) ; } if ( rol -> pool -> list . c ) { currEvMask = 0 ; __done ( ) ; } else { poolEmpty = 1 ; readout = 1 ; 
doDone = 1 ; } };       }
    }  
  }
  dispatch_busy = 0;
}
/* # 237 */
static int theIntHandler(int theSource)
{
  if (theSource == 0) return(0);
  {  
    DANODE *theNode;
    ;
{ { ( theNode ) = 0 ; if ( ( & ( rol -> dispatch -> list ) ) -> c ) { ( & ( rol -> dispatch -> list ) ) -> c -- ; ( 
theNode ) = ( & ( rol -> dispatch -> list ) ) -> f ; ( & ( rol -> dispatch -> list ) ) -> f = ( & ( rol -> dispatch -> list 
) ) -> f -> n ; } ; if ( ! ( & ( rol -> dispatch -> list ) ) -> c ) ( & ( rol -> dispatch -> list ) ) -> l = 0 ; } ; };     theNode->source = theSource;
    theNode->type = (*ttypeRtn)();
    theNode->reader = trigRtns[theSource]; 
{ if ( ! ( & rol -> dispQ -> list ) -> c ) { ( & rol -> dispQ -> list ) -> f = ( & rol -> dispQ -> list ) -> l = ( 
theNode ) ; ( theNode ) -> p = 0 ; } else { ( theNode ) -> p = ( & rol -> dispQ -> list ) -> l ; ( & rol -> dispQ -> list ) -> 
l -> n = ( theNode ) ; ( & rol -> dispQ -> list ) -> l = ( theNode ) ; } ( theNode ) -> n = 0 ; ( & rol -> dispQ -> 
list ) -> c ++ ; if ( ( & rol -> dispQ -> list ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & rol -> dispQ -> list ) -> 
add_cmd ) ) ( ( & rol -> dispQ -> list ) ) ; };     if (!dispatch_busy)
      cdodispatch();
    ;
  }
}
static int cdopolldispatch()
{
  unsigned long theSource, theType;
  int stat = 0;
  DANODE *theNode;
  for (theSource=1;theSource<trigId;theSource++){
    if (syncTRtns[theSource]){
      if ( theNode = (*syncTRtns[theSource])()) {
	stat = 1;
	{  
	  ;
	  if (theNode) 
	 { { ( theNode ) = 0 ; if ( ( & ( rol -> dispatch -> list ) ) -> c ) { ( & ( rol -> dispatch -> list ) ) -> c -- ; ( 
theNode ) = ( & ( rol -> dispatch -> list ) ) -> f ; ( & ( rol -> dispatch -> list ) ) -> f = ( & ( rol -> dispatch -> list 
) ) -> f -> n ; } ; if ( ! ( & ( rol -> dispatch -> list ) ) -> c ) ( & ( rol -> dispatch -> list ) ) -> l = 0 ; } ; }; 	  theNode->source = theSource; 
	  theNode->type = (*ttypeRtn)(); 
	  theNode->reader = trigRtns[theSource]; 
	 { if ( ! ( & rol -> dispQ -> list ) -> c ) { ( & rol -> dispQ -> list ) -> f = ( & rol -> dispQ -> list ) -> l = ( 
theNode ) ; ( theNode ) -> p = 0 ; } else { ( theNode ) -> p = ( & rol -> dispQ -> list ) -> l ; ( & rol -> dispQ -> list ) -> 
l -> n = ( theNode ) ; ( & rol -> dispQ -> list ) -> l = ( theNode ) ; } ( theNode ) -> n = 0 ; ( & rol -> dispQ -> 
list ) -> c ++ ; if ( ( & rol -> dispQ -> list ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & rol -> dispQ -> list ) -> 
add_cmd ) ) ( ( & rol -> dispQ -> list ) ) ; }; 	  if (!dispatch_busy) 
	    cdodispatch();
	  ;
	}
      }
    }
  }
  return (stat);
}
/* # 115 "./inc/rol.h" */
/* # 120 */
/* # 127 */
static char rol_name__[40];
static char temp_string__[132];
static unsigned long address___;
static void __poll()
{
     { cdopolldispatch ( ) ; };
}
void  vme__init ( rolp )
     rolParam rolp;
{
      if ((rolp->daproc !=  7 )&&(rolp->daproc !=  6 )) 
	printf("rolp->daproc = %d\n",rolp->daproc);
      switch(rolp->daproc) {
      case  0 :
	{
	  char name[40];
	  printf("__init__ - Initializing new rol structures \n");
	  rol = rolp;
	  stream_fd__ = 0;
	  rolp->inited = 1;
	  printf("rolp->inited %d\n",rolp->inited);
	  strcpy(rol_name__,  "ROC4" );
	  rolp->listName = rol_name__;
	  strcpy(name, rolp->listName);
	  strcat(name, ":pool");
	  rolp->pool  = partCreate(name,  512 , 100 ,0);
	  strcpy(name, rolp->listName);
	  strcat(name, ":dispatch");
	  rolp->dispatch  = partCreate(name, 0, 32, 0);
	  strcpy(name, rolp->listName);
	  strcat(name, ":dispQ");
	  rolp->dispQ = partCreate(name, 0, 0, 0);
	  printf("INFO: __init__ from %s\n",rolp->listName);
	  printf("INFO: done init\n");  
	  break;
	}
      case  9 :
	  rolp->inited = 0;
	break;
      case  1 :
	__download();
	break;
      case  2 :
	__prestart();
	break;
      case  4 :
	__pause();
	break;
      case  3 :
	__end();
	break;
      case  5 :
	__go();
	break;
      case  6 :
	__poll();
	break;
      case  7 :
	__done();
	break;
      default:
	printf("WARN: unsupported action\n");
	break;
      }
}
/* # 203 */
/* # 9 "vme.c" */
long *vme2_ir;
static void __download()
{
daLogMsg("INFO: Readout list compiled %s\n", "Fri Apr 5 14:49:39 EST 1996" ); /* # 14 */
    magic = 1;
/* # 16 */
    async_roc_flag = 0; 
  {   
  vme2_ir = (long *) 0xfff4006c ;
    daLogMsg("INFO: Download Executed\n");
  }   
}       
static void __prestart()
{
{ dispatch_busy = 0 ; bzero ( ( char * ) evMasks , sizeof ( evMasks ) ) ; bzero ( ( char * ) syncTRtns , 
sizeof ( syncTRtns ) ) ; bzero ( ( char * ) Tcode , sizeof ( Tcode ) ) ; wrapperGenerator = 0 ; theEvMask = 0 ; 
currEvMask = 0 ; trigId = 1 ; poolEmpty = 0 ; NoDone = 0 ; __the_event__ = ( DANODE * ) 0 ; };     evnb = 0;
  {   
unsigned long jj, adc_id;
    daLogMsg("INFO: Entering Prestart\n");
  }   
if (__the_event__) if ( __the_event__ ) { if ( rol -> output ) { * ( rol -> dabufp ) ++ = ( ( 0xcbf00000 
) | ( 0x0300 ) | ( rol -> pid & 0xff ) ) ; * ( rol -> dabufp ) ++ = rol -> recNb ; __the_event__ -> length = 
__the_event__ -> data [ 0 ] + 1 ; { if ( ! ( & ( rol -> output -> list ) ) -> c ) { ( & ( rol -> output -> list ) ) -> f = ( & ( rol -> 
output -> list ) ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { ( __the_event__ ) -> p = ( & ( rol 
-> output -> list ) ) -> l ; ( & ( rol -> output -> list ) ) -> l -> n = ( __the_event__ ) ; ( & ( rol -> output -> 
list ) ) -> l = ( __the_event__ ) ; } ( __the_event__ ) -> n = 0 ; ( & ( rol -> output -> list ) ) -> c ++ ; if ( ( & ( 
rol -> output -> list ) ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & ( rol -> output -> list ) ) -> add_cmd ) ) ( ( & ( 
rol -> output -> list ) ) ) ; } ; } else { { { if ( ! ( & __the_event__ -> part -> list ) -> c ) { ( & __the_event__ 
-> part -> list ) -> f = ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> 
p = 0 ; } else { ( __the_event__ ) -> p = ( & __the_event__ -> part -> list ) -> l ; ( & __the_event__ -> 
part -> list ) -> l -> n = ( __the_event__ ) ; ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; } ( 
__the_event__ ) -> n = 0 ; ( & __the_event__ -> part -> list ) -> c ++ ; if ( ( & __the_event__ -> part -> list ) -> 
add_cmd != ( ( void * ) 0 ) ) ( * ( ( & __the_event__ -> part -> list ) -> add_cmd ) ) ( ( & __the_event__ -> part -> 
list ) ) ; } ; if ( ( __the_event__ -> part -> free_cmd != ( ( void * ) 0 ) ) && ( __the_event__ -> part -> list . 
c == __the_event__ -> part -> total ) ) ( * ( __the_event__ -> part -> free_cmd ) ) ( ) ; } ; } 
__the_event__ = ( DANODE * ) 0 ; };     evnb = 0;
    rol->recNb = 0;
}       
static void __end()
{
  {   
{ 
{ long * StartOfBank ; { if ( __the_event__ == ( DANODE * ) 0 ) { { { ( __the_event__ ) = 0 ; if ( ( & ( rol -> 
pool -> list ) ) -> c ) { ( & ( rol -> pool -> list ) ) -> c -- ; ( __the_event__ ) = ( & ( rol -> pool -> list ) ) -> f ; ( 
& ( rol -> pool -> list ) ) -> f = ( & ( rol -> pool -> list ) ) -> f -> n ; } ; if ( ! ( & ( rol -> pool -> list ) ) -> c ) ( 
& ( rol -> pool -> list ) ) -> l = 0 ; } ; } ; rol -> dabufp = ( long * ) & __the_event__ -> data [ 0 ] ; } } ; 
StartOfBank = ( rol -> dabufp ) ; * ( ++ ( rol -> dabufp ) ) = ( ( ( 20 ) << 16 ) | ( 0x01 ) << 8 ) | ( 0xCC ) ; ( ( rol -> dabufp ) ) 
++ ;;    { * ( rol -> dabufp ) ++ = ( 1200 ) ; };
   { * ( rol -> dabufp ) ++ = ( rol -> runNumber ) ; };
   { * ( rol -> dabufp ) ++ = ( evnb ) ; };
* StartOfBank = ( long ) ( ( ( char * ) ( rol -> dabufp ) ) - ( ( char * ) StartOfBank ) ) ; if ( ( * 
StartOfBank & 1 ) != 0 ) { ( rol -> dabufp ) = ( ( long * ) ( ( char * ) ( rol -> dabufp ) ) + 1 ) ; * StartOfBank += 1 ; } ; if ( ( * 
StartOfBank & 2 ) != 0 ) { * StartOfBank = * StartOfBank + 2 ; ( rol -> dabufp ) = ( ( long * ) ( ( short * ) ( rol -> dabufp ) 
) + 1 ) ; ; } ; * StartOfBank = ( ( * StartOfBank ) >> 2 ) - 1 ; } ;;   NoDone = 1;
  readout = 1;
 } 
    daLogMsg("INFO: End Executed\n");
  }   
if (__the_event__) if ( __the_event__ ) { if ( rol -> output ) { * ( rol -> dabufp ) ++ = ( ( 0xcbf00000 
) | ( 0x0300 ) | ( rol -> pid & 0xff ) ) ; * ( rol -> dabufp ) ++ = rol -> recNb ; __the_event__ -> length = 
__the_event__ -> data [ 0 ] + 1 ; { if ( ! ( & ( rol -> output -> list ) ) -> c ) { ( & ( rol -> output -> list ) ) -> f = ( & ( rol -> 
output -> list ) ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { ( __the_event__ ) -> p = ( & ( rol 
-> output -> list ) ) -> l ; ( & ( rol -> output -> list ) ) -> l -> n = ( __the_event__ ) ; ( & ( rol -> output -> 
list ) ) -> l = ( __the_event__ ) ; } ( __the_event__ ) -> n = 0 ; ( & ( rol -> output -> list ) ) -> c ++ ; if ( ( & ( 
rol -> output -> list ) ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & ( rol -> output -> list ) ) -> add_cmd ) ) ( ( & ( 
rol -> output -> list ) ) ) ; } ; } else { { { if ( ! ( & __the_event__ -> part -> list ) -> c ) { ( & __the_event__ 
-> part -> list ) -> f = ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> 
p = 0 ; } else { ( __the_event__ ) -> p = ( & __the_event__ -> part -> list ) -> l ; ( & __the_event__ -> 
part -> list ) -> l -> n = ( __the_event__ ) ; ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; } ( 
__the_event__ ) -> n = 0 ; ( & __the_event__ -> part -> list ) -> c ++ ; if ( ( & __the_event__ -> part -> list ) -> 
add_cmd != ( ( void * ) 0 ) ) ( * ( ( & __the_event__ -> part -> list ) -> add_cmd ) ) ( ( & __the_event__ -> part -> 
list ) ) ; } ; if ( ( __the_event__ -> part -> free_cmd != ( ( void * ) 0 ) ) && ( __the_event__ -> part -> list . 
c == __the_event__ -> part -> total ) ) ( * ( __the_event__ -> part -> free_cmd ) ) ( ) ; } ; } 
__the_event__ = ( DANODE * ) 0 ; }; }  
static void __pause()
{
  {   
{ 
{ long * StartOfBank ; { if ( __the_event__ == ( DANODE * ) 0 ) { { { ( __the_event__ ) = 0 ; if ( ( & ( rol -> 
pool -> list ) ) -> c ) { ( & ( rol -> pool -> list ) ) -> c -- ; ( __the_event__ ) = ( & ( rol -> pool -> list ) ) -> f ; ( 
& ( rol -> pool -> list ) ) -> f = ( & ( rol -> pool -> list ) ) -> f -> n ; } ; if ( ! ( & ( rol -> pool -> list ) ) -> c ) ( 
& ( rol -> pool -> list ) ) -> l = 0 ; } ; } ; rol -> dabufp = ( long * ) & __the_event__ -> data [ 0 ] ; } } ; 
StartOfBank = ( rol -> dabufp ) ; * ( ++ ( rol -> dabufp ) ) = ( ( ( 19 ) << 16 ) | ( 0x01 ) << 8 ) | ( 0xCC ) ; ( ( rol -> dabufp ) ) 
++ ;;    { * ( rol -> dabufp ) ++ = ( 1200 ) ; };
   { * ( rol -> dabufp ) ++ = ( rol -> runNumber ) ; };
   { * ( rol -> dabufp ) ++ = ( evnb ) ; };
* StartOfBank = ( long ) ( ( ( char * ) ( rol -> dabufp ) ) - ( ( char * ) StartOfBank ) ) ; if ( ( * 
StartOfBank & 1 ) != 0 ) { ( rol -> dabufp ) = ( ( long * ) ( ( char * ) ( rol -> dabufp ) ) + 1 ) ; * StartOfBank += 1 ; } ; if ( ( * 
StartOfBank & 2 ) != 0 ) { * StartOfBank = * StartOfBank + 2 ; ( rol -> dabufp ) = ( ( long * ) ( ( short * ) ( rol -> dabufp ) 
) + 1 ) ; ; } ; * StartOfBank = ( ( * StartOfBank ) >> 2 ) - 1 ; } ;;   NoDone = 1;
  readout = 1;
 } 
    daLogMsg("INFO: Pause Executed\n");
  }   
if (__the_event__) if ( __the_event__ ) { if ( rol -> output ) { * ( rol -> dabufp ) ++ = ( ( 0xcbf00000 
) | ( 0x0300 ) | ( rol -> pid & 0xff ) ) ; * ( rol -> dabufp ) ++ = rol -> recNb ; __the_event__ -> length = 
__the_event__ -> data [ 0 ] + 1 ; { if ( ! ( & ( rol -> output -> list ) ) -> c ) { ( & ( rol -> output -> list ) ) -> f = ( & ( rol -> 
output -> list ) ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { ( __the_event__ ) -> p = ( & ( rol 
-> output -> list ) ) -> l ; ( & ( rol -> output -> list ) ) -> l -> n = ( __the_event__ ) ; ( & ( rol -> output -> 
list ) ) -> l = ( __the_event__ ) ; } ( __the_event__ ) -> n = 0 ; ( & ( rol -> output -> list ) ) -> c ++ ; if ( ( & ( 
rol -> output -> list ) ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & ( rol -> output -> list ) ) -> add_cmd ) ) ( ( & ( 
rol -> output -> list ) ) ) ; } ; } else { { { if ( ! ( & __the_event__ -> part -> list ) -> c ) { ( & __the_event__ 
-> part -> list ) -> f = ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> 
p = 0 ; } else { ( __the_event__ ) -> p = ( & __the_event__ -> part -> list ) -> l ; ( & __the_event__ -> 
part -> list ) -> l -> n = ( __the_event__ ) ; ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; } ( 
__the_event__ ) -> n = 0 ; ( & __the_event__ -> part -> list ) -> c ++ ; if ( ( & __the_event__ -> part -> list ) -> 
add_cmd != ( ( void * ) 0 ) ) ( * ( ( & __the_event__ -> part -> list ) -> add_cmd ) ) ( ( & __the_event__ -> part -> 
list ) ) ; } ; if ( ( __the_event__ -> part -> free_cmd != ( ( void * ) 0 ) ) && ( __the_event__ -> part -> list . 
c == __the_event__ -> part -> total ) ) ( * ( __the_event__ -> part -> free_cmd ) ) ( ) ; } ; } 
__the_event__ = ( DANODE * ) 0 ; }; }  
static void __go()
{
  {   
    daLogMsg("INFO: Entering Go\n");
  NoDone = 0;
  }   
if (__the_event__) if ( __the_event__ ) { if ( rol -> output ) { * ( rol -> dabufp ) ++ = ( ( 0xcbf00000 
) | ( 0x0300 ) | ( rol -> pid & 0xff ) ) ; * ( rol -> dabufp ) ++ = rol -> recNb ; __the_event__ -> length = 
__the_event__ -> data [ 0 ] + 1 ; { if ( ! ( & ( rol -> output -> list ) ) -> c ) { ( & ( rol -> output -> list ) ) -> f = ( & ( rol -> 
output -> list ) ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> p = 0 ; } else { ( __the_event__ ) -> p = ( & ( rol 
-> output -> list ) ) -> l ; ( & ( rol -> output -> list ) ) -> l -> n = ( __the_event__ ) ; ( & ( rol -> output -> 
list ) ) -> l = ( __the_event__ ) ; } ( __the_event__ ) -> n = 0 ; ( & ( rol -> output -> list ) ) -> c ++ ; if ( ( & ( 
rol -> output -> list ) ) -> add_cmd != ( ( void * ) 0 ) ) ( * ( ( & ( rol -> output -> list ) ) -> add_cmd ) ) ( ( & ( 
rol -> output -> list ) ) ) ; } ; } else { { { if ( ! ( & __the_event__ -> part -> list ) -> c ) { ( & __the_event__ 
-> part -> list ) -> f = ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; ( __the_event__ ) -> 
p = 0 ; } else { ( __the_event__ ) -> p = ( & __the_event__ -> part -> list ) -> l ; ( & __the_event__ -> 
part -> list ) -> l -> n = ( __the_event__ ) ; ( & __the_event__ -> part -> list ) -> l = ( __the_event__ ) ; } ( 
__the_event__ ) -> n = 0 ; ( & __the_event__ -> part -> list ) -> c ++ ; if ( ( & __the_event__ -> part -> list ) -> 
add_cmd != ( ( void * ) 0 ) ) ( * ( ( & __the_event__ -> part -> list ) -> add_cmd ) ) ( ( & __the_event__ -> part -> 
list ) ) ; } ; if ( ( __the_event__ -> part -> free_cmd != ( ( void * ) 0 ) ) && ( __the_event__ -> part -> list . 
c == __the_event__ -> part -> total ) ) ( * ( __the_event__ -> part -> free_cmd ) ) ( ) ; } ; } 
__the_event__ = ( DANODE * ) 0 ; }; }
void usrtrig(unsigned long EVTYPE,unsigned long EVSOURCE)
{
    long EVENT_LENGTH;
  {   
unsigned long ii, kk, rn, wc, bufp, datascan;
{ { if ( __the_event__ == ( DANODE * ) 0 ) { { { ( __the_event__ ) = 0 ; if ( ( & ( rol -> pool -> list ) ) -> c ) { 
( & ( rol -> pool -> list ) ) -> c -- ; ( __the_event__ ) = ( & ( rol -> pool -> list ) ) -> f ; ( & ( rol -> pool -> 
list ) ) -> f = ( & ( rol -> pool -> list ) ) -> f -> n ; } ; if ( ! ( & ( rol -> pool -> list ) ) -> c ) ( & ( rol -> pool -> 
list ) ) -> l = 0 ; } ; } ; rol -> dabufp = ( long * ) & __the_event__ -> data [ 0 ] ; } } ; StartOfEvent [ 
event_depth__ ++ ] = ( rol -> dabufp ) ; * ( ++ ( rol -> dabufp ) ) = ( ( ( EVTYPE ) << 16 ) | ( 0x01 ) << 8 ) | ( 0xff & evnb ) ; ( ( 
rol -> dabufp ) ) ++ ; };      { * ( rol -> dabufp ) ++ = ( 0xda000000 ) ; }; 
     { * ( rol -> dabufp ) ++ = ( 0xda0000ff ) ; }; 
{ event_depth__ -- ; * StartOfEvent [ event_depth__ ] = ( long ) ( ( ( char * ) ( rol -> dabufp ) ) - ( ( 
char * ) StartOfEvent [ event_depth__ ] ) ) ; if ( ( * StartOfEvent [ event_depth__ ] & 1 ) != 0 ) { ( rol -> 
dabufp ) = ( ( long * ) ( ( char * ) ( rol -> dabufp ) ) + 1 ) ; * StartOfEvent [ event_depth__ ] += 1 ; } ; if ( ( * 
StartOfEvent [ event_depth__ ] & 2 ) != 0 ) { * StartOfEvent [ event_depth__ ] = * StartOfEvent [ event_depth__ ] 
+ 2 ; ( rol -> dabufp ) = ( ( long * ) ( ( short * ) ( rol -> dabufp ) ) + 1 ) ; ; } ; * StartOfEvent [ 
event_depth__ ] = ( ( * StartOfEvent [ event_depth__ ] ) >> 2 ) - 1 ; } ;;   }   
}  
void usrtrig_done()
{
  {   
  }   
}  
void __done()
{
if (NoDone) {
   NoDone = 0;
   return;
}
  {   
  }   
}  
static void __status()
{
  {   
  }   
}  
#ident "acomp: SC3.0.1 13 Jul 1994 Sun C 3.0.1"
