/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA readout langugae compiler supporting routines
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: rol_sup.c,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:53  heyes
 *   Imported sources
 *
 *	  Revision 1.1  1994/07/07  13:58:23  chen
 *	  Initial revision
 *
 *	  
 */
#include <stdio.h>
#include <string.h>

/* convert CRL syntax inside quoted string */
void print_out(file, log, var_name,type)
     FILE *file;
     char *log;
     char *var_name; /* argument list */
     int  type;
{
  char *p, *q;
  char replace[256];

  bzero (replace, sizeof(replace));
  p = log;
  q = replace;
  /* scan over original string */
  while (*p != '\0'){
    if (*p == 'H'){
      if(*(p+1) == '8'){
	strcat(q,"0x%-10.8x");
	q += 9;
	p += 2;
      }
      else if(*(p+1) == '4'){
	strcat(q,"0x%-10.4x");
	q += 9;
	p += 2;
      }
      else{
	*q = *p;
	q++;
	p++;
      }
    }
    else if(*p == 'I'){
      if (*(p+1) == '8'){
	strcat(q,"%d");
	q += 2;
	p += 2;
      }
      else if (*(p+1) == '4'){
	strcat(q,"%d");
	q += 2;
	p += 2;
      }
      else{
	*q = *p;
	q++;
	p++;
      }
    }
    else{
      *q = *p;
      p++;
      q++;
    }
  }
  *q = '\0';
  switch(type){
  case 0:
    fprintf(file,"    daLogMsg(\" %s \\n \",%s);\n",
	    replace, var_name);
    break;
  case 1:
    fprintf(file,"    daLogMsg(\"INFO: %s \\n \",%s);\n",
	    replace, var_name);
    break;
  case 2:
    fprintf(file,"    daLogMsg(\"WARN: %s \\n \",%s);\n",
	    replace, var_name);
    break;
  case 3:
    fprintf(file,"    daLogMsg(\"ALRM: %s \\n \",%s);\n",
	    replace, var_name);
    break;
  default:
    break;
  }
  /* free memory allocated for var_name */
  free (var_name);
}
