/* z8536.h - zilog CIO (counter,timer,parallel i/o chip) */

/* Copyright 1984-1990 Wind River Systems, Inc. */

/*
modification history
--------------------
01d,05oct90,shl  added copyright notice.
                 made #endif ANSI style.
01c,10jan90,shl  merged with z8036.h.
01b,11sep89,dab  changed U8 to UTINY.
01a,10aug88,rml  written
*/

/* Note: in the following, the value '0x00' has been replaced by 'ZERO'.
   This has been done to provide a way to avoid the 'clr.b' instruction
   on the 68000/10 cpu. 'ZERO' should be defined to be a memory location
   which holds the value '0x00', this will cause compilers to generate
   memory to memory transfers rather than clear instructions. */

#ifndef INCz8536h
#define INCz8536h

/* internal register addresses */

#define  ZCIO_MIC          ((UTINY) ZERO)  /* Master Interrupt Control */
#define  ZCIO_MCC          ((UTINY) 0x01)  /* Master Configuration Control */
#define  ZCIO_PAIV         ((UTINY) 0x02)  /* Port A Interrupt Vector */
#define  ZCIO_PBIV         ((UTINY) 0x03)  /* Port B Interrupt Vector */
#define  ZCIO_CTIV         ((UTINY) 0x04)  /* Counter/Timer Interrupt Vector */

#define  ZCIO_PCDPP        ((UTINY) 0x05)  /* Port C Data Path Polarity */
#define  ZCIO_PCDD         ((UTINY) 0x06)  /* Port C Data Direction */
#define  ZCIO_PCSIOC       ((UTINY) 0x07)  /* Port C Special I/O Control */
#define  ZCIO_PACS         ((UTINY) 0x08)  /* Port A Command and Status */
#define  ZCIO_PBCS         ((UTINY) 0x09)  /* Port B Command and Status */

#define  ZCIO_CT1CS        ((UTINY) 0x0a)  /* C/T 1 Command and Status */
#define  ZCIO_CT2CS        ((UTINY) 0x0b)  /* C/T 2 Command and Status */
#define  ZCIO_CT3CS        ((UTINY) 0x0c)  /* C/T 3 Command and Status */

#define  ZCIO_PAD          ((UTINY) 0x0d)  /* Port A Data */
#define  ZCIO_PBD          ((UTINY) 0x0e)  /* Port B Data */
#define  ZCIO_PCD          ((UTINY) 0x0f)  /* Port C Data */

#define  ZCIO_CT1CCMSB     ((UTINY) 0x10)  /* C/T 1 Current Count (MS Byte) */
#define  ZCIO_CT1CCLSB     ((UTINY) 0x11)  /* C/T 1 Current Count (LS Byte) */
#define  ZCIO_CT2CCMSB     ((UTINY) 0x12)  /* C/T 2 Current Count (MS Byte) */
#define  ZCIO_CT2CCLSB     ((UTINY) 0x13)  /* C/T 2 Current Count (LS Byte) */
#define  ZCIO_CT3CCMSB     ((UTINY) 0x14)  /* C/T 3 Current Count (MS Byte) */
#define  ZCIO_CT3CCLSB     ((UTINY) 0x15)  /* C/T 3 Current Count (LS Byte) */

#define  ZCIO_CT1TCMSB     ((UTINY) 0x16)  /* C/T 1 Time Constant (MS Byte) */
#define  ZCIO_CT1TCLSB     ((UTINY) 0x17)  /* C/T 1 Time Constant (LS Byte) */
#define  ZCIO_CT2TCMSB     ((UTINY) 0x18)  /* C/T 2 Time Constant (MS Byte) */
#define  ZCIO_CT2TCLSB     ((UTINY) 0x19)  /* C/T 2 Time Constant (LS Byte) */
#define  ZCIO_CT3TCMSB     ((UTINY) 0x1a)  /* C/T 3 Time Constant (MS Byte) */
#define  ZCIO_CT3TCLSB     ((UTINY) 0x1b)  /* C/T 3 Time Constant (LS Byte) */

#define  ZCIO_CT1MS        ((UTINY) 0x1c)  /* C/T 1 Mode Specification */
#define  ZCIO_CT2MS        ((UTINY) 0x1d)  /* C/T 2 Mode Specification */
#define  ZCIO_CT3MS        ((UTINY) 0x1e)  /* C/T 3 Mode Specification */

#define  ZCIO_CV           ((UTINY) 0x1f)  /* Current Vector */

#define  ZCIO_PAMS         ((UTINY) 0x20)  /* Port A Mode Specification */
#define  ZCIO_PAHS         ((UTINY) 0x21)  /* Port A Handshake Specification */
#define  ZCIO_PADPP        ((UTINY) 0x22)  /* Port A Data Path Polarity */
#define  ZCIO_PADD         ((UTINY) 0x23)  /* Port A Data Direction */
#define  ZCIO_PASIOC       ((UTINY) 0x24)  /* Port A Special I/O Control */
#define  ZCIO_PAPP         ((UTINY) 0x25)  /* Port A Pattern Polarity */
#define  ZCIO_PAPT         ((UTINY) 0x26)  /* Port A Pattern Transition */
#define  ZCIO_PAPM         ((UTINY) 0x27)  /* Port A Pattern Mask */

#define  ZCIO_PBMS         ((UTINY) 0x28)  /* Port B Mode Specification */
#define  ZCIO_PBHS         ((UTINY) 0x29)  /* Port B Handshake Specification */
#define  ZCIO_PBDPP        ((UTINY) 0x2a)  /* Port B Data Path Polarity */
#define  ZCIO_PBDD         ((UTINY) 0x2b)  /* Port B Data Direction */
#define  ZCIO_PBSIOC       ((UTINY) 0x2c)  /* Port B Special I/O Control */
#define  ZCIO_PBPP         ((UTINY) 0x2d)  /* Port B Pattern Polarity */
#define  ZCIO_PBPT         ((UTINY) 0x2e)  /* Port B Pattern Transition */
#define  ZCIO_PBPM         ((UTINY) 0x2f)  /* Port B Pattern Mask */


/* If a particular CPU board uses Zilog 8036 counter/timer/parallel I/O chip,
 * Z8036 should be defined in {target}/sysLib.h. */

#ifdef Z8036

#define  Z8036_MIC(base)          ((char *) ((base) + ZCIO_MIC))
#define  Z8036_MCC(base)          ((char *) ((base) + ZCIO_MCC))
#define  Z8036_PAIV(base)         ((char *) ((base) + ZCIO_PAIV))
#define  Z8036_PBIV(base)         ((char *) ((base) + ZCIO_PBIV))
#define  Z8036_CTIV(base)         ((char *) ((base) + ZCIO_CTIV))
#define  Z8036_PCDPP(base)        ((char *) ((base) + ZCIO_PCDPP))
#define  Z8036_PCDD(base)         ((char *) ((base) + ZCIO_PCDD))
#define  Z8036_PCSIOC(base)       ((char *) ((base) + ZCIO_PCSIOC))
#define  Z8036_PACS(base)         ((char *) ((base) + ZCIO_PACS))
#define  Z8036_PBCS(base)         ((char *) ((base) + ZCIO_PBCS))
#define  Z8036_CT1CS(base)        ((char *) ((base) + ZCIO_CT1CS))
#define  Z8036_CT2CS(base)        ((char *) ((base) + ZCIO_CT2CS))
#define  Z8036_CT3CS(base)        ((char *) ((base) + ZCIO_CT3CS))
#define  Z8036_PAD(base)          ((char *) ((base) + ZCIO_PAD))
#define  Z8036_PBD(base)          ((char *) ((base) + ZCIO_PBD))
#define  Z8036_PCD(base)          ((char *) ((base) + ZCIO_PCD))
#define  Z8036_CT1CCMSB(base)     ((char *) ((base) + ZCIO_CT1CCMSB))
#define  Z8036_CT1CCLSB(base)     ((char *) ((base) + ZCIO_CT1CCLSB))
#define  Z8036_CT2CCMSB(base)     ((char *) ((base) + ZCIO_CT2CCMSB))
#define  Z8036_CT2CCLSB(base)     ((char *) ((base) + ZCIO_CT2CCLSB))
#define  Z8036_CT3CCMSB(base)     ((char *) ((base) + ZCIO_CT3CCMSB))
#define  Z8036_CT3CCLSB(base)     ((char *) ((base) + ZCIO_CT3CCLSB))
#define  Z8036_CT1TCMSB(base)     ((char *) ((base) + ZCIO_CT1TCMSB))
#define  Z8036_CT1TCLSB(base)     ((char *) ((base) + ZCIO_CT1TCLSB))
#define  Z8036_CT2TCMSB(base)     ((char *) ((base) + ZCIO_CT2TCMSB))
#define  Z8036_CT2TCLSB(base)     ((char *) ((base) + ZCIO_CT2TCLSB))
#define  Z8036_CT3TCMSB(base)     ((char *) ((base) + ZCIO_CT3TCMSB))
#define  Z8036_CT3TCLSB(base)     ((char *) ((base) + ZCIO_CT3TCLSB))
#define  Z8036_CT1MS(base)        ((char *) ((base) + ZCIO_CT1MS))
#define  Z8036_CT2MS(base)        ((char *) ((base) + ZCIO_CT2MS))
#define  Z8036_CT3MS(base)        ((char *) ((base) + ZCIO_CT3MS))
#define  Z8036_CV(base)           ((char *) ((base) + ZCIO_CV))
#define  Z8036_PAMS(base)         ((char *) ((base) + ZCIO_PAMS))
#define  Z8036_PAHS(base)         ((char *) ((base) + ZCIO_PAHS))
#define  Z8036_PADPP(base)        ((char *) ((base) + ZCIO_PADPP))
#define  Z8036_PADD(base)         ((char *) ((base) + ZCIO_PADD))
#define  Z8036_PASIOC(base)       ((char *) ((base) + ZCIO_PASIOC))
#define  Z8036_PAPP(base)         ((char *) ((base) + ZCIO_PAPP))
#define  Z8036_PAPT(base)         ((char *) ((base) + ZCIO_PAPT))
#define  Z8036_PAPM(base)         ((char *) ((base) + ZCIO_PAPM))
#define  Z8036_PBMS(base)         ((char *) ((base) + ZCIO_PBMS))
#define  Z8036_PBHS(base)         ((char *) ((base) + ZCIO_PBHS))
#define  Z8036_PBDPP(base)        ((char *) ((base) + ZCIO_PBDPP))
#define  Z8036_PBDD(base)         ((char *) ((base) + ZCIO_PBDD))
#define  Z8036_PBSIOC(base)       ((char *) ((base) + ZCIO_PBSIOC))
#define  Z8036_PBPP(base)         ((char *) ((base) + ZCIO_PBPP))
#define  Z8036_PBPT(base)         ((char *) ((base) + ZCIO_PBPT))
#define  Z8036_PBPM(base)         ((char *) ((base) + ZCIO_PBPM))

#endif	/* Z8036 */


/*  Counter/Timer Mode Specification register values (C/T 1, 2 and 3) */

#define  ZCIO_CTMS_DCS_PO  ((UTINY) ZERO)  /* Pulse Output */
#define  ZCIO_CTMS_DCS_OSO ((UTINY) 0x01)  /* One-Shot Output */
#define  ZCIO_CTMS_DCS_SWO ((UTINY) 0x02)  /* Square-Wave Output */
#define  ZCIO_CTMS_DCS     ((UTINY) 0x03)  /* output Duty Cycle Selects */
#define  ZCIO_CTMS_REB     ((UTINY) 0x04)  /* Retrigger Enable Bit */
#define  ZCIO_CTMS_EGE     ((UTINY) 0x08)  /* External Gate Enable */
#define  ZCIO_CTMS_ETE     ((UTINY) 0x10)  /* External Trigger Enable */
#define  ZCIO_CTMS_ECE     ((UTINY) 0x20)  /* External Count Enable */
#define  ZCIO_CTMS_EOE     ((UTINY) 0x40)  /* External Output Enable */
#define  ZCIO_CTMS_CSC     ((UTINY) 0x80)  /* Continuous Single Cycle */


/* Master Configuration Control register values */

#define  ZCIO_MCC_PLC_IND  ((UTINY) ZERO)  /* port A and B INDependent */
#define  ZCIO_MCC_LC_IND   ((UTINY) ZERO)  /* counter/timers INDependent */
#define  ZCIO_MCC_LC_GATE  ((UTINY) 0x01)  /* ct1 output GATEs ct2 */
#define  ZCIO_MCC_LC_TRIG  ((UTINY) 0x02)  /* ct1 output TRIGgers ct2 */
#define  ZCIO_MCC_LC_CNT   ((UTINY) 0x03)  /* ct1 output is ct2 CouNT input */
#define  ZCIO_MCC_LC       ((UTINY) 0x03)  /* counter/timer Link Controls */
#define  ZCIO_MCC_PAE      ((UTINY) 0x04)  /* Port A Enable */
#define  ZCIO_MCC_PLC      ((UTINY) 0x08)  /* Port Link Control */
#define  ZCIO_MCC_PLC_LNK  ((UTINY) 0x08)  /* port A and B are LiNKed */
#define  ZCIO_MCC_CT3PCE   ((UTINY) 0x10)  /* C/T 3 and Port C Enable */
#define  ZCIO_MCC_CT2E     ((UTINY) 0x20)  /* Counter/Timer 2 Enable */
#define  ZCIO_MCC_CT1E     ((UTINY) 0x40)  /* Counter/Timer 1 Enable */
#define  ZCIO_MCC_PBE      ((UTINY) 0x80)  /* Port B Enable */


/* Master Interrupt Control register values */

#define  ZCIO_MIC_RESET    ((UTINY) 0x01)  /* device RESET */
#define  ZCIO_MIC_RJ       ((UTINY) 0x02)  /* Right Just */
#define  ZCIO_MIC_CTVIS    ((UTINY) 0x04)  /* C/T Vector Includes Status */
#define  ZCIO_MIC_PBVIS    ((UTINY) 0x08)  /* Port B Vector Includes Status */
#define  ZCIO_MIC_PAVIS    ((UTINY) 0x10)  /* Port A Vector Includes Status */
#define  ZCIO_MIC_NV       ((UTINY) 0x20)  /* No Vector */
#define  ZCIO_MIC_DLC      ((UTINY) 0x40)  /* Disable Lower Chain */
#define  ZCIO_MIC_MIE      ((UTINY) 0x80)  /* Master Interrupt Enable */


/* Command and Status resigter values (port A and B and C/T 1, 2 and 3) */

#define  ZCIO_CS_NC        ((UTINY) ZERO)  /* Null Code */
#define  ZCIO_CS_CIP       ((UTINY) 0x01)  /* Count In Progress */
#define  ZCIO_CS_IOE       ((UTINY) 0x01)  /* Interrupt On Error */
#define  ZCIO_CS_TCB       ((UTINY) 0x02)  /* Trigger Command Bit */
#define  ZCIO_CS_PMF       ((UTINY) 0x02)  /* Pattern Match Flag */
#define  ZCIO_CS_IRF       ((UTINY) 0x04)  /* Input Register Full */
#define  ZCIO_CS_GCB       ((UTINY) 0x04)  /* Gate Command Bit */
#define  ZCIO_CS_RCC       ((UTINY) 0x08)  /* Read Counter Control */
#define  ZCIO_CS_ORE       ((UTINY) 0x08)  /* Output Register Empty */
#define  ZCIO_CS_ERR       ((UTINY) 0x10)  /* interrupt ERRor */
#define  ZCIO_CS_IP        ((UTINY) 0x20)  /* Interrupt Pending */
#define  ZCIO_CS_CLIPIUS   ((UTINY) 0x20)  /* CLear IP and IUS */
#define  ZCIO_CS_IE        ((UTINY) 0x40)  /* Interrupt Enable */
#define  ZCIO_CS_SIUS      ((UTINY) 0x40)  /* Set Interrupt Under Service */
#define  ZCIO_CS_CLIUS     ((UTINY) 0x60)  /* CLear Interrupt Under Service */
#define  ZCIO_CS_IUS       ((UTINY) 0x80)  /* Interrupt Under Service */
#define  ZCIO_CS_SIP       ((UTINY) 0x80)  /* Set Interrupt Pending */
#define  ZCIO_CS_CLIP      ((UTINY) 0xa0)  /* CLear Interrupt Pending */
#define  ZCIO_CS_SIE       ((UTINY) 0xc0)  /* Set Interrupt Enable */
#define  ZCIO_CS_CLIE      ((UTINY) 0xe0)  /* CLear Interrupt Enable */


/* Data Direction register values (port A, B and C) */

#define  ZCIO_DD_OUT       ((UTINY) ZERO)  /* OUTput bit */
#define  ZCIO_DD_IN        ((UTINY) 0xff)  /* INput bit */


/* Data Path Polarity register values (port A, B and C) */

#define  ZCIO_DPP_NONINV   ((UTINY) ZERO)  /* NON-INVerting */
#define  ZCIO_DPP_INVERT   ((UTINY) 0xff)  /* INVerting */


/* Port Handshake Specification register values (port A and B) */

#define  ZCIO_PHS_RWS_RWD  ((UTINY) ZERO)  /* Request/Wait Disabled */
#define  ZCIO_PHS_DTS_2    ((UTINY) ZERO)  /* 2 PCLK cycles */
#define  ZCIO_PHS_HTS_IH   ((UTINY) ZERO)  /* Interlocked Handshake */
#define  ZCIO_PHS_DTS_4    ((UTINY) 0x01)  /* 4 PCLK cycles */
#define  ZCIO_PHS_DTS_6    ((UTINY) 0x02)  /* 6 PCLK cycles */
#define  ZCIO_PHS_DTS_8    ((UTINY) 0x03)  /* 8 PCLK cycles */
#define  ZCIO_PHS_DTS_10   ((UTINY) 0x04)  /* 10 PCLK cycles */
#define  ZCIO_PHS_DTS_12   ((UTINY) 0x05)  /* 12 PCLK cycles */
#define  ZCIO_PHS_DTS_14   ((UTINY) 0x06)  /* 14 PCLK cycles */
#define  ZCIO_PHS_DTS      ((UTINY) 0x07)  /* Deskew Time Specification */
#define  ZCIO_PHS_DTS_16   ((UTINY) 0x07)  /* 16 PCLK cycles */
#define  ZCIO_PHS_RWS_OW   ((UTINY) 0x08)  /* Output Wait */
#define  ZCIO_PHS_RWS_IW   ((UTINY) 0x18)  /* Input Wait */
#define  ZCIO_PHS_RWS_SR   ((UTINY) 0x20)  /* Special Request */
#define  ZCIO_PHS_RWS_OR   ((UTINY) 0x28)  /* Output Request */
#define  ZCIO_PHS_RWS_IR   ((UTINY) 0x38)  /* Input Request */
#define  ZCIO_PHS_RWS      ((UTINY) 0x38)  /* Request/Wait Specification */
#define  ZCIO_PHS_HTS_SH   ((UTINY) 0x40)  /* Strobed Handshake */
#define  ZCIO_PHS_HTS_PH   ((UTINY) 0x80)  /* Pulsed Handshake */
#define  ZCIO_PHS_HTS_3WH  ((UTINY) 0xc0)  /* 3-Wire Handshake */
#define  ZCIO_PHS_HTS      ((UTINY) 0xc0)  /* Handshake Type Specification */


/* Interrupt Vector register values (port A and B and C/Ts) */

#define  ZCIO_IV_ERR       ((UTINY) ZERO)  /* Error */
#define  ZCIO_IV_CT3       ((UTINY) ZERO)  /* Counter/Timer 3 */
#define  ZCIO_IV_CT2       ((UTINY) 0x02)  /* Counter/Timer 2 */
#define  ZCIO_IV_PMF       ((UTINY) 0x02)  /* Pattern Match Flag */
#define  ZCIO_IV_IRF       ((UTINY) 0x04)  /* Input Register Full */
#define  ZCIO_IV_CT1       ((UTINY) 0x04)  /* Counter/Timer 1 */
#define  ZCIO_IV_CTE       ((UTINY) 0x06)  /* Counter/Timer Error */
#define  ZCIO_IV_ORE       ((UTINY) 0x08)  /* Output Register Empty */


/* Port Mode Specification register values (port A and B) */

#define  ZCIO_PMS_PTS_BIT  ((UTINY) ZERO)  /* BIT port */
#define  ZCIO_PMS_PMS_DPM  ((UTINY) ZERO)  /* Disable Pattern Match */
#define  ZCIO_PMS_LPM      ((UTINY) 0x01)  /* Latch on Pattern Match */
#define  ZCIO_PMS_DTE      ((UTINY) 0x01)  /* Deskew Timer Enable */
#define  ZCIO_PMS_PMS_AND  ((UTINY) 0x02)  /* "AND" mode */
#define  ZCIO_PMS_PMS_OR   ((UTINY) 0x04)  /* "OR" mode */
#define  ZCIO_PMS_PMS      ((UTINY) 0x06)  /* Pattern Mode Specification */
#define  ZCIO_PMS_PMS_PEV  ((UTINY) 0x06)  /* "Priority Encoded Vector" mode */
#define  ZCIO_PMS_IMO      ((UTINY) 0x08)  /* Interrupt on Match Only */
#define  ZCIO_PMS_SB       ((UTINY) 0x10)  /* Single Buffered mode */
#define  ZCIO_PMS_ITB      ((UTINY) 0x20)  /* Interrupt on Two Bytes */
#define  ZCIO_PMS_PTS_IN   ((UTINY) 0x40)  /* INput port */
#define  ZCIO_PMS_PTS_OUT  ((UTINY) 0x80)  /* OUTput port */
#define  ZCIO_PMS_PTS_BI   ((UTINY) 0xc0)  /* BIdirectal port */
#define  ZCIO_PMS_PTS      ((UTINY) 0xc0)  /* Port Type Select */


/* Pattern Mask resigter values (port A and B) */

#define  ZCIO_PM_OFF       ((UTINY) ZERO)  /* Bit Masked Off (X) */
#define  ZCIO_PM_ANY       ((UTINY) ZERO)  /* Any Transition (^ or v) */
#define  ZCIO_PM_ZERO      ((UTINY) 0xff)  /* Zero (0) */
#define  ZCIO_PM_ONE       ((UTINY) 0xff)  /* One (1) */
#define  ZCIO_PM_0TO1      ((UTINY) 0xff)  /* Zero to One Transition (^) */
#define  ZCIO_PM_1TO0      ((UTINY) 0xff)  /* One to Zero Transition (v) */

/* Pattern Polarity register values (port A and B) */

#define  ZCIO_PP_OFF       ((UTINY) ZERO)  /* Bit Masked Off (X) */
#define  ZCIO_PP_ANY       ((UTINY) ZERO)  /* Any Transition (^ or v) */
#define  ZCIO_PP_ZERO      ((UTINY) ZERO)  /* Zero (0) */
#define  ZCIO_PP_1TO0      ((UTINY) ZERO)  /* One to Zero Transition (v) */
#define  ZCIO_PP_ONE       ((UTINY) 0xff)  /* One (1) */
#define  ZCIO_PP_0TO1      ((UTINY) 0xff)  /* Zero to One Transition (^) */

/* Pattern Transition register values (port A and B) */

#define  ZCIO_PT_OFF       ((UTINY) ZERO)  /* Bit Masked Off (X) */
#define  ZCIO_PT_ZERO      ((UTINY) ZERO)  /* Zero (0) */
#define  ZCIO_PT_ONE       ((UTINY) ZERO)  /* One (1) */
#define  ZCIO_PT_ANY       ((UTINY) 0xff)  /* Any Transition (^ or v) */
#define  ZCIO_PT_1TO0      ((UTINY) 0xff)  /* One to Zero Transition (v) */
#define  ZCIO_PT_0TO1      ((UTINY) 0xff)  /* Zero to One Transition (^) */

/* Special I/O Control register values (port A B and C) */

#define  ZCIO_SIO_NORMAL   ((UTINY) ZERO)  /* NORMAL input or output */
#define  ZCIO_SIO_ODRAIN   ((UTINY) 0xff)  /* output with Open DRAIN */
#define  ZCIO_SIO_1CATCH   ((UTINY) 0xff)  /* input with 1's CATCHer */

#endif	
