/* 
 Trigger dispatch Macros for multiple trigger sources in CODA.
*/
#ifndef __TRIGGER_DISPATCH

#define __TRIGGER_DISPATCH

/* private global */

#define MAXSRC    32
#define MAXETY    16

static unsigned char dispatch_busy, currType; 

static int intLockKey,trigId;

static unsigned long theEvMask, currEvMask, evMasks[MAXETY];

static VOIDFUNCPTR wrapperGenerator;

static FUNCPTR trigRtns[MAXSRC], syncTRtns[MAXSRC], doneRtns[MAXSRC];

static unsigned long Tcode[MAXSRC];

static NODE *__the_event__, *input_event__;


/* 
   Clear some global variables etc for a clean start.
*/

#define CTRIGINIT \
{ \
    dispatch_busy = 0; \
    bzero((char *) evMasks, sizeof(evMasks)); \
    bzero((char *) syncTRtns, sizeof(syncTRtns)); \
    bzero((char *) Tcode, sizeof(Tcode)); \
    wrapperGenerator = 0; \
    theEvMask = 0; \
    currEvMask = 0; \
    trigId = 1; \
    __the_event__ = (NODE *) 0;\
}

/*
   Register a procedure to do the wrapping NULL = don't wrap
   */

#define CRWRAPP(p) {wrapperGenerator = (p);}

#ifdef VXWORKS
#define LOCKINTS intLockKey = intLock();
#else
#define LOCKINTS
#endif

#ifdef VXWORKS
#define UNLOCKINTS intUnlock(intLockKey);
#else
#define UNLOCKINTS
#endif

#define CDOPOLL {cdopolldispatch();DO_DONE__;}

/*
   Actually dispatch the triggers to the correct routines.
   */


#define DO_DONE__  {int ix; \
                    if (currEvMask) \
                      if (rol->pool->list.c) { \
                        for (ix=0; ix < trigId; ix++) \
                        if (currEvMask & (1<<ix)) (*doneRtns[ix])(currType,Tcode[ix]); \
                        currEvMask = 0; \
                      } \
		  }


#define WRITE_EVENT_   if (__the_event__) { \
					      if (rol->output) { \
								   listAdd(&(rol->output->list),__the_event__); \
					      } else {  \
							  if (stream_fd__ > 0) {\
										  __the_event__->data[0] = _service.ourId; \
										  __the_event__->length = __the_event__->data[1] +2; \
										  if (stream_io_write(stream_fd__,__the_event__) <0 ) RECOVER; \
							  } else { \
								     partFreeItem(__the_event__);\
								 } \
						      } \
					      __the_event__ = (NODE *) 0; \
					  }


static void cdodispatch()
{
  unsigned char theType,theSource;
  int ix;
  unsigned char loopTimes = rol->dispQ->list.c;
  NODE *theNode;

  dispatch_busy = 1;

  /* While there are events */

  while (loopTimes--) {

    /* dequeue off head */
    listGet(&rol->dispQ->list, theNode);
    theType = theNode->type;
    theSource = theNode->source;
    if (theEvMask) { 
      /* We are already in an event */
      /* is this source required for this event ? */
      if ((theEvMask & (1<<theSource)) && (theType == currType)) {
	/* yes */
	/* remember we have seen it! */
	theEvMask = theEvMask & ~(1<<theSource);
	input_event__ = theNode;
	rol->dabufpi = (long *) &input_event__->data[1]
	/* drop int level */
	UNLOCKINTS;
	/* call the routine */
	(*theNode->reader)(theType, Tcode[theSource]);
	/* lock ints again */
	LOCKINTS;
	/* done with this trigger */
	if (theNode)
	  partFreeItem(theNode);
	if (!theEvMask) {
	  if (wrapperGenerator) CECLOSE;	    /* if we called a wrap routine close the bank */
	  WRITE_EVENT_;
	  DO_DONE__;
	}
      } else {
	/* no so requeue on tail*/
	listAdd(&rol->dispQ->list, theNode);
      }
    } else { 
      /* We are not in an event */
      /* get a new buffer... */

      if ((1<<theSource) & evMasks[theType]) {
	currEvMask = theEvMask = evMasks[theType];
	currType = theType;
      } else {
        currEvMask = (1<<theSource);
      }
      evnb++;
      if (wrapperGenerator) {
	(*wrapperGenerator)(theType);
      }
      input_event__ = theNode;
      rol->dabufpi = (long *) &input_event__->data[1]
      /* drop int level */
      UNLOCKINTS;
      /* call the routine */
      (*theNode->reader)(theType, Tcode[theSource]);
      /* lock ints again */
      LOCKINTS;
      /* done with this trigger */
      if (theNode)
	partFreeItem(theNode);
      if (theEvMask) {
	/* remember we have seen it! */
	theEvMask = theEvMask & ~(1<<theSource);
      } 
      if (!theEvMask) {
	WRITE_EVENT_;
	DO_DONE__;
      }
      
    } /* if (theEvMask) */

  }
  dispatch_busy = 0;
}

/* 
   Generic interrupt handler.
   
   This routine looks to see if the dispatcher is already running.
   If dispatcher is busy the trigger is queued, this code is protected
   by INTLOCK so we know the flag dispatch_busy can't change behind our 
   backs.
   */


static int theIntHandler(int theSource)
{
  if (theSource == 0) return(0);
  {  
    NODE *theNode;
    LOCKINTS;
    partGetItem(rol->dispatch, theNode);
    theNode->type = (CETREAD); 
    theNode->source = theSource; 
    theNode->reader = trigRtns[theSource]; 
    listAdd(&rol->dispQ->list, theNode); 
    if (!dispatch_busy) 
      cdodispatch();
    UNLOCKINTS;
  }
}

static int cdopolldispatch()
{
  unsigned char theSource, theType;
  int stat = 0;
  NODE *theNode;

  for (theSource=0;theSource<trigId;theSource++){
    if (syncTRtns[theSource]){
      if ( theNode = (*syncTRtns[theSource])(Tcode[theSource])) {
	stat = 1;
	{  
	  LOCKINTS;
	  if (theNode == 1) 
	    partGetItem(rol->dispatch, theNode);
	  theNode->type = (CETREAD); 
	  theNode->source = theSource; 
	  theNode->reader = trigRtns[theSource]; 
	  listAdd(&rol->dispQ->list, theNode); 
	  if (!dispatch_busy) 
	    cdodispatch();
	  UNLOCKINTS;
	}
      }
    }
  }
  return (stat);
}

#endif
