#include <stdio.h>
#include <rpc/rpc.h>
#include "scRpc.h"

void
scprog_1(rqstp, transp)
	struct svc_req *rqstp;
	SVCXPRT *transp;
{
	union {
		char *sc_ackmessage_1_arg;
		PARVAL sc_rpcsetval_1_arg;
		PARVAL sc_rpcreadval_1_arg;
		PARVALLIST sc_rpcsetmultiple_1_arg;
		PARVALLIST sc_rpcreadmultiple_1_arg;
		DEVINF sc_rpcdefinedevice_1_arg;
		char *sc_rpcgetdevice_1_arg;
		READLIST sc_rpcreadmultipleint_1_arg;
		READLIST sc_rpcreadmultiplereal_1_arg;
		READLIST sc_rpcreadmultiplestring_1_arg;
		PARNAMINTLIST sc_rpcwritemultipleint_1_arg;
		PARNAMREALIST sc_rpcwritemultiplereal_1_arg;
		PARNAMSTRLIST sc_rpcwritemultiplestring_1_arg;
		SEQUENCE sc_rpcreadintsequence_1_arg;
		SEQUENCE sc_rpcreadrealsequence_1_arg;
		SEQUENCE sc_rpcreadstringsequence_1_arg;
		SEQUENCEINT sc_rpcwriteintsequence_1_arg;
		SEQUENCEREAL sc_rpcwriterealsequence_1_arg;
		SEQUENCESTRING sc_rpcwritestringsequence_1_arg;
		PARNAMTYPEP sc_rpcreadintarray_1_arg;
		PARNAMTYPEP sc_rpcreadrealarray_1_arg;
		SEQUENCEINT sc_rpcwriteintarray_1_arg;
		SEQUENCEREAL sc_rpcwriterealarray_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	switch (rqstp->rq_proc) {
	case NULLPROC:
		svc_sendreply(transp, xdr_void, NULL);
		return;

	case SC_ACKMESSAGE:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_int;
		local = (char *(*)()) sc_ackmessage_1;
		break;

	case SC_RPCSETVAL:
		xdr_argument = xdr_PARVAL;
		xdr_result = xdr_int;
		local = (char *(*)()) sc_rpcsetval_1;
		break;

	case SC_RPCREADVAL:
		xdr_argument = xdr_PARVAL;
		xdr_result = xdr_PARVAL;
		local = (char *(*)()) sc_rpcreadval_1;
		break;

	case SC_RPCSETMULTIPLE:
		xdr_argument = xdr_PARVALLIST;
		xdr_result = xdr_PARERRLIST;
		local = (char *(*)()) sc_rpcsetmultiple_1;
		break;

	case SC_RPCREADMULTIPLE:
		xdr_argument = xdr_PARVALLIST;
		xdr_result = xdr_PARVALLIST;
		local = (char *(*)()) sc_rpcreadmultiple_1;
		break;

	case SC_RPCDEFINEDEVICE:
		xdr_argument = xdr_DEVINF;
		xdr_result = xdr_int;
		local = (char *(*)()) sc_rpcdefinedevice_1;
		break;

	case SC_RPCGETDEVICE:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_DEVINF;
		local = (char *(*)()) sc_rpcgetdevice_1;
		break;

	case SC_RPCREADMULTIPLEINT:
		xdr_argument = xdr_READLIST;
		xdr_result = xdr_PARINTLIST;
		local = (char *(*)()) sc_rpcreadmultipleint_1;
		break;

	case SC_RPCREADMULTIPLEREAL:
		xdr_argument = xdr_READLIST;
		xdr_result = xdr_PARREALIST;
		local = (char *(*)()) sc_rpcreadmultiplereal_1;
		break;

	case SC_RPCREADMULTIPLESTRING:
		xdr_argument = xdr_READLIST;
		xdr_result = xdr_PARSTRLIST;
		local = (char *(*)()) sc_rpcreadmultiplestring_1;
		break;

	case SC_RPCWRITEMULTIPLEINT:
		xdr_argument = xdr_PARNAMINTLIST;
		xdr_result = xdr_ERRORLIST;
		local = (char *(*)()) sc_rpcwritemultipleint_1;
		break;

	case SC_RPCWRITEMULTIPLEREAL:
		xdr_argument = xdr_PARNAMREALIST;
		xdr_result = xdr_ERRORLIST;
		local = (char *(*)()) sc_rpcwritemultiplereal_1;
		break;

	case SC_RPCWRITEMULTIPLESTRING:
		xdr_argument = xdr_PARNAMSTRLIST;
		xdr_result = xdr_ERRORLIST;
		local = (char *(*)()) sc_rpcwritemultiplestring_1;
		break;

	case SC_RPCREADINTSEQUENCE:
		xdr_argument = xdr_SEQUENCE;
		xdr_result = xdr_PARINTLIST;
		local = (char *(*)()) sc_rpcreadintsequence_1;
		break;

	case SC_RPCREADREALSEQUENCE:
		xdr_argument = xdr_SEQUENCE;
		xdr_result = xdr_PARREALIST;
		local = (char *(*)()) sc_rpcreadrealsequence_1;
		break;

	case SC_RPCREADSTRINGSEQUENCE:
		xdr_argument = xdr_SEQUENCE;
		xdr_result = xdr_PARSTRLIST;
		local = (char *(*)()) sc_rpcreadstringsequence_1;
		break;

	case SC_RPCWRITEINTSEQUENCE:
		xdr_argument = xdr_SEQUENCEINT;
		xdr_result = xdr_ERRORLIST;
		local = (char *(*)()) sc_rpcwriteintsequence_1;
		break;

	case SC_RPCWRITEREALSEQUENCE:
		xdr_argument = xdr_SEQUENCEREAL;
		xdr_result = xdr_ERRORLIST;
		local = (char *(*)()) sc_rpcwriterealsequence_1;
		break;

	case SC_RPCWRITESTRINGSEQUENCE:
		xdr_argument = xdr_SEQUENCESTRING;
		xdr_result = xdr_ERRORLIST;
		local = (char *(*)()) sc_rpcwritestringsequence_1;
		break;

	case SC_RPCREADINTARRAY:
		xdr_argument = xdr_PARNAMTYPEP;
		xdr_result = xdr_ARRAYINTLIST;
		local = (char *(*)()) sc_rpcreadintarray_1;
		break;

	case SC_RPCREADREALARRAY:
		xdr_argument = xdr_PARNAMTYPEP;
		xdr_result = xdr_ARRAYREALIST;
		local = (char *(*)()) sc_rpcreadrealarray_1;
		break;

	case SC_RPCWRITEINTARRAY:
		xdr_argument = xdr_SEQUENCEINT;
		xdr_result = xdr_int;
		local = (char *(*)()) sc_rpcwriteintarray_1;
		break;

	case SC_RPCWRITEREALARRAY:
		xdr_argument = xdr_SEQUENCEREAL;
		xdr_result = xdr_int;
		local = (char *(*)()) sc_rpcwriterealarray_1;
		break;

	case SC_RPCRESET:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) sc_rpcreset_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
#ifdef hpux
	memset(&argument, 0, sizeof(argument));
#else  hpux
	memset(&argument, sizeof(argument));
#endif hpux
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments\n");
		exit(1);
	}
}

