/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: rol.h,v $
 *      Revision 1.1.1.1  1996/08/21 19:21:03  heyes
 *      Imported sources
 *
*	  Revision 1.2  94/03/16  11:00:33  11:00:33  heyes (Graham Heyes)
*	  auto replace
*	  
*	  Revision 1.1  94/03/16  10:01:10  10:01:10  heyes (Graham Heyes)
*	  Initial revision
*	  
 *
 *----------------------------------------------------------------------------*/
#ifndef _ROLDEFINED
#define _ROLDEFINED
#include <da.h>
#include <cm.h>
#include <rc.h>
#include <services.h>
#include <stdio.h>
#include <sys/signal.h>
#include <unistd.h>
#include "codastdc.h"

static int stream_fd__;
static rolParam rol;
static unsigned long evnb;

extern SERVICE _service;

#include <event_type.h>

#include <BankTools.h>

#define RECOVER {if (global_env_depth>=0) global_env_depth--; \
  longjmp(global_env[global_env_depth+1],global_code);}

#include <trigger_dispatch.h>

static void __download();
static void __prestart();
static void __go();
static void __pause();
static void __end();
static void __poll();

#ifndef MAX_BLENGTH
#define MAX_BLENGTH 32768
#endif
#ifndef ROL_NAME__
#define ROL_NAME__ "Un-named"
#endif

static char rol_name__[40];
static char temp_string__[132];

static unsigned long address___;

static void __init__(param)
     rolParam param;
{
  while(1) {
    if (param->daproc) {
      switch(param->daproc) {
      case DA_INIT_PROC:
	{
	  char name[40];
	  printf("user init \n");
	  stream_fd__ = 0;
	  rol = param;
	  rol->inited = 1;
	  eprintf(5,"rol->inited %d\n",rol->inited);
	  
	  strcpy(rol_name__, ROL_NAME__);
	  rol->listName = rol_name__;
	  strcpy(name, rol->listName);
	  strcat(name, ":pool");
	  rol->pool  = partCreate(name, MAX_BLENGTH ,16,0);
	  strcpy(name, rol->listName);
	  strcat(name, ":input");
	  rol->input = partCreate(name, 0, 0, 0);
	  strcpy(name, rol->listName);
	  strcat(name, ":dispQ");
	  rol->dispQ = partCreate(name, 0, 0, 0);
	  strcpy(name, rol->listName);
	  strcat(name, ":dispatch");
	  rol->dispatch  = partCreate(name, 0, 32, 4);
	  eprintf(0,"INFO: __init__ from %s\n",rol->listName);
	  eprintf(0,"INFO: done init\n");  
	  break;
	}
      case DA_DOWNLOAD_PROC:
	__download();
	break;
      case DA_PRESTART_PROC:
	__prestart();
	break;
      case DA_PAUSE_PROC:
	__pause();
	break;
      case DA_END_PROC:
	__end();
	break;
      case DA_GO_PROC:
	__go();
	break;
      case DA_POLL_PROC:
	__poll();
	break;
      default:
	eprintf(0,"WARN: unsupported action\n");
	break;
      }
      param->daproc = 0;
      __poll();
    }
  }
}

static void __poll(objClass class)
{
    CDOPOLL;
}


#endif
