/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, * 
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:
 *      $Log: obj.h,v $
 *      Revision 1.1.1.1  1996/08/21 19:21:02  heyes
 *      Imported sources
 *
*	  Revision 1.1  94/03/16  09:55:28  09:55:28  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  93/10/27  08:48:41  08:48:41  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.11  1993/05/04  12:36:49  watson
 *	  array of client handles
 *
 *	  Revision 1.10  1993/03/16  14:04:39  heyes
 *	  reinsert for coda 1.2
 *
 *	  Revision 1.9  1992/11/06  19:40:00  quarrie
 *	  Add DAREADMESSAGES etc.
 *
 *	  Revision 1.8  1992/11/05  18:03:38  heyes
 *	  ing states added correctly
 *
 *	  Revision 1.7  1992/09/14  15:03:13  quarrie
 *	  Correct stupid typos
 *
 *	  Revision 1.6  1992/09/14  15:00:14  quarrie
 *	  More aliases defined
 *
 *	  Revision 1.5  1992/09/09  13:32:10  quarrie
 *	  Added more Actions
 *
 *	  Revision 1.4  1992/07/21  17:52:17  heyes
 *	  run time debug on vxworks
 *
 *	  Revision 1.3  1992/06/29  15:48:31  heyes
 *	  made consistent with rc.h
 *
 *	  Revision 1.2  1992/06/25  19:01:26  heyes
 *	  insert into RCS for first time
 *
 *	  Revision 1.1  1992/06/25  18:30:26  heyes
 *	  Initial revision
 *
 *
 *----------------------------------------------------------------------------*/

#ifndef _RC_INCLUDED_
#include "rc.h"
#endif

#define DA_MAGIC         0x7030

#define DA_CLASSES      12
#define STREAM_SOCKETS   1
#define STREAM_INTERNAL  2
#define STREAM_INPUT     0
#define STREAM_OUTPUT    4

typedef struct classStruct *objClass;
typedef struct classStruct SERVICE;

typedef struct classStruct {
  short     magic;		/* check for a valid data structure */
  char     *name;		/* name of this object */
  char     *className;		/* type of this object */
  int       ourId;		/* unique Id */
  int       expId;		/* unique Id for this class of object */
  
  rolParam **rol;		/* rol configuration structures. */
  char     *rolNames;		/* string describing rols */
  int       nrol;		/* number of lists */
  int       action;		/* RC command */
  int       state;		/* RC current state */

  char     *log;		/* host to send log output to */
  char     *target;		/* name of output target(s) */
  int       runNumber;		/* obvious */
  int       runType;		/* ditto */
} objClassStore;
