/*----------------------------------------------------------------------------*
 *  Copyright (c) 1991, 1992  Southeastern Universities Research Association, *
 *                            Continuous Electron Beam Accelerator Facility   *
 *                                                                            *
 *    This software was developed under a United States Government license    *
 *    described in the NOTICE file included as part of this distribution.     *
 *                                                                            *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606 *
 *      heyes@cebaf.gov   Tel: (804) 249-7030    Fax: (804) 249-7363          *
 *----------------------------------------------------------------------------*
 * Discription: follows this header.
 *
 * Author:
 *	Graham Heyes
 *	CEBAF Data Acquisition Group
 *
 * Revision History:<
 *      $Log: da.h,v $
 *      Revision 1.1.1.1  1996/08/21 19:21:02  heyes
 *      Imported sources
 *
*	  Revision 1.1  94/03/16  09:53:26  09:53:26  heyes (Graham Heyes)
*	  Initial revision
*	  
 *
 *----------------------------------------------------------------------------*/
#ifndef _DADEFINED
#define _DADEFINED
#ifdef VXWORKS

#include "vxWorks.h"
#include "types.h"
#include "logLib.h"
#include "memLib.h"
#include "string.h"
#include "semLib.h"
#include "taskLib.h"
#include "socket.h"
#include "sockLib.h"
#include "in.h"
#include "intLib.h"
#include "iosLib.h"
#include "inetLib.h"
#include "hostLib.h"
#include "ioLib.h"
#include "stdioLib.h"
#include "loadLib.h"
#include "errnoLib.h"
#include "sigLib.h"
#include "selectLib.h"
#include "msgQLib.h"
#include "sysSymTbl.h"
#include "symLib.h"
#include "msgLib.h"
#include <rpc.h>
#include <rpcGbl.h>
#else
#include "sys/types.h"
#include "errno.h"
#include "sys/uio.h"
#include "netinet/in.h"
#include "sys/time.h"

#include <stdio.h>
#include <strings.h>
#include <sys/socket.h>
#include <netdb.h>
#include <sys/time.h>

#include "msgLib.h"

#include "libpart.h"

typedef void (*VOIDFUNCPTR) ();
typedef int (*FUNCPTR) ();

#endif /* ifdef VXWORKS */

     /* READOUT LIST PROCEDURES  */
#define DA_INIT_PROC        0
#define DA_DOWNLOAD_PROC    1
#define DA_PRESTART_PROC    2
#define DA_END_PROC         3
#define DA_PAUSE_PROC       4
#define DA_GO_PROC          5
#define DA_POLL_PROC        6
#define DA_REPORT_PROC      7

     /* Event types */
#define EV_SYNC     16
#define EV_PRESTART 17
#define EV_GO       18
#define EV_PAUSE    19
#define EV_END      20


#define EV_BANK_HDR  0x00000100
#define EV_BAD       0x10000000

#define PHYS_BANK_HDR(t,e) (unsigned long)((((t)&0xf)<<16) | \
					     ((e)&0xff) | \
					     EV_BANK_HDR)

#define CTL_BANK_HDR(t) (unsigned long)((((t)&0xffff)<<16) | \
					0x000001CC)
     
#define IS_BANK(b) (((unsigned long) (b) && EV_BANK_HDR)==EV_BANK_HDR)
     
#define DECODE_BANK_HEADER(b,t,e) { t = (b[1]>>16)&0xffff;\
				      e = b[1]&0xff;}    
     
#define EV_BANK_ID 0xc0010100
#define EV_HDR_LEN 4

/* The following structure is used per readout list to store it's global data */
     
typedef struct rolParameters *rolParam;
     
typedef struct rolParameters
  {
    char          *name;	/* name of parent process */
    char          *listName;	/* name of this list */
    int            runType;	/* run type */
    int            runNumber;	/* run number */
    VOIDFUNCPTR    doit;	/* init procedure */
    int            daproc;	/* list of function pointers */
    void          *id;		/* ID of storage used during load */
    int            nounload;	/* can't be unloaded */
    int            inited;	/* we have been initialised */
    long          *dabufp;	/* output  write pointer */
    long          *dabufpi;	/* input   read  pointer */
    ROL_MEM_PART  *pool;        /* our freememory pool */
    ROL_MEM_PART  *output;	/* our output */
    ROL_MEM_PART  *input;       /* our input */
    ROL_MEM_PART  *dispatch;    /* used by dispatcher to delay triggers */
    ROL_MEM_PART  *dispQ;       /* dispatcher queue */
    unsigned long  recNb;	/* count of output buffers processed */

#ifdef VXWORKS
    SEM_ID         wakeup;	/* isr synchronization semaphore */
#else
    int            wakeup;
#endif

    char          *usrString;	/* string passed in download */
    void          *private;	/* private storage */
    int            pid;
  } ROLPARAMS;

#endif


