#ifndef __FASTBUS__
#define __FASTBUS__

#include "fb_types.h"
#include "fb_fscc_macro.h"

#ifdef FB_BUILD_INLINE
#include "fb_status_macros.h"
#include "fb_fscc_inline.h"
#else
#include "fb_proto_1.h"
#endif

#ifndef FB_LIMITED_STATUS
  char	*FB_ERRTXT[FB_ERROR_MAX+1] =
	{
	"",
	"ERROR: 0x%X %s,%s - address release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - AK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - block data - SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data parity error, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - data SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - data SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK release timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - long timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - pad cycle SS=2, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=3, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=4, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=5, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=6, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - pad cycle SS=7, PAD %d, SAD %d\n",	
	"ERROR: 0x%X %s,%s - s.addr cycle DK timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=0, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=1, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=2, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=3, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=4, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=5, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=6, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - s.addr cycle SS=7, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - software timeout, PAD %d, SAD %d\n",
	"ERROR: 0x%X %s,%s - wait timeout, PAD %d, SAD %d\n",

	"ERROR: 0x%X %s,%s - normal successful completion\n",
	"ERROR: 0x%X %s,%s - error accessing data buffer\n",
	"ERROR: 0x%X %s,%s - abort action\n",
	"ERROR: 0x%X %s,%s - already connected\n",
	"ERROR: 0x%X %s,%s - bad parameter value\n",
	"ERROR: 0x%X %s,%s - buffer overflow\n",
	"ERROR: 0x%X %s,%s - session closed, no actions possible\n",
	"ERROR: 0x%X %s,%s - routine connection failed\n",
	"ERROR: 0x%X %s,%s - routine disconnect failed\n",
	"ERROR: 0x%X %s,%s - environment active\n",
	"ERROR: 0x%X %s,%s - environment id overflow\n",
	"ERROR: 0x%X %s,%s - environment overflow\n",
	"ERROR: 0x%X %s,%s - environment release\n",
	"ERROR: 0x%X %s,%s - generic error\n",
	"ERROR: 0x%X %s,%s - generic fatal\n",
	"ERROR: 0x%X %s,%s - hardware error\n",
	"ERROR: 0x%X %s,%s - hardware warning\n",
	"ERROR: 0x%X %s,%s - holding address\n",
	"ERROR: 0x%X %s,%s - holding bus\n",
	"ERROR: 0x%X %s,%s - error was ignored\n",
	"ERROR: 0x%X %s,%s - illegal parameter value\n",
	"ERROR: 0x%X %s,%s - illegal sequential buffer id\n",
	"ERROR: 0x%X %s,%s - unexpected implementation error\n",
	"ERROR: 0x%X %s,%s - generic informational\n",
	"ERROR: 0x%X %s,%s - invalid environment id\n",
	"ERROR: 0x%X %s,%s - invalid list pointer\n",
	"ERROR: 0x%X %s,%s - invalid port id\n",
	"ERROR: 0x%X %s,%s - invalid sequential buffer id\n",
	"ERROR: 0x%X %s,%s - last pad\n",
	"ERROR: 0x%X %s,%s - last secondary address\n",
	"ERROR: 0x%X %s,%s - last list pointer\n",
	"ERROR: 0x%X %s,%s - list overflow\n",
	"ERROR: 0x%X %s,%s - long timer on\n",
	"ERROR: 0x%X %s,%s - no address connection\n",
	"ERROR: 0x%X %s,%s - no more status\n",
	"ERROR: 0x%X %s,%s - no privilege\n",
	"ERROR: 0x%X %s,%s - no supplementary status\n",
	"ERROR: 0x%X %s,%s - not connected\n",
	"ERROR: 0x%X %s,%s - not holding mastership\n",
	"ERROR: 0x%X %s,%s - not master\n",
	"ERROR: 0x%X %s,%s - session already open\n",
	"ERROR: 0x%X %s,%s - operation pending\n",
	"ERROR: 0x%X %s,%s - pipeline transfer\n",
	"ERROR: 0x%X %s,%s - pointer overflow\n",
	"ERROR: 0x%X %s,%s - port active\n",
	"ERROR: 0x%X %s,%s - port already allocated\n",
	"ERROR: 0x%X %s,%s - port not allocated\n",
	"ERROR: 0x%X %s,%s - port not available\n",
	"ERROR: 0x%X %s,%s - port owned\n",
	"ERROR: 0x%X %s,%s - read only parameter\n",
	"ERROR: 0x%X %s,%s - operation successfully retried\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer active\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer exists\n",
	"ERROR: 0x%X %s,%s - sequenctial buffer id overflow\n",
	"ERROR: 0x%X %s,%s - software timer on\n",
	"ERROR: 0x%X %s,%s - status not found\n",
	"ERROR: 0x%X %s,%s - status overflow\n",
	"ERROR: 0x%X %s,%s - successful operation\n",
	"ERROR: 0x%X %s,%s - unknown error\n",
	"ERROR: 0x%X %s,%s - unknown parameter\n",
	"ERROR: 0x%X %s,%s - unsupported port operation\n",
	"ERROR: 0x%X %s,%s - unsupported paramter\n",
	"ERROR: 0x%X %s,%s - unsupported routine\n",
	"ERROR: 0x%X %s,%s - user array overflow\n",
	"ERROR: 0x%X %s,%s - generic warning\n",
	"ERROR: 0x%X %s,%s - fscc FIFO error\n",
	};
#endif

static int padr,sadr;

#define IFERROR(str) \
  if (fb_errno!=FB_ERR_NORMAL) {\
    fb_rtn = str;\
    goto fooy;\
  }


#ifdef FB_LIMITED_STATUS
#define FB_REPORT_ERROR  daLogMsg("ERROR: FB %0X\n",fb_errno);
#else
#define FB_REPORT_ERROR  daLogMsg(FB_ERRTXT[FB_GET_ERROR_VALUE(fb_errno)],\
	   fb_errno, \
	   global_routine[global_env_depth],  \
	   fb_rtn,\
	   padr,sadr);
#endif

inline void 
  fpbr(long len) 
{
  int i;
  if ((len>2000)||(len<1)) len = 2000;
  fb_frdb_1(0,0,*dabufp,(len<<2),0,1,1,1,0,0,1,1,0);
  IFERROR("fprb data");
  fb_frlen_1(&i);
  IFERROR("fprb");
  *dabufp += (i>>2);
  return;
  
 fooy:
  FB_REPORT_ERROR;
  return;
}

static inline void 
  fpbrf(long len) 
{
  int i, ix;
  if ((len>512)||(len<1)) len = 512;
  FSCC_DATARS;
  FSCC_COPYRS;
  FSCC_COPYEN;
  fb_frdb_1(0,0,FB_DATA_PATH_ADDR,(len<<2),0,1,1,1,0,0,1,1,0);
  fb_frlen_1(&i);
  ix = (i>>2) - 1;  /* # of longwords - 1*/

  asm("movel #6815744,a2");                 /* address of fifo                  */
  asm("movel %0,d1":/*none*/:"g" (ix));     /* word count - 1                   */
  asm("movel _dabufp,a0");                  /* get pointer to dabufp            */
  asm("movel a0@,a1");                      /* a1= *dabufp                      */
  asm("movel a2@,a1@+");                    /* move from fifo to *((*dabufp)++) */
  asm(".long 1472856060");                  /* asm("dbf d1,-4")                 */
  asm("movel a1,a0@");                      /* put a1 back into *dabufp         */

  FSCC_COPYDIS;
  IFERROR("fprb data");
  return;
  
 fooy:
  FB_REPORT_ERROR;
  return;
}

/*
Interrupts input into the 68901 general purpose lines
-----------------------------------------------------

 interrupt enable bits
*/

#define FSCC_TSTRB_ENBIT	7	/* Trigger input strobe */
#define FSCC_TSTRB_EN		(1<<FSCC_TSTRB_ENBIT)	/* Trigger input strobe */

#define PIT_BASE1		0x00640000	/* FCSEL  FASTBUS Parallel Port 1 (MC68230) */

#define MFP_BASE		0x00480000	/* MC68901 Multi-Function Peripheral */
#define MFP_GPDR              	0x00		/* GENERAL PURPOSE DATA REGISTER */
#define MFP_IERA              	0x03           	/* INT ENABLE REG A */
#define MFP_IMRA              	0x09           	/* INT MASK REG A */

/*
------------------------------------------------------------------
 MC68230 Parallel Interface/Timer (PI/T) hardware register offsets
------------------------------------------------------------------
*/
#define PIT_PGCR       0x00                  /* PORT GENERAL CTRL REG */
#define PIT_PSRR       0x01                  /* PORT SERVICE REST REG */
#define PIT_PADDR      0x02                  /* PORT A DATA DIRECTION REG  */
#define PIT_PBDDR      0x03                  /* PORT B DATA DIRECTION REG  */
#define PIT_PCDDR      0x04                  /* PORT C DATA DIRECTION REG  */
#define PIT_PACR       0x06                  /* PORT A CONTROL REG */
#define PIT_PBCR       0x07                  /* PORT B CONTROL REG */
#define PIT_PADR       0x08                  /* PORT A DATA REG  */
#define PIT_PBDR       0x09                  /* PORT B DATA REG  */
#define PIT_PAAR       0x0A                  /* PORT A ALT REG (READ ONLY) */
#define PIT_PBAR       0x0B                  /* PORT B ALT REG (READ ONLY) */
#define PIT_PCDR       0x0C                  /* PORT C DATA REG  */
#define PIT_PSR        0x0D                  /* PORT STATUS REG */
#define PIT_TCR        0x10                  /* TIMER CONTROL REG  */
#define PIT_CPR        0x12                  /* COUNTER PRELOAD REG */
#define PIT_CPRH       0x13                  /* COUNTER PRELOAD REG - HI */
#define PIT_CPRM       0x14                  /* COUNTER PRELOAD REG - MID  */
#define PIT_CPRL       0x15                  /* COUNTER PRELOAD REG - LO */
#define PIT_TSR        0x1A                  /* TIMER STATUS REG */


#define mem8(a) (*(unsigned char *) (a))

static inline void wdStart()
{
  /* PIT 1 timer is watchdog */
  mem8(PIT_BASE1+PIT_TCR)  = 0xf2 ;						  /* Start the clock */           
  mem8(PIT_BASE1+PIT_CPRH)=100;
  mem8(PIT_BASE1+PIT_CPRM)=0x0;
  mem8(PIT_BASE1+PIT_CPRL)=0x0;						  /* set up time constant */
  mem8(PIT_BASE1+PIT_TCR)  = 0xf3 ;						  /* Start the clock */           
}

static inline void fptriglink(isr)
     VOIDFUNCPTR isr;
{
  static FUNCPTR handlerPtr = (FUNCPTR) 0;
  
  if (handlerPtr)
    free(handlerPtr);

  handlerPtr = intHandlerCreate(isr,0);
  intVecSet((VOIDFUNCPTR *) (0x4f<<2),(VOIDFUNCPTR) handlerPtr);
}

static inline void fptenable()
{
  mem8(MFP_BASE+MFP_IERA) |= FSCC_TSTRB_EN; /* interrupt enable */
  mem8(MFP_BASE+MFP_IMRA) |= FSCC_TSTRB_EN; /* interrupt mask */
}

static inline void fptdisable()
{
  mem8(MFP_BASE+MFP_IERA) &= ~FSCC_TSTRB_EN;
  mem8(MFP_BASE+MFP_IMRA) &= ~FSCC_TSTRB_EN;
}

static inline char fpttype()
{
  return(mem8(PIT_BASE1+PIT_PBDR)&0x3);
}

static inline void fpttypeset(char tt)
{
  mem8(PIT_BASE1+PIT_PBDR) = (tt<<5) | (mem8(PIT_BASE1+PIT_PBDR)&0x1f);
}

static inline void fpttoggle()
{
  mem8(PIT_BASE1+PIT_PBDR)=0x10;
  mem8(PIT_BASE1+PIT_PBDR)=0;
}

static inline void fpbusy()
{
  mem8(PIT_BASE1+PIT_PBDR) |=  0x10;
}

static inline void fpnotbusy()
{
  mem8(PIT_BASE1+PIT_PBDR) &= ~0x10;
}

static inline int fpttest()
{
  int ii;
  ii = ((mem8(MFP_BASE+MFP_GPDR) & 0x80)!=0);
  return(ii);
}

/* Definition of a FSCC trigger source */

static int FSCC_handler,FSCCflag;
static unsigned char FSCC_isAsync;

static int FSCC_int_handler()
{
  theIntHandler(FSCC_handler);
}

static int FSCC_TEST (int code){
  int stat = 0;
  return(fpttest() || FSCCflag);
}

#define FSCC_INIT {  FSCC_handlers = 0;FSCC_isAsync = 0;FSCCflag = 0;}

#define FSCC_ASYNC(code,id) {printf("linking FSCC trigger to id %d\n",id); \
			       FSCC_handler = (id);FSCC_isAsync = 1;fptriglink(FSCC_int_handler);}

#define FSCC_SYNC(code,id) {printf("linking FSCC trigger to id %d\n",id); \
			      FSCC_handler = (id);FSCC_isAsync = 0;}

#define FSCC_SETA(code) {theIntHandler(FSCC_handler;}

#define FSCC_SETS(code) FSCCflag = code;

#define FSCC_ENA(code) fptenable();

#define FSCC_DIS(code) fptdisable();

#define FSCC_CLRS(code) FSCCflag = 0;

#define FSCC_GETID(code) FSCC_handler

#define FSCC_START(val)	 {;}

#define FSCC_STOP(val)	 {fptdisable();}

#define FSCC_ENCODE(code) code
#endif
