/******************************************************************************
*
* header file for use with General CAMAC based  rols with CODA crl (version 2.0)
*   The trigger source for polling or interrupts is a LAM from up to 8 crates.
*
*                             DJA   October 1996
*
*******************************************************************************/
#ifndef __CAMAC_LAM__
#define __CAMAC_LAM__

/* Global variable to hold the LAM source for the trigger */
unsigned long LAM_source;

static int LAM_handlers[256],LAMflag; /* NOTE 256 = 8 crates + 32 stations per crate. */
static int LAM_address[256];
static unsigned char LAM_isAsync[256],fcode,dumstat;

static unsigned long address___;

#define LAM_INT_LEVEL 2           /* Interrupt level from VME interface set by ccinit() routine*/

#define LAM_ENCODE(c,n) ((c)*32+(n))

#define LAM_DECODE(code,c,n) {c=((code)/32);n=((code)-32*(c));}

#ifdef POLLING_MODE
#define LAM_RESET(c,n) {int code = LAM_ENCODE(c,n);cclc(LAM_address[code]);}
#else
#define LAM_RESET(c,n) {int code = LAM_ENCODE(c,n);cclc(LAM_address[code]);ccrgl(LAM_address[code]);}
#endif

void LAM_handler()
{
  theIntHandler(LAM_handlers[LAM_source]);
}

static inline int 
lamttest (){
  int stat;
  ctlm(LAM_address[LAM_source],&stat);
  return(stat);
}

static inline unsigned long 
lamttype (){
  unsigned long tt;
  tt=1;
  return(tt);
}

static inline void 
lamtenable(c,n)
 unsigned long c,n;
{
 int lock_key;
 int code = LAM_ENCODE(c,n);

#ifndef POLLING_MODE
 lock_key = intLock();

 ccci(LAM_address[code], 0); 
 cclm(LAM_address[code], 1);
 cclc(LAM_address[code]);
 cccd(LAM_address[code], 1);
 ccrgl(LAM_address[code]);
 ccgl(LAM_address[code], 1);
 
 intUnlock(lock_key);

#else

 ccci(LAM_address[code], 0); 
 cclm(LAM_address[code], 1);
 cclc(LAM_address[code]);
 cccd(LAM_address[code], 1);
 ccgl(LAM_address[code], 1);

#endif
}

static inline void 
lamtdisable(c,n)
 unsigned long c,n;
{
  int code = LAM_ENCODE(c,n);
  ccgl(LAM_address[code], 0); /* Clear graded LAM register */
  cccd(LAM_address[code], 0); /* Disable crate demand      */
  cclm(LAM_address[code], 0); /* Disable LAM               */
  ccci(LAM_address[code], 1); /* Inhibit Crate             */
}

static inline void
lamtack(c,n)
 unsigned long c, n;
{ LAM_RESET(c,n); }

#define LAM_TEST lamttest

#define LAM_INIT { bzero((char *) LAM_handlers, sizeof(LAM_handlers)); \
                   bzero((char *) LAM_address, sizeof(LAM_address)); \
                   bzero((char *) LAM_isAsync, sizeof(LAM_isAsync)); \
                   LAMflag = 0;}

#define LAM_ASYNC(code,id) {int ext,c,n;LAM_DECODE(code,c,n);\
                               printf("linking async LAM %d trigger source to id %d\n",code,id); \
                               cdreg(&ext,0,c,n,0);LAM_address[code]=ext; \
			       cclnk(ext,LAM_handler); \
                               LAM_handlers[code] = (id);LAM_isAsync[code] = 1;}

#define LAM_SYNC(code,id)  {int ext,c,n;LAM_DECODE(code,c,n); \
                               printf("linking sync LAM %d trigger to id %d\n",code,id); \
                               cdreg(&ext,0,c,n,0);LAM_address[code]=ext;\
			       LAM_handlers[code] = (id);LAM_isAsync[code] = 0;}

#define LAM_SETA(c,n) {code = LAM_ENCODE(c,n);theIntHandler(LAM_handlers[code]);}

#define LAM_SETS(c,n) {LAM_source = LAM_ENCODE(c,n);}

#define LAM_CLRS(c,n) LAM_source = 0;

#define LAM_ENA(c,n) lamtenable(c,n);

#define LAM_DIS(c,n) lamtdisable(c,n);

#define LAM_TTYPE   lamttype

#define LAM_GETID(code) LAM_handlers[code]

#define LAM_START(c,n)   {int code = LAM_ENCODE(c,n);cclc (LAM_address[code]);ccci (LAM_address[code], 0);}
	

#define LAM_STOP(c,n)   {int code = LAM_ENCODE(c,n);ccci (LAM_address[code], 1);}


#endif
/* End  LAM trigger source */

