%{
/*-----------------------------------------------------------------------------
 * Copyrigh t(c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804crl_parser.y) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA readout language lexer
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 */
#include "y.tab.h"
int lineno = 1;
int tokenpos = 0; int lastleng = 0; 
int was_error = 0;
int errorline = 0;
char linebuf[256], lastbuf[256], errorbuf[256], c_code[10240];
char hex_temp[10], hex_tx[20];
extern int mode, type;
extern FILE *fout;
%}
pol_l       polling[ \t]*
test_l      with[ \t]+test[ \t]+readout
cam_l       with[ \t]+camac[ \t]+readout
vme_l       with[ \t]+vme[ \t]+readout
fas_l       with[ \t]+fastbus[ \t]readout
sfi_l       with[ \t]+sfi[ \t]readout
eve_l       with[ \t]+event[ \t]readout
gen_l       with[ \t]+general[ \t]readout
dlds_l      [ \t]*begin[ \t]+download[ \t]*
dlde_l      [ \t]*end[ \t]+download[ \t]*
pres_l      [ \t]*begin[ \t]+prestart[ \t]*
pree_l      [ \t]*end[ \t]+prestart[ \t]*
send_l      [ \t]*begin[ \t]+end[ \t]*
eend_l      [ \t]*end[ \t]+end[ \t]*
spause_l    [ \t]*begin[ \t]+pause[ \t]*
epause_l    [ \t]*end[ \t]+pause[ \t]*
sgo_l       [ \t]*begin[ \t]+go[ \t]*
ego_l       [ \t]*end[ \t]+go[ \t]*
strig_l     [ \t]*begin[ \t]+trigger[ \t]
etrig_l     [ \t]*end[ \t]+trigger
sdone_l     [ \t]*begin[ \t]+done
edone_l     [ \t]*end[ \t]+done[ \t]*
sstatus_l   [ \t]*begin[ \t]+status[ \t]*
estatus_l   [ \t]*end[ \t]+status[ \t]*
int_val     [0-9]+
hex_num     hex[ \t]+[a-fA-F0-9]*
var_name    [A-Za-z"_"]+[A-Za-z0-9"_"\[\]]*
c_syn       ";"|"("|")"
math_op     "="|"+"|"-"|"*"|"/"|"&"|"|"|"^"
comp_mathop "=="|"<="|"<"|"!="|">="|">"|"&&"|"||"
punc_op     ","

%p 20000
%a 15000
%n 2000
%o 15000
%e 2400
%k 400
%s C_COMMENT C_BLOCK

%%
[ \t]+                     {;   /* ignore all white spaces */}
#.*                        {;   /* single line crl comment */}
^[ \t]*"/*".*"*/"[ \t]*\n  {lineno++;
                                /* single line C comment   */}

"/*"                       { BEGIN C_COMMENT;                }
<C_COMMENT>.               ;
<C_COMMENT>"*/"[ \t]*\n    {lineno++; BEGIN 0;               }
<C_COMMENT>\n              {lineno++;                        }
<C_COMMENT>.*"*/"          {BEGIN 0;                         }

[^;\n]+;                   {lineno++;
                            tokenpos+=yyleng; 
                            yylval.string = (char *)strdup (yytext);
                            return C_LINE;
                            }

"%%"                       {int i=0,c1 = 0, c2;
                            c2 = input();
                            c_code[i++] = c2;
                            if(c2 == '\n')lineno++;
                              for(;;){
                                 if((c1 == '%' && c2 == '%'))
                                   break;
                                 c1 = c2;
                                 c2 = input();
                                 if(c2 == '\n')
				   lineno++;
                                   c_code[i++] = c2;
                               }
                               i = i - 2;
                               c_code[i] = '\0';
                               yylval.string = (char *)strdup (c_code);
                               return BEGIN_C;
                           }

or                         {tokenpos+=yyleng;return OR;                    }
and                        {tokenpos+=yyleng;return AND;                   }
while                      {tokenpos+=yyleng;return WHILE;                 }
endloop|end[ \t]+while     {tokenpos+=yyleng;return ENDLOOP;               }
endwhile                   {tokenpos+=yyleng;return ENDLOOP;               }
is                         {tokenpos+=yyleng;return IS;                    }
less                       {tokenpos+=yyleng;return LESS;                  }
than                       {tokenpos+=yyleng;return THAN;                  }
greater                    {tokenpos+=yyleng;return GREATER;               }
equal                      {tokenpos+=yyleng;return EQUAL;                 }
not                        {tokenpos+=yyleng;return NOT;                   }
to                         {tokenpos+=yyleng;return TO;                    }
increment                  {tokenpos+=yyleng;return INCREMENT;             }
decrement                  {tokenpos+=yyleng;return DECREMENT;             }
else[ \t]+if               {tokenpos+=yyleng;return ELSEIF;                }
end[ \t]+if                {tokenpos+=yyleng;return ENDIF;                 }
endif                      {tokenpos+=yyleng;return ENDIF;                 }
if                         {tokenpos+=yyleng;return IF;                    }
else                       {tokenpos+=yyleng;return ELSE;                  }
then                       {tokenpos+=yyleng;return THEN;                  }
end[ \t]+select            {tokenpos+=yyleng;return END_SELECT;            }
select                     {tokenpos+=yyleng;return SELECT;                }
on                         {tokenpos+=yyleng;return ON;                    }
case                       {tokenpos+=yyleng;return CASE;                  }
default                    {tokenpos+=yyleng;return DEFAULT;               }
break                      {tokenpos+=yyleng;return BREAK;                 }
camac[ \t]+readout         {tokenpos+=yyleng;return CAMAC_TYPE;            }
{cam_l}                    {tokenpos+=yyleng;return CAMAC_ROL;             }
vme[ \t]+readout           {tokenpos+=yyleng;return VME_TYPE;              }
{vme_l}                    {tokenpos+=yyleng;return VME_ROL;               }
fastbus[ \t]+readout       {tokenpos+=yyleng;return FASTBUS_TYPE;          }
{fas_l}                    {tokenpos+=yyleng;return FASTBUS_ROL;           }
sfi[ \t]+readout           {tokenpos+=yyleng;return SFI_TYPE;              }
{sfi_l}                    {tokenpos+=yyleng;return SFI_ROL;               }
event[ \t]+readout         {tokenpos+=yyleng;return EVENT_TYPE;            }
{eve_l}                    {tokenpos+=yyleng;return EVENT_ROL;             }
test[ \t]+readout          {tokenpos+=yyleng;return TEST_TYPE;             }
{test_l}                   {tokenpos+=yyleng;return TEST_ROL;              }
general[ \t]+readout       {tokenpos+=yyleng;return GEN_TYPE;              }
{gen_l}                    {tokenpos+=yyleng;return GEN_ROL;               }
{pol_l}                    {tokenpos+=yyleng;return POLLING;               }
ts[ \t]+control            {tokenpos+=yyleng;return TRIG_SUPERVISOR;       }
parallel[ \t]+link         {tokenpos+=yyleng;return PARALLEL_LINK;         }
{dlds_l}                   {tokenpos+=yyleng;return START_DOWNLOAD;        }
log                        {tokenpos+=yyleng;return ACCESS_LOG;            }
{dlde_l}                   {tokenpos+=yyleng;return END_DOWNLOAD;          }
{pres_l}                   {tokenpos+=yyleng;return START_PRESTART;        }
{pree_l}                   {tokenpos+=yyleng;return END_PRESTART;          }
{send_l}                   {tokenpos+=yyleng;return START_END;             }
{eend_l}                   {tokenpos+=yyleng;return END_END;               }
{spause_l}                 {tokenpos+=yyleng;return START_PAUSE;           }
{epause_l}                 {tokenpos+=yyleng;return END_PAUSE;             }
{sgo_l}                    {tokenpos+=yyleng;return START_GO;              }
{ego_l}                    {tokenpos+=yyleng;return END_GO;                }
{strig_l}                  {tokenpos+=yyleng;return START_TRIGGER;         }
{etrig_l}                  {tokenpos+=yyleng;return END_TRIGGER;           }
{sdone_l}                  {tokenpos+=yyleng;return START_DONE;            }
{edone_l}                  {tokenpos+=yyleng;return END_DONE;              }
{sstatus_l}                {tokenpos+=yyleng;return START_STATUS;          }
{estatus_l}                {tokenpos+=yyleng;return END_STATUS;            }
reset                      {tokenpos+=yyleng;return RESET;                 }
crate                      {tokenpos+=yyleng;return CRATE;                 }
inform                     {tokenpos+=yyleng;return INFORM;                }
warn                       {tokenpos+=yyleng;return WARN;                  }
alarm                      {tokenpos+=yyleng;return ALARM;                 }
intr                       {tokenpos+=yyleng;return INTERRUPT;             }
int                        {tokenpos+=yyleng;return INT_DEC;               }
maximum                    {tokenpos+=yyleng;return MAX;                   }
clear                      {tokenpos+=yyleng;return CLEAR;                 }
control                    {tokenpos+=yyleng;return CONTROL;               }
ctl                        {tokenpos+=yyleng;return CONTROL;               }
link                       {tokenpos+=yyleng;return LINK;                  }
read                       {tokenpos+=yyleng;return READ;                  }
write                      {tokenpos+=yyleng;return WRITE;                 }
output                     {tokenpos+=yyleng;return OUTPUT;                }
get[ \t]+event             {tokenpos+=yyleng;return GET_EVENT;             }
copy[ \t]+event            {tokenpos+=yyleng;return COPY_EVENT;            }
pass[ \t]+event            {tokenpos+=yyleng;return PASS_EVENT;            }
variable                   {tokenpos+=yyleng;return VARDEC;                }
uvar_long                  {tokenpos+=yyleng;return ULONG_DEC;             }
uvar_short                 {tokenpos+=yyleng;return USHORT_DEC;            }
var_long                   {tokenpos+=yyleng;return LONG_DEC;              }
var_short                  {tokenpos+=yyleng;return SHORT_DEC;             }
vme                        {tokenpos+=yyleng;return VME_N;                 }
std                        {tokenpos+=yyleng;return STD;                   }
standard                   {tokenpos+=yyleng;return STD;                   }
sup                        {tokenpos+=yyleng;return SUPV;                  }
supervisor                 {tokenpos+=yyleng;return SUPV;                  }
ext                        {tokenpos+=yyleng;return EXT;                   }
extended                   {tokenpos+=yyleng;return EXT;                   }
shr                        {tokenpos+=yyleng;return SHR;                   }
short                      {tokenpos+=yyleng;return SHR;                   }
user                       {tokenpos+=yyleng;return USER;                  }
ascending                  {tokenpos+=yyleng;return ASC;                   }
asc                        {tokenpos+=yyleng;return ASC;                   }
pgm                        {tokenpos+=yyleng;return PGM;                   }
program                    {tokenpos+=yyleng;return PGM;                   }
data                       {tokenpos+=yyleng;return DATA_N;                }
io                         {tokenpos+=yyleng;return IO;                    }
into                       {tokenpos+=yyleng;return INTO_N;                }
mask                       {tokenpos+=yyleng;return MASK_N;                }
arbitrate                  {tokenpos+=yyleng;return ARBITRATE;             }
address                    {tokenpos+=yyleng;return ADDRESS;               }
addr                       {tokenpos+=yyleng;return ADDRESS;               }
geographic                 {tokenpos+=yyleng;return GEOGRAPHIC;            }
geo                        {tokenpos+=yyleng;return GEOGRAPHIC;            }
sec                        {tokenpos+=yyleng;return SECONDARY;             }
secondary                  {tokenpos+=yyleng;return SECONDARY;             }
release                    {tokenpos+=yyleng;return RELEASE;               }
block                      {tokenpos+=yyleng;return BLOCK;                 }
broad                      {tokenpos+=yyleng;return BROADCAST;             }
broadcast                  {tokenpos+=yyleng;return BROADCAST;             }
status                     {tokenpos+=yyleng;return STATUS;                }
limit                      {tokenpos+=yyleng;return LIMIT;                 }
inline                     {tokenpos+=yyleng;return INLINE;                }
nocheck                    {tokenpos+=yyleng;return NOCHECK;               }
fast                       {tokenpos+=yyleng;return FAST;                  }
fastbus                    {tokenpos+=yyleng;return FASTBUS;               }
sfi                        {tokenpos+=yyleng;return SFI;                   }
open                       {tokenpos+=yyleng;return OPEN;                  }
bank                       {tokenpos+=yyleng;return BANK;                  }
close                      {tokenpos+=yyleng;return CLOSE;                 }
close[ \t]+network          {tokenpos+=yyleng;return NCLOSE;               }
of                         {tokenpos+=yyleng;return OF;                    }
begin                      {tokenpos+=yyleng;return USER_BEGIN;            }
end                        {tokenpos+=yyleng;return USER_END;              }
const                      {tokenpos+=yyleng;return CONST;                 }
call                       {tokenpos+=yyleng;return CALL;                  }
code                       {tokenpos+=yyleng;return CODE;                  }
init[ \t]+trig[ \t]+source  {tokenpos+=yyleng;return TSINIT;               }
link[ \t]+async[ \t]+trig[ \t]+source {tokenpos+=yyleng;return TSLINKA;    }
link[ \t]+sync[ \t]+trig[ \t]+source  {tokenpos+=yyleng;return TSLINKS;    }
source                     {tokenpos+=yyleng;return SOURCE;                }
trig                       {tokenpos+=yyleng;return TRIG;                  }
enable                     {tokenpos+=yyleng;return ENABLE;                }
disable                    {tokenpos+=yyleng;return DISABLE;               }
inhibit                    {tokenpos+=yyleng;return INHIBIT;               }
set                        {tokenpos+=yyleng;return SET;                   }
start                      {tokenpos+=yyleng;return START;                 }
stop                       {tokenpos+=yyleng;return STOP;                  }
event[ \t]+type            {tokenpos+=yyleng;return ETYPE;                 }
set[ \t]+event[ \t]+type   {tokenpos+=yyleng;return WTYPE;                 }
event                      {tokenpos+=yyleng;return EVENT;                 }
wrap[ \t]+event[ \t]+with  {tokenpos+=yyleng;return WRAPEV;                }
connect                    {tokenpos+=yyleng;return CONNECT;               }
readout[ \t]+list          {tokenpos+=yyleng;return RLIST;                 }
declare                    {tokenpos+=yyleng;return DECLARE;               }
from                       {tokenpos+=yyleng;return FROM;                  }
by                         {tokenpos+=yyleng;return BY;                    }
range                      {tokenpos+=yyleng;return RANGE;                 }
attached                   {tokenpos+=yyleng;return ATTACHED;              }
include                    {tokenpos+=yyleng;return CINCLUDE;              }

\"[^\"]*[\"]               {yylval.string = (char *)strdup(yytext+1);
                            if(yylval.string[yyleng-2]!= '"')
                                 printf("Unterminated character string %s\n", yytext);
                            else
                                 yylval.string[yyleng-2] = '\0';
                            tokenpos+=yyleng;return QSTRING;               }
{int_val}                  {yylval.i_value = atoi(yytext);
                            tokenpos+=yyleng;return INT_VAL;               }

{hex_num}                  {sscanf(yytext,"%s %s",hex_temp,hex_tx);
                            yylval.string = (char *)strdup(hex_tx);
                            tokenpos+=yyleng;return HEX_NUM;               }

0[xX][a-fA-F0-9]+          {yylval.string = (char *)strdup(yytext);
                            tokenpos+=yyleng;return EXPLICIT_HEX_NUM;      }

{var_name}                 {yylval.string = (char *)strdup(yytext);
                            tokenpos+=yyleng;return VAR_NAME;              }

{c_syn}                    {tokenpos+=yyleng;return yytext[0];}

{comp_mathop}              {yylval.string = (char *)strdup(yytext);
                           tokenpos+=yyleng;return COMP_MATHOP;}

{math_op}                  {tokenpos+=yyleng;return yytext[0];}

!                          {tokenpos+=yyleng;return yytext[0];}

{punc_op}                  {tokenpos+=yyleng;return yytext[0];}

\n.*                       {strcpy(lastbuf,linebuf); 
                            strcpy(linebuf,yytext+1);
                            tokenpos=0;lineno++;yyless(1);
                           }

.                          {fprintf(stdout,"unrecognized char %02x\n",yytext[0]);}

%%

void yyerror(s)
char *s;
{
    tokenpos +=yyleng;
    fprintf(stdout,"line %d: %s\n%s\n",lineno,s,linebuf);
    fprintf(stdout,"%*s\n",tokenpos,"^");
}

