// Test program for cdevDirectory
#include <cdevSystem.h>
#include <cdevDevice.h>
#include <cdevService.h>
#include <cdevRequestObject.h>

static size_t getLength (cdevData& data)
{
  size_t len, dim;
  data.getDim ("value", &dim);
  if (dim != 0) {
    cdevBounds bounds;
    data.getBounds ("value", &bounds, 1);
    len = bounds.length;
  }
  else
    len = 1;
  
  return len;
}

main (int argc, char** argv)
{
  cdevSystem& system = cdevSystem::defaultSystem ();

  cdevDevice& directory = cdevDevice::attachRef ("cdevDirectory");

  char command[64];
  cdevData out;
  cdevData result;

  while (1) {
    out.remove ();
    result.remove ();

    printf ("Enter Command>\n");
    scanf ("%s", command);
    if (::strcmp (command, "queryClass") == 0) {
      printf ("Enter device name\n");
      char device[64];
      scanf ("%s", device);
      out.insert ("device", device);
      if (directory.send (command, out, result) == CDEV_SUCCESS) {
	char classname[64];
	result.get ("value", classname, sizeof (classname));
	printf ("class name of device %s is %s\n", device, classname);
      }
      else
	printf ("Cannot find class for device %s\n", device);
    }
    if (::strcmp (command, "queryVerbs") == 0) {
      printf ("Enter class device pair\n");
      char device[64];
      char cl[64];

      scanf ("%s %s", cl, device);
      out.insert ("device", device);
      out.insert ("class", cl);

      if (directory.send (command, out, result) == CDEV_SUCCESS) {
	size_t len = getLength (result);
	if (len == 1) {
	  char verb[64];
	  result.get ("value", verb, sizeof (verb));
	  printf ("Verb for class %s device %s is %s\n", cl, device, verb);
	}
	else {
	  char **verbs;
	  verbs = new char* [len];

	  result.get ("value", verbs);
	  printf ("Verbs for class %s device %s are: \n", cl, device);
	  for (int i = 0; i < len; i++) {
	    printf (" %s \n", verbs[i]);
	    delete []verbs[i];
	  }
	  delete []verbs;
	}
      }
      else 
	printf ("Cannot find any verbs for class %s device %s\n", cl, device);
    }
    else if (::strcmp (command, "queryAttributes") == 0) {
      printf ("Enter class device pair\n");
      char device[64];
      char cl[64];

      scanf ("%s %s", cl, device);
      out.insert ("device", device);
      out.insert ("class", cl);

      if (directory.send (command, out, result) == CDEV_SUCCESS) {
	size_t len = getLength (result);
	if (len == 1) {
	  char verb[64];
	  result.get ("value", verb, sizeof (verb));
	  printf ("Attributes for class %s device %s is %s\n", cl, device, verb);
	}
	else {
	  char **verbs;
	  verbs = new char* [len];

	  result.get ("value", verbs);
	  printf ("Attributes for class %s device %s are: \n", cl, device);
	  for (int i = 0; i < len; i++) {
	    printf (" %s \n", verbs[i]);
	    delete []verbs[i];
	  }
	  delete []verbs;
	}
      }
      else 
	printf ("Cannot find any attributes for class %s device %s\n", cl, device);
    }
    else if (::strcmp (command, "queryMessages") == 0) {
      printf ("Enter class device pair\n");
      char device[64];
      char cl[64];

      scanf ("%s %s", cl, device);
      out.insert ("device", device);
      out.insert ("class", cl);

      if (directory.send (command, out, result) == CDEV_SUCCESS) {
 	size_t len = getLength (result);
 	if (len == 1) {
 	  char verb[64];
 	  result.get ("value", verb, sizeof (verb));
 	  printf ("Message for class %s device %s is %s\n", cl, device, verb);
	}
	else {
	  char **verbs;
	  verbs = new char* [len];

	  result.get ("value", verbs);
	  printf ("Message for class %s device %s are: \n", cl, device);
	  for (int i = 0; i < len; i++) {
	    printf (" %s \n", verbs[i]);
	    delete []verbs[i];
	  }
	  delete []verbs;
	}
      }
      else 
	printf ("Cannot find any messages for class %s device %s\n", cl, device);
    }
    else if (::strcmp (command, "query") == 0) {
      printf ("Enter class device pair\n");
      char device[64];
      char cl[64];

      scanf ("%s %s", cl, device);
      out.insert ("device", device);
      out.insert ("class", cl);

      if (directory.send (command, out, result) == CDEV_SUCCESS) {
 	size_t len = getLength (result);
	char **verbs;
	verbs = new char* [len];

	result.get ("value", verbs);
	printf ("Matches for class %s device %s are: \n", cl, device);
	for (int i = 0; i < len; i++) {
	  printf (" %s \n", verbs[i]);
	  delete []verbs[i];
	}
	delete []verbs;
      }
      else 
	printf ("Cannot find any matches for class %s device %s\n", cl, device);
    }
    else if (::strcmp (command, "queryclass") == 0) {
      printf ("Enter class \n");
      char cl[64];

      scanf ("%s", cl);
      out.insert ("class", cl);

      if (directory.send ("query", out, result) == CDEV_SUCCESS) {
 	size_t len = getLength (result);
	char **verbs;
	verbs = new char* [len];

	result.get ("value", verbs);
	printf ("Query result class %s are: \n", cl);
	for (int i = 0; i < len; i++) {
	  printf (" %s \n", verbs[i]);
	  delete []verbs[i];
	}
	delete []verbs;
      }
      else 
	printf ("Cannot find any matches for class %s \n", cl);
    }
    else if (::strcmp (command, "update") == 0) {
      printf ("Enter DDL file name\n");
      char filename[128];
      scanf ("%s", filename);
	
      out.insert ("file", filename);
      if (directory.send (command, out, result) == CDEV_SUCCESS) {
	int st;

	result.get ("value", &st);
	if (st == 1) 
	  printf ("Parse file %s successfully\n", filename);
	else
	  printf ("Parse file %s failed\n", filename);	  
      }
      else
	printf ("Cannot do updating on the cdevDirectory\n");
    }
    else if (::strcmp (command, "updateddl") == 0) {
      char ddlstr[128];
      sprintf (ddlstr, "RCS : jietest;");
      out.insert ("value", ddlstr);
      if (directory.send ("update", out, result) == CDEV_SUCCESS) {
	int st;

	result.get ("value", &st);
	if (st == 1) 
	  printf ("Parsing %s successfully\n", ddlstr);
	else
	  printf ("Parsing %s failed\n", ddlstr);	  
      }
      else
	printf ("Cannot do updating on the cdevDirectory\n");
    }
    else if (::strcmp (command, "remove") == 0) {
      printf ("Enter class and device removal\n");
      char dvc[80], cls[80];
      scanf ("%s %s", cls, dvc);

      out.insert ("device", dvc);
      out.insert ("class", cls);
      if (directory.send (command, out, result) == CDEV_SUCCESS) {
	int st;

	result.get ("value", &st);
	if (st == 1) 
	  printf ("Removal of %s is successful\n", dvc);
	else
	  printf ("Removal of %s failed\n", dvc);
      }
      else
	printf ("Removing %s cannot be carried out\n", dvc);
    }
    else if (::strcmp (command, "service") == 0) {
      printf ("Enter device and message\n");
      char device[64], msg[128], token0[64], token1[64];
      
      if (scanf ("%s %s %s", device, token0, token1) >= 3) {
	::strcpy (msg, token0);
	::strcat (msg, " ");
	::strcat (msg, token1);
      }
      else {
	::strcpy (msg, token0);
      }
      
      out.insert ("device", device);
      out.insert ("message", msg);
      if (directory.send (command, out, result) == CDEV_SUCCESS) {
	char svc[64];
	result.get ("value", svc, sizeof (svc));
	printf ("device %s msg %s has service %s\n", device, msg, svc);
      }
      else
	printf ("Cannot find service for %s %s\n", device, msg);
    }
    else if (::strcmp (command, "quit") == 0)
      break;
  }

}


      
