//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CODA Service Monitoring Object
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: codaMonObj.h,v $
//   Revision 1.1.1.1  1996/10/11 13:39:32  chen
//   run control source
//
//
//
#ifndef _CODA_MON_OBJ_H
#define _CODA_MON_OBJ_H

#include <cdevTranObj.h>

// class codaMonObj is a monitor object that is very similar to
// the cdevTranObj except no group information. It will be used
// in the case of monitoring a particular channel which the user 
// callback need to be around after the transaction object goes away.

// codaMonObjRep is the internal representation of codaMonObj. 
// Ref: Design Pattern ->Handle and Body idiom
//      Usage of this pattern: when multiple logical copies of
//                             an object may exist, though the data
//                             themselves may not be copied.
//                             for example, userCallback 

class codaMonObj;

class codaMonObjRep
{
public:
  // constructor and destructor
  codaMonObjRep  (const cdevTranObj& tranObj);
  ~codaMonObjRep (void);

  const char *className (void) const {return "codaMonObjRep";}

  // data area for requestObject to access
  cdevSystem        *system_;
  cdevRequestObject *reqObj_;
  cdevData          *resultData_;
  cdevCallback      *userCallback_;

  // reference counter
  int               count_;

private:
  // deny access to copy and assignment
  codaMonObjRep (const codaMonObjRep&);
  codaMonObjRep& operator = (const codaMonObjRep&);
  friend class codaMonObj;
};

class codaMonObj
{
public:
  // constructor and destructor
  codaMonObj  (cdevTranObj& tranObj);
  codaMonObj  (const codaMonObj&  monObj);
  ~codaMonObj (void);

  // setup associated information with this monitor object
  void setMonitorInfo (int tag, 
		       int status, 
		       void *arg,
		       int type, 
		       int mask);

  const char *className (void) const {return "codaMonObj";}

  // internal representation
  codaMonObjRep*   rep;
  // keep a pointer to transaction object
  cdevTranObj*     tobj;

private:
  // deny access to assignment operator
  codaMonObj& operator = (const codaMonObj&);
  // friend class
  friend class codaRequestObject;
};

#endif
