//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of coda=MonObj Class
//
// Author:  Jie Chen
//
// Revision History:
//   $Log: codaMonObj.cc,v $
//   Revision 1.2  1997/01/24 16:38:42  chen
//   fix bug of monitoring unknown component
//
//   Revision 1.1.1.1  1996/10/11 13:39:32  chen
//   run control source
//
//
//
#include "codaMonObj.h"

//=========================================================================
//         Implementation of codaMonObjRep
//=========================================================================
codaMonObjRep::codaMonObjRep (const cdevTranObj& tranObj)
:system_ (tranObj.system_), reqObj_ (tranObj.reqObj_),
 resultData_ (tranObj.resultData_), userCallback_ (tranObj.userCallback_),
 count_ (1)
{
#ifdef _TRACE_OBJECTS
  printf ("Create codaMonObjRep Class Object\n");
#endif
  // empty
}

codaMonObjRep::~codaMonObjRep (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete codaMonObjRep Class Object\n");
#endif
  if (userCallback_ != 0) {
#ifdef _CDEV_DEBUG
    printf ("Delete userCallback inside codaMonObjRep\n");
#endif
    delete userCallback_;
  }
  userCallback_ = 0;
  count_ = 0;
}

//==========================================================================
//         Implementation of codaMonObj Class
//==========================================================================
codaMonObj::codaMonObj (cdevTranObj& tranObj)
{
#ifdef _TRACE_OBJECTS
  printf ("Create codaMonObj Class Object: First\n");
#endif
  rep = new codaMonObjRep (tranObj);
  tobj = &tranObj;
}

codaMonObj::codaMonObj (const codaMonObj& monObj)
{
#ifdef _TRACE_OBJECTS
  printf ("Create codaMonObj Class Object: Wrapper\n");
#endif
  rep = monObj.rep;
  rep->count_++;
  tobj = monObj.tobj;
}

codaMonObj::~codaMonObj (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete codaMonObj Class Object\n");
#endif
  if (--rep->count_ <= 0)
    delete rep;
  // do not delete transaction object, it will remove it self
  tobj = 0;
}
