/* autosize_html.c -- Demonstrate the autosizing feature of a XmHTML widget */
#include <XmHTML/XmHTML.h>

int
main(int argc, char **argv)
{
	Widget toplevel;
	XtAppContext app;

	toplevel = XtVaAppInitialize(&app, "Demos", NULL, 0,
		&argc, argv, NULL, NULL);

	/* make sure we may resize ourselves */
	XtVaSetValues(toplevel, XmNallowShellResize, True, NULL);

	/* create a XmHTML widget but this time enable autosizing */
	XtVaCreateManagedWidget("html", xmHTMLWidgetClass, toplevel,
		XmNvalue, "<html><body>An AutoSizing XmHTML widget.</body></html>",
		XmNresizeWidth, True,
		XmNresizeHeight, True,
		NULL);

	XtRealizeWidget(toplevel);
	XtAppMainLoop(app);
	return(0);
}
