/* -*- C++ -*- */
/* Defines the SVR4 STREAM pipe address format. */

/* Do nothing constructor. */

INLINE
SPIPE_Addr::SPIPE_Addr (void): Addr (AF_SPIPE, sizeof this->SPIPE_addr_)
{
  (void) ::memset ((void *) &this->SPIPE_addr_, 0, sizeof this->SPIPE_addr_);
}

/* Copy constructor. */

INLINE
SPIPE_Addr::SPIPE_Addr (const SPIPE_Addr &sa)
			       : Addr (AF_SPIPE,
				       sizeof this->SPIPE_addr_.gid_ + sizeof this->SPIPE_addr_.uid_
				       + ::strlen (this->SPIPE_addr_.rendezvous_))
{
  (void) ::memcpy ((void *) &this->SPIPE_addr_, (void *) &sa.SPIPE_addr_, sa.get_size ());
}

INLINE SPIPE_Addr &
SPIPE_Addr::operator= (const SPIPE_Addr &sa)
{
  if (this != &sa)
    (void) ::memcpy ((void *) &this->SPIPE_addr_, (void *) &sa.SPIPE_addr_, sa.get_size ());
  return *this;
}

INLINE void 
SPIPE_Addr::set (const char rendezvous_point[], gid_t gid, uid_t uid)
{
  this->Addr::base_set (AF_SPIPE, ::strlen (rendezvous_point) + 
			+ sizeof this->SPIPE_addr_.uid_
			+ sizeof this->SPIPE_addr_.gid_);
  (void) ::strncpy (this->SPIPE_addr_.rendezvous_, rendezvous_point, 
		    sizeof this->SPIPE_addr_.rendezvous_);
  this->SPIPE_addr_.gid_ = gid == 0 ? ::getgid () : gid;
  this->SPIPE_addr_.uid_ = uid == 0 ? ::getuid () : uid;
}

/* Create a Addr from a SPIPE pathname. */

INLINE
SPIPE_Addr::SPIPE_Addr (const char rendezvous_point[], gid_t gid, uid_t uid)
{
  this->set (rendezvous_point, gid, uid);
}

/* Transform the current address into string format. */

INLINE int
SPIPE_Addr::addr_to_string (char s[], size_t len) const
{
  ::strncpy (s, this->SPIPE_addr_.rendezvous_, len);
  return 0;
}

/* Return the address. */

INLINE void *
SPIPE_Addr::get_addr (void) const
{
  return (void *) &this->SPIPE_addr_;
}

/* Compare two addresses for equality. */

INLINE int
SPIPE_Addr::operator == (const Addr &sap) const
{
  return ::strcmp (this->SPIPE_addr_.rendezvous_,
		   ((SPIPE_Addr &) sap).SPIPE_addr_.rendezvous_) == 0;
}

/* Compare two addresses for inequality. */

INLINE int
SPIPE_Addr::operator != (const Addr &sap) const
{
  return !((*this) == sap);	/* This is lazy, of course... ;-) */
}

/* Return the path name used for the rendezvous point. */

INLINE const char *
SPIPE_Addr::get_path_name (void) const
{
  return this->SPIPE_addr_.rendezvous_;
}

INLINE uid_t
SPIPE_Addr::get_user_id (void) const
{
  return this->SPIPE_addr_.uid_;
}

INLINE void	         
SPIPE_Addr::set_user_id (uid_t uid)
{
  this->SPIPE_addr_.uid_ = uid;
}

INLINE gid_t
SPIPE_Addr::get_group_id (void) const
{
  return this->SPIPE_addr_.gid_;
}

INLINE void
SPIPE_Addr::set_group_id (gid_t gid)
{
  this->SPIPE_addr_.gid_ = gid;
}
