// The following configuration file is designed to work
// for OSF1 platforms.

// Compiler/platform correctly calls init()/fini().
#define ACE_HAS_AUTOMATIC_INIT_FINI

// Prototypes for both signal() and struct sigaction are consistent.
#define ACE_HAS_CONSISTENT_SIGNAL_PROTOTYPES

// Platform supports the OSF TLI timod STREAMS module.
#define ACE_HAS_OSF_TIMOD_H

// Platform contains <poll.h>.
#define ACE_HAS_POLL

// Platform supports POSIX timers via timestruc_t.
#define ACE_HAS_POSIX_TIMERS

// ACE supports POSIX Pthreads.
#define ACE_HAS_PTHREADS

// Explicit dynamic linking permits "lazy" symbol resolution
#define ACE_HAS_RTLD_LAZY_V

// Compiler/platform defines the sig_atomic_t typedef.
#define ACE_HAS_SIG_ATOMIC_T

// Compiler/platform supports struct strbuf.
#define ACE_HAS_STRBUF_T

// Platform supports STREAMS.
#define ACE_HAS_STREAMS

// Platform supports STREAM pipes.
#define ACE_HAS_STREAM_PIPES

// Compiler/platform supports SVR4 dynamic linking semantics.
#define ACE_HAS_SVR4_DYNAMIC_LINKING

// Compiler/platform supports SVR4 signal typedef.
#define ACE_HAS_SVR4_SIGNAL_T

// Platform provides <sys/filio.h> header.
#define ACE_HAS_SYS_FILIO_H

// ACE supports threads.
#define ACE_HAS_THREADS

// Platform supports TLI tiuser header.
#define ACE_HAS_TIUSER_H

// Compile using multi-thread libraries.
#define ACE_MT_SAFE

// Turns off the tracing feature.
#define ACE_NTRACE

// Defines the page size of the system.
#define ACE_PAGE_SIZE 4096

