'\"
'\" Copyright (c) 1995 AT&T Bell Laboratories
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Id: usual.n,v 1.1.1.1 1996/08/21 19:25:47 heyes Exp $
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH usual n "" itk "[incr\ Tk]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
usual \- access default option-handling commands
.br
	for a mega-widget component
.SH SYNOPSIS
\fBusual \fItag\fR ?\fIcommands\fR?
.BE

.SH DESCRIPTION
.PP
The \fBusual\fR command is used outside of an \fB[incr\ Tcl]\fR
class definition to define the usual set of option-handling
commands for a component widget.  Option-handling commands
are used when a component is registered with the \fBArchetype\fR
base class via the "\fBitk_component add\fR" method.  They
specify how the component's configuration options should be
integrated into the composite option list for the mega-widget.
Options can be kept, renamed, or ignored, as described in the
\fBArchetype\fR man page.
.PP
It is tedious to include the same declarations again and again
whenever components are added.  The \fBusual\fR command allows
a standard code fragment to be registered for each widget class,
which is used by default to handle the options.  All of the
standard Tk widgets have \fBusual\fR declarations defined in
the \fB[incr\ Tk]\fR library.  Similar \fBusual\fR declarations
should be created whenever a new mega-widget class is conceived.
Only the most-generic options should be included in the \fBusual\fR
declaration.
.PP
The \fItag\fR string is usually the name of a widget class,
which starts with a capital letter; however, any string registered
here can be used later with the \fBusual\fR command described
on the \fBArchetype\fR man page.
.PP
If the \fIcommands\fR argument is specified, it is associated
with the \fItag\fR string, and can be accessed later via
\fBitk_component add\fR.  Otherwise, this command looks for
an existing \fItag\fR string and returns the commands associated
with it.  If there are no commands associated with \fItag\fR,
this command returns the null string.

.SH EXAMPLE
Following is the \fBusual\fR declaration for the standard
Tk button widget:
.CS
usual Button {
    keep -background -cursor -foreground -font
    keep -activebackground -activeforeground -disabledforeground
    keep -highlightcolor -highlightthickness
    rename -highlightbackground -background background Background
}
.CE
Only the options that would be common to all buttons in a
single mega-widget are kept or renamed.  Options like "-text"
that would be unique to a particular button are ignored.

.SH KEYWORDS
itk, Archetype, component, mega-widget
