/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Function prototypes for interface between layer 1 and layer 2
 *	of the FNAL-CEBAF FASTBUS std routines
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fb_proto_1.h,v $
 *   Revision 1.1.1.1  1996/08/21 19:20:38  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/15  12:01:33  12:01:33  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.1  1993/05/24  20:18:43  watson
 *	  Initial revision
 *
 *	  Revision 1.2  1992/08/26  14:46:58  watson
 *	  (FNAL Jim/Kent) mods to remove EG from block broadcast calls
 *
 */

#ifndef INCfbproto1
#define INCfbproto1

/* Function prototypes for routines w/ no macro version */

void fb_fbinit_1();

#if FB_BUILD_INLINE == 0

/****************************************************************************
 *
 *        Function prototypes for routines w/ macro versions 
 *
 ****************************************************************************/

/******************** Single Word Read/Write ********************************/

void fb_frd_1(int pa, int sa, unsigned long *data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);

void fb_fwd_1(int pa, int sa, unsigned long data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);

void fb_frc_1(int pa, int sa, unsigned long *data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);

void fb_fwc_1(int pa, int sa, unsigned long data, int eg, int noarb, 
	      int nopa, int nosa, int noda, int holdas, int hold);

/******************** Multi-Listener Read/Write *****************************/

void fb_frdm_1(int pa, int sa, unsigned long *data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);

void fb_fwdm_1(int pa, int sa, unsigned long data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);

void fb_frcm_1(int pa, int sa, unsigned long *data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);

void fb_fwcm_1(int pa, int sa, unsigned long data, int noarb, 
	       int nopa, int nosa, int noda, int holdas, int hold);

/******************** Block Read/Write **************************************/

void fb_frdb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

void fb_fwdb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

void fb_frcb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

void fb_fwcb_1(int pa, int sa, unsigned long *data, int maxbytes, int eg, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

/******************** Multi-Listener Block Read/Write ***********************/

void fb_frdbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

void fb_fwdbm_1(int pa, int sa, unsigned long *data, int maxbytes,  
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

void fb_frcbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

void fb_fwcbm_1(int pa, int sa, unsigned long *data, int maxbytes, 
		int noarb, int nopa, int nosa, int noda, int pipe, 
		int holdas, int hold, int nowait);

/******************** Secondary Address Read/Write **************************/

void fb_frdsa_1(int pa, unsigned long *sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);

void fb_fwdsa_1(int pa, unsigned long sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);

void fb_frcsa_1(int pa, unsigned long *sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);

void fb_fwcsa_1(int pa, unsigned long sa, int eg, int noarb, 
		int nopa, int nosa, int holdas, int hold);

/******************** Support / Primitive Operations ************************/

void fb_fbprst_1();

void fb_frlen_1(unsigned long *data);

void fb_fcarb_1();

void fb_fcrel_1();

void fb_fcpd_1(int pa);

void fb_fcpdm_1(int pa);

void fb_fcpc_1(int pa);

void fb_fcpcm_1(int pa);

void fb_fcdisc_1();

void fb_fcrw_1(int *data);

void fb_fcww_1(int data);

void fb_fcrsa_1(int *data);

void fb_fcwsa_1(int data);

void fb_fcrb_1(int *data, int maxbytes);

void fb_fcwb_1(int *data, int maxbytes);

void fb_fbprst_1();

#endif  /* (if FB_BUILD_INLINE==0) */

#endif 	/* ifndef INCfbproto1 */

