/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Utility for FASTBUS RPC calls (client program)
 *	
 * Author David Abbott, TJNAF Data Acquisition Group
 *
 */

#include <stdio.h>
#include <string.h>
#include "fb.h"

#define MAX_DATA_BLOCK 100

main(argc,argv)
     int argc;
     char *argv[];
{
  int fbstat,pa,sa,data,len,x;
  int ii, stat, nfields;
  unsigned long block[MAX_DATA_BLOCK];
  char line[80];
  char command[80];

  if (argc<2) {
    printf("Usage: fbp <target>\n");
    return;
  }

  fbopen(argv[1],&stat);
  if (stat!=1) {
    printf("failed to establish connection to target machine %s\n",argv[1]);
    printf("Usage: fbp <target>\n");
    return;
  }



  if (argc==2) {
    printf("Successful connection established to %s\n",argv[1]);
    printf("FB command: ");
    while (gets(line)!=NULL) {
      nfields = sscanf(line,"%s%i%i%i",&command[0],&pa,&sa,&data);
      if (strncmp(command,"fpac",4) == 0) {
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fpac(pa,sa);
	  break;
	case 3:
	  fbstat = fpac(pa,sa);
	  break;
	default:
	  printf("bad arguments (%d): fpac <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpad",4) == 0) {
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fpad(pa,sa);
	  break;
	case 3:
	  fbstat = fpad(pa,sa);
	  break;
	default:
	  printf("bad arguments (%d): fpad <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fprel",5) == 0) {
	switch (nfields) {
	case 1:
	  fbstat = fprel();
	  break;
	default:
	  printf("bad arguments (%d): fprel\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpsaw",5) == 0) {
	switch (nfields) {
	case 2:
	  fbstat = fpsaw(pa);
	  break;
	default:
	  printf("bad arguments (%d): fpsaw <sa>\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fprcm",5) == 0) {
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fprcm(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	case 3:
	  fbstat = fprcm(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	default:
	  printf("bad arguments (%d): fprcm <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fprdm",5) == 0) {
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fprdm(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	case 3:
	  fbstat = fprdm(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	default:
	  printf("bad arguments (%d): fprdm <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fprc",4) == 0) {
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fprc(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	case 3:
	  fbstat = fprc(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	default:
	  printf("bad arguments (%d): fprc <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fprd",4) == 0) {
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fprd(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	case 3:
	  fbstat = fprd(pa,sa,&data);
	  printf("val = 0x%x\n",data);
	  break;
	default:
	  printf("bad arguments (%d): fprd <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpr",3) == 0) {
	switch (nfields) {
	case 1:
	  sa=0;
	  fbstat = fpr();
	  printf("val = 0x%x\n",fbstat);
	  fbstat = 0;
	  break;
	default:
	  printf("bad arguments (%d): fpr\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpwcm",5) == 0) {
	switch (nfields) {
	case 4:
	  fbstat = fpwcm(pa,sa,data);
	  break;
	default:
	  printf("bad arguments (%d): fpwcm <pa> <sa> <data>\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpwdm",5) == 0) {
	switch (nfields) {
	case 4:
	  fbstat = fpwdm(pa,sa,data);
	  break;
	default:
	  printf("bad arguments (%d): fpwdm <pa> <sa> <data>\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpwc",4) == 0) {
	switch (nfields) {
	case 4:
	  fbstat = fpwc(pa,sa,data);
	  break;
	default:
	  printf("bad arguments (%d): fpwc <pa> <sa> <data>\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpwd",4) == 0) {
	switch (nfields) {
	case 4:
	  fbstat = fpwd(pa,sa,data);
	  break;
	default:
	  printf("bad arguments (%d): fpwd <pa> <sa> <data>\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpw",3) == 0) {
	switch (nfields) {
	case 2:
	  fbstat = fpw(pa);
	  break;
	default:
	  printf("bad arguments (%d): fpw <val>\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"fpbr",4) == 0) {
	len=0;
	bzero((char *)block, sizeof(block));
	switch (nfields) {
	case 2:
	  sa=0;
	  fbstat = fpbr(pa,sa,&len,&block[0]);
	  printf("len = %d\n",len);
	  break;
	case 3:
	  fbstat = fpbr(pa,sa,&len,&block[0]);
	  printf("len = %d\n",len);
	  break;
	default:
	  printf("bad arguments (%d): fpbr <pa> [sa]\n",nfields);
	  fbstat = -1;
	}
	if ((fbstat==0) && (len > 0)) {
	  printf("DATA: ");
	  for(ii=0;ii<len;ii++) {
	    if ((ii % 4) == 0) printf("\n    ");
	    printf("  0x%08x",block[ii]);
	  }
	  printf("\n");
	}
      } else if (strncmp(command,"init",4) == 0) {
	switch (nfields) {
	case 1:
	  fb_init_1(0);
	  fbstat = 0;
	  break;
	case 2:
	  fb_init_1(pa);
	  fbstat = 0;
	  break;
	default:
	  printf("bad arguments (%d): init [addr]\n",nfields);
	  fbstat = -1;
	}
      } else if (strncmp(command,"reset",5) == 0) {
	switch (nfields) {
	case 1:
	  sfi_error_decode(0);
	  fbstat = 0;
	  break;
	case 2:
	  sfi_error_decode(pa);
	  fbstat = 0;
	  break;
	default:
	  printf("bad arguments (%d): reset [pflag]\n",nfields);
	  fbstat = -1;
	}
      } else if((strncmp(command,"exit",4) == 0)||(strncmp(command,"quit",4) == 0)) {
	break;
      } else {
	printf("Bad argument\n");
	printf("  Options: fpac          fprc\n");
	printf("           fpad          fpwc\n");
	printf("           fprel         fprd\n");
	printf("           fpr           fpwd\n");
	printf("           fpw           fprcm\n");
	printf("           fpsaw         fpwcm\n");
	printf("           init          fprdm\n");
	printf("           reset         fpwdm\n");
	printf("           fpbr\n");
	printf("           exit(quit)\n");
      }
      if(fbstat) {
	printf(" ERROR: fbstat = 0x%x\n",fbstat);
	fbstat = 0;
      }
      command[0] = NULL;
      printf("FB command: ");
    }
    printf("\n");
  } else {
    printf("Invalid number of arguments\n");
    printf("Usage: fbp <target>\n");
  }

  printf("Goodbye\n");
  exit(0);
}

