/* ----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * TJNAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (757) 269-7190  Fax: (757) 269-5800
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	FASTBUS rpc definitions
 *	
 * Author:  David Abbott, TJNAF Data Acquisition Group
 *
 */

const MAX_DATA_BLOCK = 100;


struct FB_PSD {
    int pa;
    int sa;
    int data;
};

struct FB_PS {
    int pa;
    int sa;
};

struct FB_SD {
    int status;
    int data;
};

struct FB_SLD {
    int status;
    int len;
    int data[MAX_DATA_BLOCK];
};

program FBSRVR {
  version FBVERS {
    int FB_RPCFBINIT(int)=1;
    int FB_RPCFBRESET(int)=2;
    int FB_RPCFPAC(FB_PS)=3;
    int FB_RPCFPAD(FB_PS)=4;
    int FB_RPCFPREL(void)=5;
    int FB_RPCFPR(void)=6;
    int FB_RPCFPW(int)=7;
    int FB_RPCFPSAW(int)=8;
    FB_SD FB_RPCFPRC(FB_PS)=9;
    int FB_RPCFPWC(FB_PSD)=10;
    FB_SD FB_RPCFPRD(FB_PS)=11;
    int FB_RPCFPWD(FB_PSD)=12;
    FB_SD FB_RPCFPRCM(FB_PS)=13;
    int FB_RPCFPWCM(FB_PSD)=14;
    FB_SD FB_RPCFPRDM(FB_PS)=15;
    int FB_RPCFPWDM(FB_PSD)=16;
    FB_SLD FB_RPCFPBR(FB_PS)=17;
  } = 1;
} = 0x2c0da0fb;
