/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 * ------------
 *  RPC interface routines for FASTBUS standard routines
 *  Both C and Fortran interfaces are provided.
 *	
 * Author:  David Abbott, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fbClientLib.c,v $
 *   Revision 1.1  1998/04/15 13:57:12  abbottd
 *   Initial Revision
 *
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "fbRpc.h"

CLIENT *fbHandle;

void fbopen(char *server,int *success)
{
  fbHandle = clnt_create(server,FBSRVR,FBVERS,"tcp");
  if (fbHandle == NULL) {
    (void) clnt_pcreateerror(server);
    *success=0;
  }
  else
    *success=1;
}
void fbopen_(char *server,int *success,int server_len)
{
  char *s;
  s = (char *) malloc(server_len+1);
  strncpy(s,server,server_len);
  s[server_len]=0;		/* make null terminated string */
  (void) fbopen(s,success);
  free(s);
}

void fb_init_1(unsigned long addr)
{
  int arg;
  int *r;
  arg = addr;
  r = fb_rpcfbinit_1(&arg,fbHandle);
}
void fb_init_1_(unsigned long *addr)
{
  fb_init_1(*addr);
}

void sfi_error_decode(int flag)
{
  int arg;
  int *r;
  arg = flag;
  r = fb_rpcfbreset_1(&arg,fbHandle);
}
void sfi_error_decode_(int *flag)
{
  sfi_error_decode(*flag);
}


unsigned long fpac(int pa,int sa)
{
  FB_PS arg;
  int *r;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfpac_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpac_(int *pa,int *sa)
{
  return(fpac(*pa,*sa));
}

unsigned long fpad(int pa,int sa)
{
  FB_PS arg;
  int *r;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfpad_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpad_(int *pa,int *sa)
{
  return(fpad(*pa,*sa));
}

unsigned long fprel(void)
{
  int *r;
  r = fb_rpcfprel_1(NULL,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fprel_()
{
  return(fprel());
}

unsigned long fpr(void)
{
  int *r;
  r = fb_rpcfpr_1(NULL,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpr_()
{
  return(fpr());
}

unsigned long fpw(int data)
{
  int arg;
  int *r;
  arg = data;
  r = fb_rpcfpw_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpw_(int *data)
{
  return(fpw(*data));
}

unsigned long fpsaw(int sa)
{
  int arg;
  int *r;
  arg = sa;
  r = fb_rpcfpsaw_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpsaw_(int *sa)
{
  return(fpsaw(*sa));
}

unsigned long fprc(int pa,int sa, int *data)
{
  FB_PS arg;
  FB_SD *r;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfprc_1(&arg,fbHandle);
  if (r!=NULL) {
    *data = r->data;
    return (r->status);
  }else{
    *data = -1;
    return (0);
  }
}
unsigned long fprc_(int *pa,int *sa, int *data)
{
  return(fprc(*pa,*sa,data));
}

unsigned long fpwc(int pa,int sa,int data)
{
  FB_PSD arg;
  int *r;
  arg.pa= pa;
  arg.sa= sa;
  arg.data = data;
  r = fb_rpcfpwc_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpwc_(int *pa,int *sa, int *data)
{
  return(fpwc(*pa,*sa,*data));
}

unsigned long fprd(int pa,int sa, int *data)
{
  FB_PS arg;
  FB_SD *r;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfprd_1(&arg,fbHandle);
  if (r!=NULL) {
    *data = r->data;
    return (r->status);
  }else{
    *data = -1;
    return (0);
  }
}
unsigned long fprd_(int *pa,int *sa, int *data)
{
  return(fprd(*pa,*sa,data));
}

unsigned long fpwd(int pa,int sa,int data)
{
  FB_PSD arg;
  int *r;
  arg.pa= pa;
  arg.sa= sa;
  arg.data = data;
  r = fb_rpcfpwd_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpwd_(int *pa,int *sa, int *data)
{
  return(fpwd(*pa,*sa,*data));
}

unsigned long fprcm(int pa,int sa, int *data)
{
  FB_PS arg;
  FB_SD *r;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfprcm_1(&arg,fbHandle);
  if (r!=NULL) {
    *data = r->data;
    return (r->status);
  }else{
    *data = -1;
    return (0);
  }
}
unsigned long fprcm_(int *pa,int *sa, int *data)
{
  return(fprcm(*pa,*sa,data));
}

unsigned long fpwcm(int pa,int sa,int data)
{
  FB_PSD arg;
  int *r;
  arg.pa= pa;
  arg.sa= sa;
  arg.data = data;
  r = fb_rpcfpwcm_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpwcm_(int *pa,int *sa, int *data)
{
  return(fpwcm(*pa,*sa,*data));
}

unsigned long fprdm(int pa,int sa, int *data)
{
  FB_PS arg;
  FB_SD *r;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfprdm_1(&arg,fbHandle);
  if (r!=NULL) {
    *data = r->data;
    return (r->status);
  }else{
    *data = -1;
    return (0);
  }
}
unsigned long fprdm_(int *pa,int *sa, int *data)
{
  return(fprdm(*pa,*sa,data));
}

unsigned long fpwdm(int pa,int sa,int data)
{
  FB_PSD arg;
  int *r;
  arg.pa= pa;
  arg.sa= sa;
  arg.data = data;
  r = fb_rpcfpwdm_1(&arg,fbHandle);
  if (r!=NULL) 
    return (*r);
  else
    return (0);
}
unsigned long fpwdm_(int *pa,int *sa, int *data)
{
  return(fpwdm(*pa,*sa,*data));
}

unsigned long fpbr(int pa,int sa, int *len, int *data)
{
  FB_PS arg;
  FB_SLD *r;
  int ii;
  arg.pa= pa;
  arg.sa= sa;
  r = fb_rpcfpbr_1(&arg,fbHandle);
  if (r!=NULL) {
    if (r->len > 0) {
      *len = r->len;
      bcopy((char *)&r->data,(char *) &data[0],(r->len)<<2);
    }else{
      *len = 0;
    }
    return (r->status);
  }else{
    *len = 0;
    *data = -1;
    return (0);
  }
}
unsigned long fpbr_(int *pa,int *sa, int *len, int *data)
{
  return(fpbr(*pa,*sa,len,data));
}

