/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Function prototypes for FASTBUS standard routines
 *	
 * Author:  David Abbott, TJNAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: fb.h,v $
 *   Revision 1.1  1998/04/15 13:57:12  abbottd
 *   Initial Revision
 *
 */

void fbopen(char *server,int *success);
void fb_init_1(int addr);
void sfi_error_decode (int flag);
unsigned long fpac(int pa, int sa);
unsigned long fpad(int pa, int sa);
unsigned long fprel();
unsigned long fpr();
unsigned long fpw(int data);
unsigned long fpsaw(int sa);
unsigned long fprc(int pa, int sa, int *data);
unsigned long fprd(int pa, int sa, int *data);
unsigned long fpwc(int pa, int sa, int data);
unsigned long fpwd(int pa, int sa, int data);
unsigned long fprcm(int pa, int sa, int *data);
unsigned long fprdm(int pa, int sa, int *data);
unsigned long fpwcm(int pa, int sa, int data);
unsigned long fpwdm(int pa, int sa, int data);
unsigned long fpbr(int pa, int sa, int *len, unsigned long *data);




