/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *   spy event on network
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_spy_event.c,v $
 *   Revision 1.16  1999/12/14 14:42:01  abbottd
 *   fixed bug with ET event spying
 *
 *   Revision 1.15  1999/11/23 14:30:39  timmer
 *   new et api
 *
 *   Revision 1.14  1999/10/21 13:25:03  abbottd
 *   fix typo for variable used for ET SPY mode
 *
 *   Revision 1.13  1999/08/27 14:58:58  timmer
 *   new et_open api
 *
 *   Revision 1.12  1999/07/19 19:23:46  timmer
 *   fix ET bug
 *
 *   Revision 1.10  1999/02/08 15:27:24  timmer
 *   et api change
 *
 *   Revision 1.9  1999/01/22 15:53:44  timmer
 *   et upgrade
 *
 *   Revision 1.8  1998/10/09 18:58:41  timmer
 *   update ET parts
 *
 *   Revision 1.5  1998/08/19 19:08:55  timmer
 *   added ET capability
 *
 *   Revision 1.4  1997/06/11 17:30:09  heyes
 *   fix for configure
 *
 *   Revision 1.3  1997/06/11 01:44:17  heyes
 *   spy on DD systemcd /usr/local/coda/linux/source/event/xcefdmp!
 *
 *   Revision 1.2  1997/06/07 11:25:15  heyes
 *   fix for linux
 *
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  
 */

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include "xcef.h"
#include "xcef_layout.h"

#ifdef WITH_ET
 #include <time.h>
 #include <et.h>
 #define BYTES_PER_WORD 4
 char		*et_name;
 int		et_init=0;
 et_sys_id 	et_sys;
 et_att_id	et_my_attach;
 et_stat_id	et_stat = -1;
#else
 #include <dd_sys.h>
 #include <dd_user.h>
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

static int go_on;


static int get_event_num();
static evTreeNode *prev_tree = 0;

extern char *strsave();
extern evTreeNode *EvTreeConstruct();
extern void        show_tree();
extern void        free_ev_tree();

static int daCopyRegister (name, tag)
     char *name;
     int  tag;
{
  return -1;
}

static int daCopy (buffer, size, rate)
     char* buffer;
     int   size;
     int rate;
{
  return -1;
}

static int daCopyUnregister (name, tag)
     char* name;
     int   tag;
{
  return -1;
}


void spy_timer(client_data,temp_id)
XtPointer client_data;
XtIntervalId temp_id;
{
  evTreeNode *root;
  int        ev_size,t_length;
  int        status,tag_value;
  int        e_num;
  short      t_type;
  char       temp[4],e_count[20];
  char       *obj_name;

  tag_value = (int)client_data;

#ifdef WITH_ET    
  if (!et_init) {
    int i, nevents_max;
    int selections[ET_STATION_SELECT_INTS];
    et_statconfig   sconfig;
    et_openconfig   openconfig;
    struct timespec timeout;
    
    timeout.tv_sec  = 10;
    timeout.tv_nsec = 0;

    obj_name = strsave(SOURCE);
    et_name  = getenv("ET_NAME");
    
    if (et_name == NULL) {
      printf("spy_timer: cannot find ET system's name\n");
      free (obj_name);
      return;
    }
    
    if (et_open_config_init(&openconfig) != ET_OK) {
      printf("spy_timer: cannot allocate mem to open ET system\n");
      free (obj_name);
      return;
    }
    et_open_config_setwait(openconfig, ET_OPEN_WAIT);
    et_open_config_settimeout(openconfig, timeout);
    if (et_open(&et_sys, et_name, openconfig) != ET_OK) {
      printf("spy_timer: problems opening ET system\n");
      free (obj_name);
      return;
    }
    et_open_config_destroy(openconfig);
      
    if (et_system_getnumevents(et_sys, &nevents_max) != ET_OK) {
      printf("spy_timer: ET system has died");
      free (obj_name);
      return;
    }

    printf("initialize ET station\n");
    if(et_station_config_init(&sconfig) < 0) 
      printf("spy_timer: ERROR in et_station_config_init\n");
    if(et_station_config_setuser(sconfig, ET_STATION_USER_SINGLE) < 0)
      printf("spy_timer: ERROR in et_station_config_setuser\n");
    if(et_station_config_setrestore(sconfig, ET_STATION_RESTORE_OUT) < 0)
      printf("spy_timer: ERROR in et_station_config_setrestore\n");
    if(et_station_config_setselect(sconfig, ET_STATION_SELECT_ALL) < 0)
      printf("spy_timer: ERROR in et_station_config_setselect\n");
    if(et_station_config_setblock(sconfig, ET_STATION_NONBLOCKING) < 0)
      printf("spy_timer: ERROR in et_station_config_setblock\n");
    if(et_station_config_setprescale(sconfig, 1) < 0)
      printf("spy_timer: ERROR in et_station_config_setprescale\n");
    if(et_station_config_setcue(sconfig, 1) < 0)
      printf("spy_timer: ERROR in et_station_config_setcue\n");
    
    for (i=1; i<ET_STATION_SELECT_INTS; i++) {
      selections[i] = -1;
    }
    selections[0] = tag_value;
    if(et_station_config_setselectwords(sconfig, selections) < 0)
      printf("spy_timer: ERROR in et_station_config_selectwords\n");

    
    if ((status = et_station_create(et_sys, &et_stat, obj_name, sconfig)) < 0) {
      if (status == ET_ERROR_EXISTS) {
        printf("spy_timer: et station already exists, will attach\n");
      }
      else if (status == ET_ERROR_TOOMANY) {
        printf("spy_timer: max # of et stations already created\n");
        et_close(et_sys);
        free (obj_name);
        return;
      }
      else {
        printf("spy_timer: error in et station creation. status = %d\n",status);
        et_close(et_sys);
        free (obj_name);
        return;
      }
    }

    if (et_station_attach(et_sys, et_stat, &et_my_attach) < 0) {
      printf("spy_timer: error in et station attach\n");
      et_close(et_sys);
      free (obj_name);
      return;
    }
    free (obj_name);
    et_init = 1;
  }

  if (et_alive(et_sys)) {
    int length;
    et_event *pe;
    void *pdata;
    
    status = et_event_get(et_sys, et_my_attach, &pe, ET_ASYNC, NULL);
    if (status != ET_OK){
      if (status == ET_ERROR_BUSY || status == ET_ERROR_EMPTY){
        goto end;
      }
      printf("spy_timer: et_get_event status returned %d\n",status);
      return;
    }
    et_event_getdata(pe, &pdata);
    et_event_getlength(pe, &length);
    memcpy((void *)ev, pdata, (size_t) length);
    t_type = 0xC;  /* type is always a bank */
    t_length = length/BYTES_PER_WORD - 1;
    e_num = get_event_num(ev);
    sprintf(e_count,"%d",e_num);
    XmTextSetString(text_in3,e_count);
    root = EvTreeConstruct(ev,t_type,t_length);
    show_tree(root);
    if (prev_tree){ /* I cannot just free root since pushbutton may use it */
      free_ev_tree (prev_tree);
      prev_tree = 0;
    }
    prev_tree = root;
    status = et_event_put(et_sys, et_my_attach, pe);
    if (status != ET_OK){
      printf("spy_timer: ERROR in et_put_event - status returned %d\n",status);
      return;
    }
  }

#else  
  if (!ddu_attached()) {
    struct fifo_mode fmode;
    int ctl[4];
    
    obj_name = strsave(SOURCE);
    /*    if (event_mode == 0) {*/
      fmode.mode = FMODE_ONREQ;
      /* } else {
      fmode.mode = FMODE_ALL;
    }*/

    fmode.wait = FWAIT_ASYNC;
    fmode.prescale = 1;
    fmode.suser = FMODE_MULTI_USER;
    fmode.p2ctl = ctl;
    ctl[0] = tag_value;
    ctl[1] = -1;
    ctl[2] = -1;
    ctl[3] = -1;
    
    if ( (status = ddu_init(obj_name, fmode) ) != 0 ) {
      printf("ddu_init: status returned %d\n",status);
      free (obj_name);
      return;
    }
    ddu_start();
    free (obj_name);
  }
  
  if (ddu_attached()) {
   struct fifo_entry fev;
   
   status = dbfi_get_fev(&fev);
    if (status != 0){
      if (status == 11) goto end;   /* EAGAIN : Resource temporarily unavailable */  

      printf("ddu_get_fev: status returned %d\n",status);
      return;
    }
    memcpy((char *)ev, (char *)fev.p2da,(fev.len<<2));
    t_type = 0xC;  /* type is always a bank */
    t_length = fev.len -1;
    e_num = get_event_num(ev);
    sprintf(e_count,"%d",e_num);
    XmTextSetString(text_in3,e_count);
    root = EvTreeConstruct(ev,t_type,t_length);
    show_tree(root);
    if (prev_tree){ /* I cannot just free root since pushbutton may use it */
      free_ev_tree (prev_tree);
      prev_tree = 0;
    }
    prev_tree = root;
    dbfi_put_fev(fev);
  }
#endif
  
end:
  spy_id = XtAppAddTimeOut(app_context,spy_rate*1000,spy_timer,
			   (XtPointer)tag_value);
}

static int get_event_num(unsigned long *ev)
{
  int e_num;
  char temp[4];
  int  i,header,key;

  i = 0;
  i= i+12;
  bufcpy(temp,&ev[i]);
  header = *(int *)(temp);
  key = (header >> 16) &(0x0000ffff);
  if(key != 0xc000){  /* roc */
    header = *(int *)(temp);
    e_num = (0x000000ff)&(header);
    return(e_num);
  }
  else{  /* event id bank */
    i = i + 4;
    bufcpy(temp,&ev[i]);
    e_num = *(int *)(temp);
    return(e_num);
  }
}
  
  
  
