/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	X widnow layout 
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_layout.c,v $
 *   Revision 2.4  1999/10/25 17:24:08  abbottd
 *   Red Hat Linux 6.0 fixes/ Remove runcontrol windowmanagment
 *
 *   Revision 2.3  1999/10/21 18:23:32  abbottd
 *   Disable feature for RunControl grabbing xcefdmp window
 *
 *   Revision 2.2  1997/10/20 14:12:28  heyes
 *   made embeddable
 *
 *   Revision 2.1  1997/06/11 17:30:08  heyes
 *   fix for configure
 *
 *   Revision 2.0  1996/09/27 16:27:08  heyes
 *   Changed X defaults.
 *
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  
 */
/*
** Generated by X-Designer 
*/
/*
**LIBS: -lXm -lXt -lX11
*/

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeBG.h>
#include <Xm/LabelG.h>

#include <codaRegistry.h>

#include "xcef.h"
#include "xcef_layout.h"
#include <TreeCODA.h>

String fallback_resources[]={
  "Xcefdmp.iconName:               Xcefdmp",
  "Xcefdmp.*.background:           lightgrey",
  "Xcefdmp.*.foreground:           black",
  "Xcefdmp.*menu_bar.spacing:      15",
  "Xcefdmp.*tree.borderWidth:      0",
  "Xcefdmp.*tree.horizontalSpace:  30",
  "Xcefdmp.*tree.verticalSpace:    5",
  "Xcefdmp.*topShadowColor: white",
  "Xcefdmp.*bottomShadowColor: grey55",
#ifdef HP_UX
  "Xcefdmp.*.fontList:-adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*",
#else
  "Xcefdmp.*.fontList:-adobe-helvetica-medium-r-normal-*-12-*-*-*-*-*-*-*",
#endif
  "Xcefdmp.*text_out.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
  NULL,
};

static void gotoNext();
static void gotoPrevious();
static  XtTranslations transTable;

XtActionsRec textw_actions[]={
  {"goto_next", gotoNext},
  {"goto_previous",gotoPrevious},
};

char textwTrans[]=
"\
<Key>osfUp:    goto_previous() \n\
<Key>osfDown:  goto_next() \n\
";

void XDmanage_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
XtPointer call_data;      /*  data from widget class  */
{
    XtManageChild ( *client_data );
}

void XDunmanage_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
XtPointer call_data;      /*  data from widget class  */
{
    XtUnmanageChild ( *client_data );
}

void XDmap_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
XtPointer call_data;      /*  data from widget class  */
{
    XtMapWidget (*client_data);
}

void XDunmap_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
XtPointer call_data;    /*  data from widget class  */
{
    XtUnmapWidget (*client_data);
}
void XDenable_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
XtPointer call_data;    /*  data from widget class  */
{
    XtSetSensitive (*client_data, TRUE);
}

void XDdisable_link (w, client_data, call_data)
Widget w;		/*  widget id           */
Widget *client_data;	/*  data from application   */
XtPointer call_data;    /*  data from widget class  */
{
    XtSetSensitive (*client_data, FALSE);
}

Widget toplevel;
Widget top_form;
Widget left_form;
Widget label_form;
Widget t_label;
Widget t_left_rc;
Widget sub_form0;
Widget comm0;
Widget text_in0;
Widget sub_form1;
Widget comm1;
Widget text_in1;
Widget sub_form2;
Widget comm2;
Widget text_in2;
Widget sub_form3;
Widget comm3;
Widget text_in3;
Widget help_label;
Widget msg_win;
Widget scale;
Widget frame;
Widget b_left_rc;
Widget form_b_0;
Widget tog_source;
Widget tog_stream;
Widget form_b_1;
Widget pushb0;
Widget pushb1;
Widget form_b_2;
Widget pushb2;
Widget pushb3;
Widget frame_mode;
Widget frame_mode1;
Widget hex_op0;
Widget hex_op1;
Widget dict_op0;
Widget dict_op1;
Widget right_form;
Widget menu_bar;
Widget m_cas0;
Widget pull0;
Widget menu0_0;
Widget menu0_1;
Widget m_cas1;
Widget pull1;
Widget menu1_0;
Widget menu1_1;
Widget m_cas2;
Widget pull2;
Widget menu2_0;
Widget menu2_1;
Widget menu2_2;
Widget menu2_3;
Widget menu2_4;
Widget m_cas3;
Widget pull3;
Widget menu3_0;
Widget m_cas4;
Widget pull4;
Widget menu4_0;
Widget sw;
/*******************
 * add widget tree *
 ******************/
Widget tree;

static void gotoNext(w, event, params, num_params)
Widget    w;
XEvent    *event;
String    *params;
Cardinal  *num_params;
{
  if (w == text_in3){
    XmProcessTraversal (text_in0, XmTRAVERSE_CURRENT);
  }
  else
    XmProcessTraversal (w, XmTRAVERSE_NEXT_TAB_GROUP);
}

static void gotoPrevious(w, event, params, num_params)
Widget    w;
XEvent    *event;
String    *params;
Cardinal  *num_params;
{
  if (w == text_in0)
    XmProcessTraversal (text_in3, XmTRAVERSE_CURRENT);
  else
    XmProcessTraversal (w, XmTRAVERSE_PREV_TAB_GROUP);
}

create_toplevel( display, app_name, app_argc, app_argv )
Display *display;
char *app_name;
int app_argc;
char **app_argv;
{
  Widget children[10];      /* Children to manage */
  Widget sep,sep1;
  Widget sub_form4,sub_form5;
  Arg al[64];           /* Arg List */
  register int ac = 0;      /* Arg Count */
  char from_s [256];    /* For font list conversion */
  XrmValue from_value, to_value; /* ditto */
  XmString *list_items; /* For list items */
  int list_item;        /* Index for list_items */
  XmString xmstrings[15];    /* temporary storage for XmStrings */
  Widget widget33;
  Widget widget34;
  Widget widget35;
  Widget widget50;
  Widget widget51;
  Widget clip_w;

  XtSetArg(al[ac], XmNiconName, "Xcefdmp"); ac++;
  XtSetArg(al[ac], XmNtitle, "Xcefdmp"); ac++;
  XtSetArg(al[ac], XmNallowShellResize, FALSE); ac++;
  XtSetArg(al[ac], XmNargc, app_argc); ac++;
  XtSetArg(al[ac], XmNargv, app_argv); ac++;
  toplevel = XtAppCreateShell ( app_name, "Xcefdmp", applicationShellWidgetClass, display, al, ac );
/*********************************************
 * Create colors and pixmaps                 *
 ********************************************/
	create_pixmaps();
/********************************************/

	ac = 0;
/**********************************************************************
 * changed to handle icon_pixmap                                      *
 *********************************************************************/
  XtSetArg(al[ac], XmNiconPixmap, icon_map); ac++;

  sprintf ( from_s, "-adobe-times-bold-r-normal-*-*-120-*-*-*-*-*-*" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(toplevel, XmRString, &from_value, XmRFontList, &to_value);
  XtSetArg(al[ac], XmNdefaultFontList, *(int *)to_value.addr); ac++;
  XtSetValues ( toplevel,al, ac );
  ac = 0;
  XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
  top_form = XmCreateForm ( toplevel, "top_form", al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNresizePolicy, XmRESIZE_NONE); ac++;
  left_form = XmCreateForm ( top_form, "left_form", al, ac );
  ac = 0;

  label_form = XmCreateForm ( left_form, "label_form", al, ac );

  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Xcefdmp", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  sprintf ( from_s, "-adobe-times-bold-i-normal-*-*-140-*-*-*-*-*-*" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(label_form, XmRString, &from_value, XmRFontList, &to_value);
  XtSetArg(al[ac], XmNfontList, *(int *)to_value.addr); ac++;
  t_label = XmCreateLabel ( label_form, "t_label", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(al[ac], XmNorientation, XmVERTICAL); ac++;
  t_left_rc = XmCreateRowColumn ( left_form, "t_left_rc", al, ac );

  ac = 0;
  XtSetArg(al[ac], XmNfractionBase, 100); ac++;
  sub_form0 = XmCreateForm ( t_left_rc, "sub_form0", al, ac );
  ac = 0;

  xmstrings[0] = XmStringCreateLtoR("Data Source:", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  comm0 = XmCreateLabel ( sub_form0, "comm0", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNeditable, TRUE); ac++;
  XtSetArg(al[ac], XmNeditMode, XmSINGLE_LINE_EDIT); ac++;
  XtSetArg(al[ac], XmNrows, 1); ac++;
  text_in0 = XmCreateText ( sub_form0, "text_in0", al, ac );

  ac = 0;
  XtSetArg(al[ac], XmNfractionBase, 100); ac++;
  sub_form1 = XmCreateForm ( t_left_rc, "sub_form1", al, ac );
  ac = 0;

  xmstrings[0] = XmStringCreateLtoR("Dictionary:", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  comm1 = XmCreateLabel ( sub_form1, "comm1", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNeditable, TRUE); ac++;
  XtSetArg(al[ac], XmNcursorPositionVisible, TRUE); ac++;
  XtSetArg(al[ac], XmNeditMode, XmSINGLE_LINE_EDIT); ac++;
  XtSetArg(al[ac], XmNrows, 1); ac++;
  text_in1 = XmCreateText ( sub_form1, "text_in1", al, ac );

  ac = 0;
  XtSetArg(al[ac], XmNfractionBase, 100); ac++;
  sub_form2 = XmCreateForm ( t_left_rc, "sub_form2", al, ac );

  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("  Tag Name:", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  comm2 = XmCreateLabel ( sub_form2, "comm2", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNrows, 1); ac++;
  text_in2 = XmCreateText ( sub_form2, "text_in2", al, ac );

  ac = 0;
  XtSetArg(al[ac], XmNfractionBase, 100); ac++;
  sub_form3 = XmCreateForm ( t_left_rc, "sub_form3", al, ac );
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Event Number:", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_END); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  comm3 = XmCreateLabel ( sub_form3, "comm3", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNeditable, TRUE); ac++;
  XtSetArg(al[ac], XmNcursorPositionVisible, TRUE); ac++;
  XtSetArg(al[ac], XmNeditMode, XmSINGLE_LINE_EDIT); ac++;
  XtSetArg(al[ac], XmNrows, 1); ac++;
  text_in3 = XmCreateText ( sub_form3, "text_in3", al, ac );
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR(" ", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString,xmstrings[0]); ac++;
  help_label = XmCreateLabel(left_form,"help_label",al, ac);
  XmStringFree(xmstrings[0]);

  ac = 0;
  XtSetArg(al[ac], XmNsensitive, FALSE); ac++;
  XtSetArg(al[ac], XmNtitleString, XmStringCreateLtoR("Event Number Slide", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET)); ac++;
  XtSetArg(al[ac], XmNshowValue, TRUE); ac++;
  XtSetArg(al[ac], XmNminimum, 1); ac++;
  XtSetArg(al[ac], XmNmaximum, 2000); ac++;
  XtSetArg(al[ac], XmNvalue, 1); ac++;
  XtSetArg(al[ac], XmNorientation, XmHORIZONTAL); ac++;
  XtSetArg(al[ac], XmNprocessingDirection, XmMAX_ON_RIGHT); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  scale = XmCreateScale ( left_form, "scale", al, ac );
  
  ac = 0;
  XtSetArg(al[ac], XmNshadowType, XmSHADOW_ETCHED_IN); ac++;
  frame = XmCreateFrame ( left_form, "frame", al, ac );
  
  ac = 0;
  XtSetArg(al[ac], XmNmarginWidth, 0); ac++;
  XtSetArg(al[ac], XmNmarginHeight, 0); ac++;
  XtSetArg(al[ac], XmNorientation, XmVERTICAL); ac++;
  b_left_rc = XmCreateRowColumn ( frame, "b_left_rc", al, ac );
  
  ac = 0;
  form_b_0 = XmCreateForm ( b_left_rc, "form_b_0", al, ac );

  ac = 0;
  XtSetArg(al[ac], XmNshadowThickness, 2); ac++;
  xmstrings[0] = XmStringCreateLtoR("View File", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNmarginTop, 0); ac++;
  XtSetArg(al[ac], XmNmarginBottom, 0); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetArg(al[ac], XmNindicatorOn, FALSE); ac++;
  XtSetArg(al[ac], XmNindicatorType, XmONE_OF_MANY); ac++;
  XtSetArg(al[ac], XmNvisibleWhenOff, FALSE); ac++;
  XtSetArg(al[ac], XmNindicatorSize, 0); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  tog_source = XmCreateToggleButton ( form_b_0, "tog_source", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNshadowThickness, 2); ac++;
  xmstrings[0] = XmStringCreateLtoR("Spy Event", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNmarginTop, 0); ac++;
  XtSetArg(al[ac], XmNmarginBottom, 0); ac++;
  XtSetArg(al[ac], XmNindicatorOn, FALSE); ac++;
  XtSetArg(al[ac], XmNset, TRUE); ac++;
  XtSetArg(al[ac], XmNindicatorType, XmONE_OF_MANY); ac++;
  XtSetArg(al[ac], XmNvisibleWhenOff, FALSE); ac++;
  XtSetArg(al[ac], XmNindicatorSize, 0); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  tog_stream = XmCreateToggleButton ( form_b_0, "tog_stream", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  form_b_1 = XmCreateForm ( b_left_rc, "form_b_1", al, ac );
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("View Next", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  pushb0 = XmCreatePushButton ( form_b_1, "pushb0", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("View Previous", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  pushb1 = XmCreatePushButton ( form_b_1, "pushb1", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  form_b_2 = XmCreateForm ( b_left_rc, "form_b_2", al, ac );
  
  ac = 0;
  XtSetArg(al[ac], XmNsensitive, FALSE); ac++;
  xmstrings[0] = XmStringCreateLtoR("Reserved", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  pushb2 = XmCreatePushButton ( form_b_2, "pushb2", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Quit", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  pushb3 = XmCreatePushButton ( form_b_2, "pushb3", al, ac );
  
  ac = 0;
  XtSetArg(al[ac], XmNshadowType, XmSHADOW_ETCHED_IN); ac++;
  frame_mode = XmCreateFrame ( left_form, "frame_mode", al, ac );
  
  ac = 0;
  sub_form4 = XmCreateForm(frame_mode,"sub_form", al, ac);
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Decimal Dump", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNindicatorType,XmONE_OF_MANY); ac++;
  XtSetArg(al[ac], XmNset, FALSE); ac++;
  XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  hex_op0 = XmCreateToggleButton ( sub_form4, "hex_op0", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Hex Dump", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNindicatorType,XmONE_OF_MANY); ac++;
  XtSetArg(al[ac], XmNset, True); ac++;
  XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  hex_op1 = XmCreateToggleButton ( sub_form4, "hex_op1", al, ac );
  XmStringFree ( xmstrings [ 0 ] );
  
  ac = 0;
  XtSetArg(al[ac], XmNshadowType, XmSHADOW_ETCHED_IN); ac++;
  frame_mode1 = XmCreateFrame ( left_form, "frame_mode1", al, ac );
  
  ac = 0;
  sub_form5 = XmCreateForm(frame_mode1,"sub_form", al, ac);
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Enable Dictionary", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNindicatorType,XmONE_OF_MANY); ac++;
  XtSetArg(al[ac], XmNset, True); ac++;
  XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  dict_op0 = XmCreateToggleButton ( sub_form5, "dict_op0", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Disable Dictionary", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNrecomputeSize, False); ac++;
  XtSetArg(al[ac], XmNindicatorType,XmONE_OF_MANY); ac++;
  XtSetArg(al[ac], XmNset, FALSE); ac++;
  XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
  XtSetArg(al[ac], XmNtraversalOn, False); ac++;
  dict_op1 = XmCreateToggleButton ( sub_form5, "dict_op1", al, ac );
  XmStringFree ( xmstrings [ 0 ] );


  ac = 0;
  XtSetArg (al[ac], XmNrows, 3); ac++;
  XtSetArg (al[ac], XmNeditable, False); ac++;
  XtSetArg (al[ac], XmNeditMode, XmMULTI_LINE_EDIT); ac++;
  XtSetArg (al[ac], XmNwordWrap, True); ac++;
  XtSetArg (al[ac], XmNscrollHorizontal, False); ac++;
  XtSetArg (al[ac], XmNblinkRate, 0); ac++;
  XtSetArg (al[ac], XmNautoShowCursorPosition, True); ac++;
  XtSetArg (al[ac], XmNcursorPositionVisible, False); ac++;
  msg_win = XmCreateScrolledText (left_form, "message_window",al, ac);
  XtManageChild (msg_win);
  
  ac = 0;
  right_form = XmCreateForm ( top_form, "right_form", al, ac );
  
  ac = 0;
  XtSetArg(al[ac], XmNshadowThickness, 0); ac++;
  menu_bar = XmCreateMenuBar ( right_form, "menu_bar", al, ac );

  ac = 0;
  if (XmVersion >= 1002)
    XtSetArg(al[ac], XmNtearOffModel, XmTEAR_OFF_ENABLED); ac++;
  pull0 = XmCreatePulldownMenu ( menu_bar, "pull0", al, ac );
  ac = 0;

  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Open", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu0_0 = XmCreatePushButton ( pull0, "menu0_0", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Quit", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu0_1 = XmCreatePushButton ( pull0, "menu0_1", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Data Source", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  sprintf ( from_s, "S" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(menu_bar, XmRString, &from_value, XmRKeySym, &to_value);
  XtSetArg(al[ac], XmNmnemonic, *(int *)to_value.addr); ac++;
  XtSetArg(al[ac], XmNsubMenuId, pull0); ac++;
  m_cas0 = XmCreateCascadeButton ( menu_bar, "m_cas0", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  if (XmVersion >= 1002)
    XtSetArg(al[ac], XmNtearOffModel, XmTEAR_OFF_ENABLED); ac++;
  pull1 = XmCreatePulldownMenu ( menu_bar, "pull1", al, ac );
  ac = 0;
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Open", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu1_0 = XmCreatePushButton ( pull1, "menu1_0", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("View", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu1_1 = XmCreatePushButton ( pull1, "menu1_1", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Dictionary", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  sprintf ( from_s, "D" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(menu_bar, XmRString, &from_value, XmRKeySym, &to_value);
  XtSetArg(al[ac], XmNmnemonic, *(int *)to_value.addr); ac++;
  XtSetArg(al[ac], XmNsubMenuId, pull1); ac++;
  m_cas1 = XmCreateCascadeButton ( menu_bar, "m_cas1", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  if (XmVersion >= 1002)
    XtSetArg(al[ac], XmNtearOffModel, XmTEAR_OFF_ENABLED); ac++;
  pull2 = XmCreatePulldownMenu ( menu_bar, "pull2", al, ac );
  ac = 0;
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Show Star Tree", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu2_0 = XmCreatePushButton ( pull2, "menu2_0", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Show Fork Tree", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu2_1 = XmCreatePushButton ( pull2, "menu2_1", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  sep = (Widget)XmCreateSeparator(pull2,"sep",al,ac);
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Show two levels", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu2_2 = XmCreatePushButton ( pull2, "menu2_2", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Show all levels", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu2_3 = XmCreatePushButton ( pull2, "menu2_3", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  sep1 = (Widget)XmCreateSeparator(pull2,"sep1",al,ac);

  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Reset to Default", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu2_4 = XmCreatePushButton ( pull2, "menu2_4", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("View", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  XtSetArg(al[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  sprintf ( from_s, "V" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(menu_bar, XmRString, &from_value, XmRKeySym, &to_value);
  XtSetArg(al[ac], XmNmnemonic, *(int *)to_value.addr); ac++;
  XtSetArg(al[ac], XmNsubMenuId, pull2); ac++;
  m_cas2 = XmCreateCascadeButton ( menu_bar, "m_cas2", al, ac );

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  if (XmVersion >= 1002)
    XtSetArg(al[ac], XmNtearOffModel, XmTEAR_OFF_ENABLED); ac++;
  pull3 = XmCreatePulldownMenu ( menu_bar, "pull3", al, ac );
  ac = 0;

  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("Show physics event only", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNindicatorType, XmN_OF_MANY); ac++;
  XtSetArg(al[ac], XmNset, FALSE); ac++;
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu3_0 = XmCreateToggleButton(pull3, "menu3_0", al, ac);
  ac = 0;

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Options", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  sprintf ( from_s, "O" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(menu_bar, XmRString, &from_value, XmRKeySym, &to_value);
  XtSetArg(al[ac], XmNmnemonic, *(int *)to_value.addr); ac++;
  XtSetArg(al[ac], XmNsubMenuId, pull3); ac++;
  m_cas3 = XmCreateCascadeButton ( menu_bar, "m_cas3", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  if (XmVersion >= 1002)
    XtSetArg(al[ac], XmNtearOffModel, XmTEAR_OFF_ENABLED); ac++;
  pull4 = XmCreatePulldownMenu ( menu_bar, "pull4", al, ac );
  ac = 0;
  
  ac = 0;
  xmstrings[0] = XmStringCreateLtoR("About", XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  menu4_0 = XmCreatePushButton(pull4, "menu4_0", al, ac);
  ac = 0;

  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  xmstrings[0] = XmStringCreateLtoR("Help", (XmStringCharSet)XmSTRING_DEFAULT_CHARSET);
  XtSetArg(al[ac], XmNlabelString, xmstrings[0]); ac++;
  sprintf ( from_s, "H" );
  from_value.size = strlen(from_s)+1;
  from_value.addr = from_s;
  XtConvert(menu_bar, XmRString, &from_value, XmRKeySym, &to_value);
  XtSetArg(al[ac], XmNmnemonic, *(int *)to_value.addr); ac++;
  XtSetArg(al[ac], XmNsubMenuId, pull4); ac++;
  m_cas4 = XmCreateCascadeButton ( menu_bar, "m_cas4", al, ac );
  
  ac = 0;
  XmStringFree ( xmstrings [ 0 ] );
  XtSetArg(al[ac], XmNmenuHelpWidget, m_cas4); ac++;
  XtSetValues ( menu_bar,al, ac );
  
  ac = 0;
  XtSetArg(al[ac], XmNscrollBarDisplayPolicy, XmSTATIC); ac++;
  XtSetArg(al[ac], XmNscrollBarPlacement, XmBOTTOM_RIGHT); ac++;
  XtSetArg(al[ac], XmNscrollingPolicy, XmAUTOMATIC); ac++;
  XtSetArg(al[ac], XmNvisualPolicy, XmVARIABLE); ac++;
  sw = XmCreateScrolledWindow ( right_form, "sw", al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNhorizontalScrollBar, &widget50 ); ac++;
  XtSetArg(al[ac], XmNverticalScrollBar, &widget51 ); ac++;
  XtGetValues(sw, al, ac );
  ac = 0;

/*	ac = 0;
	XtSetArg(al[ac], XmNbackground, White); ac++;
	view = XmCreateForm ( sw, "view", al, ac );*/
/***************************************************
 *  create a tree widget to handle graph display   *
 **************************************************/
  XtSetArg (al[ac], XmNborderWidth, 0); ac++;
  tree = XtCreateWidget("tree",xcodaTreeWidgetClass,sw, al, ac);
/***************************************************/
  ac = 0;

  XtSetArg (al[ac], XmNclipWindow, &clip_w); ac++;
  XtGetValues (sw, al, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNtopOffset, 2); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomOffset,    15); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetValues ( left_form,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNtopOffset, 2); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNleftWidget, left_form); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetValues ( right_form,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetValues ( label_form,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, label_form); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++; 
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( t_left_rc,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, t_left_rc); ac++;
  XtSetArg(al[ac], XmNtopOffset, 5); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( scale,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, frame_mode1); ac++;
  XtSetArg(al[ac], XmNtopOffset, 5); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues(help_label, al, ac);
  ac = 0;


  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, help_label); ac++;
  XtSetArg(al[ac], XmNtopOffset, 5); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( frame,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, frame); ac++;
  XtSetArg(al[ac], XmNtopOffset, 15); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomOffset, 5); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( XtParent (msg_win),al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, scale); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( frame_mode,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, frame_mode); ac++;
  XtSetArg(al[ac], XmNtopOffset, 5); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( frame_mode1,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetValues ( t_label,al, ac );
  ac = 0;
  children[ac++] = t_label;
  XtManageChildren(children, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 30); ac++;
  XtSetValues ( comm0,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 32); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( text_in0,al, ac );
  ac = 0;
  XtAddCallback (text_in0, XmNactivateCallback, new_source,(XtPointer)NULL);
  XtOverrideTranslations (text_in0, transTable);
  children[ac++] = comm0;
  children[ac++] = text_in0;
  XtManageChildren(children, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 30); ac++;
  XtSetValues ( comm1,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 32); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( text_in1,al, ac );
  ac = 0;
  XtAddCallback (text_in1, XmNactivateCallback, new_dict,(XtPointer)NULL);
  XtOverrideTranslations (text_in1, transTable);
  children[ac++] = comm1;
  children[ac++] = text_in1;
  XtManageChildren(children, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 30); ac++;
  XtSetValues ( comm2,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNtopOffset, 1); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 32); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( text_in2,al, ac );
  ac = 0;
  XtAddCallback (text_in2, XmNactivateCallback, input_tag, (XtPointer)NULL);
  XtOverrideTranslations (text_in2, transTable);
  children[ac++] = comm2;
  children[ac++] = text_in2;
  XtManageChildren(children, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 30); ac++;
  XtSetValues ( comm3,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 32); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( text_in3,al, ac );
  ac = 0;
  XtAddCallback (text_in3, XmNactivateCallback, new_evn,(XtPointer)NULL);
  XtOverrideTranslations (text_in3, transTable);
  children[ac++] = comm3;
  children[ac++] = text_in3;
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = sub_form0;
  children[ac++] = sub_form1;
  children[ac++] = sub_form2;
  children[ac++] = sub_form3;
  XtManageChildren(children, ac);
  ac = 0;
  XtAddCallback (scale, XmNvalueChangedCallback, new_evn,NULL);
  
  ac = 0;
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 49); ac++;
  XtSetValues( hex_op0, al, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 51); ac++;
  XtSetValues( hex_op1, al, ac);
  ac = 0;
  
  ac = 0;
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 49); ac++;
  XtSetValues( dict_op0, al, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 51); ac++;  
  XtSetValues( dict_op1, al, ac);
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 40); ac++;
  XtSetValues ( tog_source,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 60); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( tog_stream,al, ac );
  ac = 0;
  XtAddCallback (tog_source, XmNvalueChangedCallback, view_mode_changed,(XtPointer)1);
  XtAddCallback (tog_stream, XmNvalueChangedCallback, view_mode_changed,(XtPointer)2);
  children[ac++] = tog_stream;
  children[ac++] = tog_source;
  XtManageChildren(children, ac);
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 40); ac++;
  XtSetValues ( pushb0,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 60); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( pushb1,al, ac );
  ac = 0;
  XtAddCallback (pushb0, XmNactivateCallback, view_ev,(XtPointer)1);
  XtAddCallback (pushb1, XmNactivateCallback, view_ev,(XtPointer)2);
  children[ac++] = pushb0;
  children[ac++] = pushb1;
  XtManageChildren(children, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftOffset, 5); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNrightPosition, 40); ac++;
  XtSetValues ( pushb2,al, ac );
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
  XtSetArg(al[ac], XmNleftPosition, 60); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightOffset, 5); ac++;
  XtSetValues ( pushb3,al, ac );
  ac = 0;
  XtAddCallback (pushb2, XmNactivateCallback, start_spy_timer,(XtPointer)NULL);
  XtAddCallback (pushb3, XmNactivateCallback, quit,(XtPointer)NULL);
  children[ac++] = pushb2;
  children[ac++] = pushb3;
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = form_b_0;
  children[ac++] = form_b_1;
  children[ac++] = form_b_2;
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = b_left_rc;
  XtManageChildren(children, ac);
  ac = 0;
  XtAddCallback (hex_op0, XmNvalueChangedCallback, hex_or_dec,(XtPointer)0);
  XtAddCallback (hex_op1, XmNvalueChangedCallback, hex_or_dec,(XtPointer)1);
  children[ac++] = hex_op0;
  children[ac++] = hex_op1; 
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = sub_form4;
  XtManageChildren(children, ac);
	
  ac = 0;
  XtAddCallback (dict_op0, XmNvalueChangedCallback, dict_mode, (XtPointer)0);
  XtAddCallback (dict_op1, XmNvalueChangedCallback, dict_mode, (XtPointer)1);
  children[ac++] = dict_op0;
  children[ac++] = dict_op1;
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = sub_form5;
  XtManageChildren(children, ac);

  ac = 0;
  children[ac++] = label_form;
  children[ac++] = t_left_rc;
  children[ac++] = help_label;
  children[ac++] = scale;
  children[ac++] = frame;
  children[ac++] = frame_mode;
  children[ac++] = frame_mode1;
  XtManageChildren(children, ac);
  ac = 0;

  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetValues ( menu_bar,al, ac );
  ac = 0;
  
  XtSetArg(al[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
  XtSetArg(al[ac], XmNtopWidget, menu_bar); ac++;
  XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
  XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
  XtSetValues ( sw,al, ac );
  ac = 0;
  XtAddCallback (menu0_0, XmNactivateCallback, source_pick,(XtPointer)NULL);
  XtAddCallback (menu0_1, XmNactivateCallback, quit,(XtPointer)NULL);
  children[ac++] = menu0_0;
  children[ac++] = menu0_1;
  XtManageChildren(children, ac);
  ac = 0;
  XtAddCallback (menu1_0, XmNactivateCallback, dict_pick,(XtPointer)NULL);
  XtAddCallback (menu1_1, XmNactivateCallback, view_dict,(XtPointer)NULL);
  children[ac++] = menu1_0;
  children[ac++] = menu1_1;
  XtManageChildren(children, ac);
  ac = 0;
  XtAddCallback (menu2_0, XmNactivateCallback, tree_disp_mode,(XtPointer)0);
  XtAddCallback (menu2_1, XmNactivateCallback, tree_disp_mode,(XtPointer)1);
  XtAddCallback (menu2_2, XmNactivateCallback, tree_disp_mode,(XtPointer)2);
  XtAddCallback (menu2_3, XmNactivateCallback, tree_disp_mode,(XtPointer)3);
  XtAddCallback (menu2_4, XmNactivateCallback, tree_disp_mode,(XtPointer)4);
  children[ac++] = menu2_0;
  children[ac++] = menu2_1;
  children[ac++] = sep;
  children[ac++] = menu2_2;
  children[ac++] = menu2_3;
  children[ac++] = menu2_4;
  children[ac++] = sep1;
  XtManageChildren(children, ac);
  ac = 0;
  XtAddCallback (menu3_0, XmNvalueChangedCallback, change_event_mode,
		 (XtPointer)NULL);
  children[ac++] = menu3_0;
  XtManageChildren(children, ac);
  ac = 0;
  XtAddCallback (menu4_0, XmNactivateCallback, popup_about, (XtPointer)NULL);
  children[ac++] = menu4_0;
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = m_cas0;
  children[ac++] = m_cas1;
  children[ac++] = m_cas2;
  children[ac++] = m_cas3;
  children[ac++] = m_cas4;
  XtManageChildren(children, ac);
  
  ac = 0;
  XmScrolledWindowSetAreas(sw, widget50, widget51, tree );
  children[ac++] = menu_bar;
  children[ac++] = sw;
  XtManageChildren(children, ac);
  ac = 0;
  children[ac++] = left_form;
  children[ac++] = right_form;
  XtManageChildren(children, ac);
  ac = 0;
  XtManageChild ( top_form);
}




XtAppContext app_context;
Display *display;       /*  Display             */

int Xhandler(Widget w,XtPointer p, XEvent *e,Boolean *b)
{
  if (e->type == DestroyNotify) {
    printf("XCEFDMP:X window was destroyed\n");
    exit(0);
  }
  return 0;
}

int main (argc,argv)
unsigned int    argc;
char            **argv;
{
  Arg   al[10];
  int   ac = 0;
  Pixel fg, bg;
  XmString str;
/*************************************************
 * add init routine                              *
 ************************************************/
  EvInit();

  XtToolkitInitialize ();
  app_context = XtCreateApplicationContext ();
/*************************************************
 *    Add fallback_resources                     *
 ************************************************/
  XtAppSetFallbackResources(app_context,fallback_resources);

  display = XtOpenDisplay (app_context, NULL, argv[0], "Xcefdmp",
			   NULL, 0, &argc, argv);
  if (!display)
    {
      printf("%s: can't open display, exiting...\n", argv[0]);
      exit (0);
    }

  /* Register converters, just in case you are really unlucky !! */
  XmRegisterConverters();
  /* String to unit type doesn't get added !! */
  XtAddConverter ( XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0 );
  /* add new translations */
  XtAppAddActions (app_context, textw_actions, XtNumber (textw_actions));
  transTable = XtParseTranslationTable (textwTrans);
  /* create toplevel window */
  create_toplevel ( display, argv[0], argc, argv );

  {
    Window parent;
    Widget w;
    char cmd[100];
    parent = 0;
    
/*  Disable RunControl sucking up the xcefdmp window */
/*
    parent = CODAGetAppWindow(XtDisplay(toplevel),"xcefdmp_WINDOW");
    if (parent == 0) {
      int ix;
      char tmp[200];
      sprintf(tmp,"t:%d xcefdmp",getpid());
      coda_send(XtDisplay(toplevel),"RUNCONTROL",tmp);
      for (ix = 0;ix<5;ix++) {
	sleep(1);
	parent = CODAGetAppWindow(XtDisplay(toplevel),"xcefdmp_WINDOW");
	if (parent) break;
      }
    }
*/

    if (parent) {
      Arg   args[10];
      int   ac = 0;
      ac = 0;
      XtSetArg(args[ac], XmNx,3000); ac++;
      XtSetValues (toplevel, args, ac);
      XtRealizeWidget(toplevel);
      XWithdrawWindow(XtDisplay(toplevel), XtWindow(toplevel),0);

      printf("parent is 0x%08x\n",parent);
      sprintf(cmd,"r:0x%08x 0x%08x",XtWindow(toplevel),parent);      
      coda_Send(XtDisplay(toplevel),"RUNCONTROL",cmd);
      XtAddEventHandler(toplevel,StructureNotifyMask, False, Xhandler, NULL);
    } else {
      XtRealizeWidget(toplevel);
    }
  }

/*******************************************************
 *     add init event handler and init global variables*
 ******************************************************/
  XtSetArg(al[ac], XmNforeground, &fg); ac++;
  XtSetArg(al[ac], XmNbackground, &bg); ac++;
  XtGetValues(sw, al, ac);
  ac = 0;

  XtSetArg(al[ac], XmNbackground, fg); ac++;
  XtSetArg(al[ac], XmNforeground, bg); ac++;
  XtSetValues(tog_stream, al, ac);
  ac = 0;
  XtSetArg(al[ac], XmNset, FALSE); ac++;
  XtSetArg(al[ac], XmNforeground, fg); ac++;
  XtSetArg(al[ac], XmNbackground, bg); ac++;
  XtSetValues(tog_source, al, ac);
  ac = 0;
  
  XtSetArg(al[ac], XmNforeground, bg); ac++;
  XtSetArg(al[ac], XmNbackground, fg); ac++;
  XtSetValues(tog_stream, al, ac);
  ac = 0;
  view_mode = 1;
  spy_go_pause = 0;
  spy_rate = 1;
  
  str = XmStringCreateSimple("Update Rate (Sec)");
  XtSetArg(al[ac], XmNminimum, 1); ac++;
  XtSetArg(al[ac], XmNmaximum, 20); ac++;
  XtSetArg(al[ac], XmNvalue, 1); ac++;
  XtSetArg(al[ac], XmNtitleString, str); ac++;
  XtSetValues(scale, al, ac);
  ac = 0;
  XmStringFree(str);
  
  XtSetSensitive(scale,TRUE);
  XtSetSensitive(m_cas0,FALSE);
  XtSetSensitive(pushb0,FALSE);
  XtSetSensitive(pushb1,FALSE);
  
  str = XmStringCreateSimple("Go");
  XtSetArg(al[ac], XmNlabelString, str); ac++;
  XtSetValues(pushb2, al, ac);
  ac = 0;
  XmStringFree(str);
  XtSetSensitive(pushb2,TRUE);
  
  str = XmStringCreateSimple("Fifo Name:");
  XtSetArg(al[ac], XmNlabelString, str); ac++;
  XtSetValues(comm0, al, ac);
  ac = 0;
  XmStringFree(str);
  
  str = XmStringCreateSimple("Event Type:");
  XtSetArg(al[ac], XmNlabelString, str); ac++;
  XtSetValues(comm2, al, ac);
  ac = 0;
  XmStringFree(str);
  
  mode_change_reset();
  XmTextSetString(text_in0,"SPY");
  strcpy (SOURCE, "SPY");
  XmTextSetString(text_in2,"-1");
  strcpy (TAG, "-1");
  
  report_message("To start, enter an object name and a tag name (value)", 0);

  init_g();
  context_help();
/******************************************************/

  XtAppMainLoop (app_context);
}

