/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	xcefdmp hex to decimal conversion or vise versa
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_hexdec_conv.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/ToggleB.h>
#include <Xm/Text.h>

#include "xcef_layout.h"

/*******************************************************************
 *           static void conversion(buffer, op, buffer1, type)     *
 * Description:                                                    *
 *     Convert buffer to buffer1 according to option and type      *
 *     op = 0, decimal->hex, 1 hex->decimal                        *
 ******************************************************************/
static void conversion(buffer,op,buffer1,type) 
char *buffer,*buffer1;
int   op;
int   type;  /* data type for different type*/
{
  char   out[12], in[12];
  char   *p, *q;
  int    temp;
  int    j,k,in_temp;
  short  sh_temp;
  unsigned short us_temp;

  switch(type){
  case 0x1:
    if(op == 0){
      p = buffer;
      q = buffer1;
      while( *p != '\0'){
	sscanf(p,"%s",in);
	p = p + strlen(in);
	while( *p == ' ')
	  p++;
	sscanf(in,"%d",&temp);
	/* convert to hex */
	sprintf(out,"0x%-10.8x",temp);
	for(k=0;k<12;k++){
	  *q = out[k];
	  q++;
	}
      }
      *q = '\0';
    }
    else{
      p = buffer;
      q = buffer1;
      while (*p != '\0'){
	sscanf(p,"%s",in);
	p = p + strlen(in);
	while( *p == ' ')
	  p++;
	sscanf(in,"0x%x",&temp);
	/* convert to decimal number */
	sprintf(out,"%-12d",temp);
	for(k=0;k<12;k++){
	  *q = out[k];
	  q++;
	}
      }
      *q = '\0';
    }
    break;
  case 0x34:
  case 0x4:
    if(op == 0){
      p = buffer;
      q = buffer1;
      while( *p != '\0'){
	sscanf(p,"%s",in);
	p = p + strlen(in);
	while( *p == ' ')
	  p++;
	sscanf(in,"%d",&in_temp);
	sh_temp = (short)in_temp;
	/* convert to hex number */
	sprintf(out,"0x%-10.4x",sh_temp);
	for(k=0;k<12;k++){
	  *q = out[k];
	  q++;
	}
      }
      *q = '\0';
    }
    else{
      p = buffer;
      q = buffer1;
      while (*p != '\0'){
	sscanf(p,"%s",in);
	p = p + strlen(in);
	while( *p == ' ')
	  p++;
	sscanf(in,"0x%x",&in_temp);
	sh_temp = (short)in_temp;
	/* convert to decimal number */
	sprintf(out,"%-12d",sh_temp);
	for(k=0;k<12;k++){
	  *q = out[k];
	  q++;
	}
      }
      *q = '\0';
    }
    break;
  case 0x5:
  case 0x35:
    if(op == 0){
      p = buffer;
      q = buffer1;
      while( *p != '\0'){
	sscanf(p,"%s",in);
	p = p + strlen(in);
	while( *p == ' ')
	  p++;
	sscanf(in,"%d",&in_temp);
	us_temp = (unsigned short)in_temp;
	/* convert to hex number */
	sprintf(out,"0x%-10.4x",us_temp);
	for(k=0;k<12;k++){
	  *q = out[k];
	  q++;
	}
      }
      *q = '\0';
    }
    else{
      p = buffer;
      q = buffer1;
      while (*p != '\0'){
	sscanf(p,"%s",in);
	p = p + strlen(in);
	while( *p == ' ')
	  p++;
	sscanf(in,"0x%x",&in_temp);  /*we need integer here*/
	us_temp = (unsigned short)in_temp;
	/* convert to decimal */
	sprintf(out,"%-12d",us_temp);
	for(k=0;k<12;k++){
	  *q = out[k];
	  q++;
	}
      }
      *q = '\0';
    }
    break;
  default:
    strcpy(buffer1,buffer);
    break;
  }
}

/**********************************************************************
 *               void hex_or_dec( )                                   *
 * Description:                                                       *
 *     Callback for a hex and decimal buttons                         *
 *********************************************************************/
void hex_or_dec(w,item_no,cbs)
Widget w;
int    item_no;
XmToggleButtonCallbackStruct *cbs;
{
  int    i,j,m, ac = 0;
  char   *buffer,*buffer1,*p,*q;
  int    old_hex;
  FORMAT *format[100];
  int    format_num;
  int    format_len;
  Arg    args[5];

  old_hex = hex_or_decimal;
  if(item_no == 0){ /* first toggle button */
    if(cbs->set){
      hex_or_decimal = 0;
      XtSetArg(args[ac], XmNset, TRUE); ac++;
      XtSetValues(hex_op0, args, ac);
      ac = 0;
	
      XtSetArg(args[ac], XmNset, FALSE); ac++;
      XtSetValues(hex_op1, args, ac);
      ac = 0;
    }
    else{
      hex_or_decimal = 1;
      XtSetArg(args[ac], XmNset, FALSE); ac++;
      XtSetValues(hex_op0, args, ac);
      ac = 0;

      XtSetArg(args[ac], XmNset, TRUE); ac++;
      XtSetValues(hex_op1, args, ac); 
      ac = 0;
    }
  }
  else{  /* hex button */
    if(cbs->set){
      hex_or_decimal = 1;
      XtSetArg(args[ac], XmNset, FALSE); ac++;
      XtSetValues(hex_op0, args, ac);
      ac = 0;
      
      XtSetArg(args[ac], XmNset, TRUE); ac++;
      XtSetValues(hex_op1, args, ac);
      ac = 0;
    }
    else{
      hex_or_decimal = 0;
      XtSetArg(args[ac], XmNset, TRUE); ac++;
      XtSetValues(hex_op0, args, ac);
      ac = 0;
      
      XtSetArg(args[ac], XmNset, FALSE); ac++;
      XtSetValues(hex_op1, args, ac);
      ac = 0;
    }
  }
  
  if(hex_or_decimal == old_hex)  /*nothing changed*/
    return;
   
  for(i=0;i<MAX_LEAF_NODE;i++){ /* looking for which shell is up */
    if(d_shell[i].dialog_shell != NULL 
       && XtIsRealized(d_shell[i].dialog_shell) == True
       && d_shell[i].count == 1                       /* shell indeed is up */
       && d_shell[i].map_or_not == 1){
      switch(d_shell[i].type){
      case 0x1:
      case 0x4:
      case 0x5:
      case 0x34:
      case 0x35:
	buffer = XmTextGetString(d_shell[i].text_w);
	p = buffer;
	if((strstr(buffer,"0x")) != NULL 
	   || (strstr(buffer,"0X")) != NULL){ /*old hex dump*/
	  if(hex_or_decimal == 1)       /* hex dump */
	    ;
	  else{                          /* change to decimal */
	    buffer1 = (char *)malloc(strlen(buffer)+1);
	    conversion(buffer,1,buffer1,d_shell[i].type);
	    XtFree(buffer);
	    XmTextSetString(d_shell[i].text_w, buffer1);
	    XtFree(buffer1);
	  }
	}
	else{     /* old decimal */
	  if(hex_or_decimal == 0)       /* decimal dump */
	    ;
	  else{                         /* change to hex*/
	    buffer1 = (char *)malloc(strlen(buffer)+1);
	    conversion(buffer,0,buffer1,d_shell[i].type);
	    XtFree(buffer);
	    XmTextSetString(d_shell[i].text_w,buffer1);
	    XtFree(buffer1);
	  }
	}
	break;
      case 0xF:
	for(j=0;j<100;j++)
	  format[j] = (FORMAT *)malloc(1*sizeof(FORMAT));
	for(j=0;j<MAX_LEAF_NODE;j++){  /* looking for evTreeNode assocaited*/
	  if(rm[j].used == 1 && strcmp(d_shell[i].name,rm[j].name) == 0)
	    break;
	}
	parse_format(ev,rm[j].p,format,&format_num,&format_len);
		
	m = rm[j].p->start;
		
	if(rm[j].p->parent_type == 0x10)
	  m = m + 4;
	else
	  m = m + 2;

	m = m + format_len;
	
	buffer1 = (char *)malloc(13*(rm[j].p->length));
	sprint_item(ev,rm[j].p,m,format,format_num,buffer1);
	XmTextSetString(d_shell[i].text_w,buffer1);
	XtFree (buffer1);
	break;
      default:
	break;
      }
    }
  }
  return;
}
