/*-----------------------------------------------------------------------------
 * COPYRIGHT (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	callbacks routines for xcef_layout.c
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: xcef_callbacks.c,v $
 *   Revision 1.16  1999/11/23 14:30:40  timmer
 *   new et api
 *
 *   Revision 1.15  1999/10/25 17:24:36  abbottd
 *   Red Hat Linux 6.0 fixes
 *
 *   Revision 1.14  1999/10/21 13:23:41  abbottd
 *   fix bug in switch from ET spy mode to file mode- check of ET initialized
 *
 *   Revision 1.13  1999/08/27 14:58:58  timmer
 *   new et_open api
 *
 *   Revision 1.12  1999/07/19 19:20:55  timmer
 *   update ET calls
 *
 *   Revision 1.11  1999/02/08 15:27:23  timmer
 *   et api change
 *
 *   Revision 1.10  1999/01/22 15:53:43  timmer
 *   et upgrade
 *
 *   Revision 1.9  1998/11/06 15:11:03  timmer
 *   fix wchar_t stuff
 *
 *   Revision 1.8  1998/10/09 18:41:54  timmer
 *   update ET parts
 *
 *   Revision 1.6  1998/08/19 19:08:57  timmer
 *   added ET capability
 *
 *   Revision 1.5  1997/11/25 15:33:09  rwm
 *   Zapped compiler warnings.
 *
 *   Revision 1.4  1997/06/11 17:30:06  heyes
 *   fix for configure
 *
 *   Revision 1.3  1997/06/11 01:43:47  heyes
 *   spy on DD systemcd /usr/local/coda/linux/source/event/xcefdmp!
 *
 *   Revision 1.2  1997/03/05 16:08:01  chen
 *   increase buffer size
 *
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *	  Revision 1.4  1995/04/05  19:27:41  chen
 *	  fix a bug on bad event
 *
 *	  Revision 1.3  1995/03/16  19:34:21  chen
 *	  replace old dictionary parser with new one
 *
 *	  Revision 1.2  1995/02/28  21:07:42  chen
 *	  change behaviour of the file selection dialog boxes
 *
 *	  Revision 1.1  1994/12/08  19:57:31  chen
 *	  Initial revision 
 *
 *
 */
 
#include <stdio.h>

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef WITH_ET
 #include <et.h>
 /* defined in xcef_spy_event.c */
 extern  char		*et_name;
 extern  int		et_init;
 extern  et_sys_id 	et_sys;
 extern  et_att_id	et_my_attach;
 extern  et_stat_id	et_stat;
#endif

/*--------------------------------------*/
#include <TreeCODA.h>
#include <Xm/Xm.h>
#include <Xm/PanedW.h>
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>
#include <Xm/DialogS.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/CascadeBG.h>
#include <Xm/CascadeB.h>
#include <Xm/FileSB.h>
#include <Xm/SeparatoG.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/Scale.h>
/*---------------------------------------*/
#include "xcef.h"
#include "xcef_layout.h"
#include "evfile_msg.h"
#include "coda_color.h"

D_TYPE d_type[]= {{0x0,"unknown"},
                  {0x1,"integer"},
                  {0x2,"IEEE Floating"},
                  {0x3,"ASCII string"},
                  {0x4,"short int"},
                  {0x5,"unsigned short"},
                  {0x6,"8 bit singed int"},
                  {0x7,"8 bit unsigned int"},
                  {0x8,"double IEEE folating"},
                  {0x9,"VAX floating"},
                  {0xA,"VAX double floating"},
                  {0xF,"Repeating Structure"},
                  {0x10,"bank"},
                  {0x20,"segment"},
                  {0x30,"packet unknown"},
                  {0x33,"packet ASCII string"},
                  {0x34,"packet short int"},
                  {0x35,"packet short unsigned int"},
                  {0x36,"packet 8 bit signed int"},
		  {0x37,"packet 8 bit unsigned int"}
		  };

static  Cursor busy_cursor;   /* busy searching cursor    */
static  int    fseq_d = 0;    /* sequential seach file open descriptor */
static  int    last_seq_evn = 0;/* previous sequential searched event number*/

/* init some gloable variables*/
Pixel          fold_bg,normal_bg; /* will show folded buttons */
char           ev[200000];        /* Event holder 200000 bytes, 50000 words*/
                                  /* evread must have buflen = 500000      */
int            evn, n_of_ev;
XtIntervalId   spy_id;
DIALOG         d_shell[MAX_LEAF_NODE];
RepeatMem      rm[MAX_LEAF_NODE];

/****************************************************************************
 *               void init_g ()                                             *
 * Description:                                                             *
 *    Initialize some global variables                                      *
 ***************************************************************************/
void init_g()
{
  int i, ac = 0;
  Arg args[5];
  Pixel unused;
    
  if(is_string_empty(DIRC))
    XmTextSetString(text_in1,"");

  for(i=0;i<MAX_LEAF_NODE;i++){
    d_shell[i].count=0;
    d_shell[i].type = 0x0;
    d_shell[i].map_or_not = 0;
    d_shell[i].name[0] = '\0';
    d_shell[i].mask_value = 0xffffffff;
    d_shell[i].rshift_bit = 0;
    d_shell[i].mask_mode = 0;
    d_shell[i].buffer = (char *)NULL;
    d_shell[i].mask_shell = (Widget)NULL;
    rm[i].used = 0;
    strcpy(rm[i].name,"-JIE");
    rm[i].p = (evTreeNode *)malloc(1*sizeof(evTreeNode));
  }
/* get scrolled window background, then it will be used to get 
   darker color for folded button background                 */
  XtSetArg(args[ac], XmNbackground, &normal_bg); ac++;
  XtGetValues(sw, args, ac);
  ac = 0;
  XcodaGetShadowColor(sw,normal_bg,&fold_bg,&unused);

  evn = n_of_ev = 0;
  busy_cursor = XCreateFontCursor(XtDisplay(toplevel),XC_watch);
  /* load default dictionary to the application */
  load_dict (text_in1, (XtPointer)NULL, NULL);

  /* disable spy stream for now */
  /*XtSetSensitive (tog_stream, FALSE);
  XtSetSensitive (tog_source, FALSE);*/
}

/****************************************************************************
 *           static void set_filesel_bg (w, bg)                             *
 * Description:                                                             *
 *     Set File Selection Dialog Box all widgets to background bg           *
 ***************************************************************************/
static void set_filesel_bg (w, bg)
Widget w;
Pixel  bg;
{
  Arg arg[10];
  int ac = 0;
  Widget vscb, hscb;
  Pixel fg_ret, top_shadow, bot_shadow, sel_color; 
  Screen *scr = XtScreen (w);

  XmGetColors (scr, DefaultColormapOfScreen (scr), bg,
	      &fg_ret, &top_shadow, &bot_shadow, &sel_color);

  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (w, arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (XmFileSelectionBoxGetChild(w, XmDIALOG_DIR_LIST), arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (XtParent(XmFileSelectionBoxGetChild(w, XmDIALOG_DIR_LIST)), arg, ac);
  ac = 0;
  
  /* change scrollbar color for dir list */
  XtSetArg (arg[ac], XmNhorizontalScrollBar, &hscb); ac++;
  XtSetArg (arg[ac], XmNverticalScrollBar, &vscb); ac++;
  XtGetValues (XtParent(XmFileSelectionBoxGetChild(w, XmDIALOG_DIR_LIST)), arg, ac);
  ac = 0;
  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (hscb, arg, ac); ac++;
  ac = 0;
  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (vscb, arg, ac); ac++;
  ac = 0;
  
  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (XmFileSelectionBoxGetChild(w, XmDIALOG_FILTER_TEXT), arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (XmFileSelectionBoxGetChild(w, XmDIALOG_LIST), arg, ac);
  ac = 0;

  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (XtParent(XmFileSelectionBoxGetChild(w, XmDIALOG_LIST)), arg, ac);
  ac = 0;
  /* change scrollbar color for file list */
  XtSetArg (arg[ac], XmNhorizontalScrollBar, &hscb); ac++;
  XtSetArg (arg[ac], XmNverticalScrollBar, &vscb); ac++;
  XtGetValues (XtParent(XmFileSelectionBoxGetChild(w, XmDIALOG_LIST)), arg, ac);
  ac = 0;
  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (hscb, arg, ac); ac++;
  ac = 0;
  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (vscb, arg, ac); ac++;
  ac = 0;

  XtSetArg (arg[ac], XmNbackground, bg); ac++;
  XtSetArg (arg[ac], XmNtopShadowColor, top_shadow); ac++;
  XtSetArg (arg[ac], XmNbottomShadowColor, bot_shadow); ac++;
  XtSetArg (arg[ac], XmNselectColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNarmColor, sel_color); ac++;
  XtSetArg (arg[ac], XmNborderColor, fg_ret); ac++;
  XtSetValues (XmFileSelectionBoxGetChild(w, XmDIALOG_TEXT), arg, ac);
  ac = 0;

}


/****************************************************************************
 *          static void popdown_datasrc_sel ( )                             *
 * Description:                                                             *
 *      Callback for cancel button of the data source selection             *
 *      Dialog box                                                          *
 ***************************************************************************/
static Widget fileSelDialog = 0;

static popdown_datasrc_sel (w, client_data, cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  XtPopdown (XtParent (fileSelDialog));
}

/****************************************************************************
 *           void source_pick ( )                                           *
 * Description:                                                             *
 *     init a file_selection box which will pick up a filename for          *
 *     data source                                                          *
 *     output of filename will also go to text_in0 text Widget.             *
 ***************************************************************************/
void source_pick(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  Widget parent=XtParent(w);
  
  if (!fileSelDialog){
    fileSelDialog =(Widget)XmCreateFileSelectionDialog(parent,"Files", NULL, 0);
    XtSetSensitive(XmFileSelectionBoxGetChild(fileSelDialog
					      ,XmDIALOG_HELP_BUTTON),FALSE);
    XtAddCallback(fileSelDialog,XmNokCallback,new_source,(XtPointer)NULL);
    XtAddCallback(fileSelDialog,XmNcancelCallback,popdown_datasrc_sel,(XtPointer)NULL);
  }
   
  XtManageChild(fileSelDialog);
  XtPopup(XtParent(fileSelDialog),XtGrabNone);
}

/******************************************************************************
 *               void new_source()                                            *
 * Description:                                                               *
 *      Callback routine for either text input window or file selection       *
 *      dialog box                                                            *
 *****************************************************************************/
void new_source(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmFileSelectionBoxCallbackStruct *cbs;
{
  Widget          text_w;
  char            *dir,*newfile, *fname;
  char            message[80];
  XmString        str;
  Widget          parent=XtParent(w);
  int             fs_or_ts;     /* 0 means text select 1 means file slection box */
  Position        cur_p;
  Arg             args[5];
  int             ac = 0;

  fs_or_ts = 0;

  if(XtIsSubclass(w,xmTextWidgetClass)){ /* file selectred from text widget */
    strcpy(SOURCE, XmTextGetString(w));
    text_w = w;
  }
  else{          /*file selected from file-selection box */
    text_w = text_in0;
    fs_or_ts = 1;
    if((XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&fname)) == FALSE){
      pop_error_message("Something is wrong with system!",parent);
      return;
    }
    else{
      strcpy (SOURCE, fname);
      XtFree (fname);
      if(SOURCE[0] !='/'){
	if(XmStringGetLtoR(cbs->dir,XmSTRING_DEFAULT_CHARSET,&dir)){
	  newfile= XtMalloc(strlen(dir)+1+strlen(SOURCE)+1);
	  sprintf (newfile,"%s%s",dir,SOURCE);
	  XtFree (dir);
	  strcpy (SOURCE, newfile);
	  XtFree (newfile);
	}
      }
    }
  }
  if(is_string_empty(SOURCE)){  /*nothing typed */
    if(view_mode == 0)
      report_message("Need data source name!", 0);
    else
      report_message("Need object name!", 0);
    clean_tree();
    return;
  }
  if(view_mode == 0){
    switch(is_regular(SOURCE)){
    case 1:
      if(fs_or_ts == 1){
	XtPopdown (parent);
	XmTextSetString(text_w,SOURCE);              
	cur_p=strlen(SOURCE);
	XtSetArg(args[ac], XmNcursorPosition, cur_p); ac++;
	XtSetValues(text_w, args, ac);
	ac = 0;
	XmTextShowPosition(text_w,cur_p);
      }
      else{
	sprintf(message,"Data source name is %s",SOURCE);             
	report_message(message, 0);
      }
      open_source();
      break;
    case 0:
      if(fs_or_ts == 1){
	str=XmStringCreateSimple(SOURCE);
	XmFileSelectionDoSearch(w,str);
	XmStringFree(str);
      }
      else{
	pop_error_message("Cannot use directory name!",text_w);
	XmTextSetString(text_w,"");
	empty_string (SOURCE);
      }
      break;
    case -1:
      if(fs_or_ts ==1){
	pop_error_message("Unreadable File, Try others!",parent);
	empty_string (SOURCE);
      }
      else{
	pop_error_message("Unreadable File, Try others!",parent);              
	XmTextSetString(text_w,"");              
	empty_string (SOURCE);
      }
      break;
    }  
  }
  else{  /* view a event stream */
    if(is_string_empty(TAG))
      ;
    else
      ;
  }
}

/******************************************************************************
 *         static void popdown_dict_sel ()                                    *
 * Description:                                                               *
 *       Callback for dictionary selection dialog box cancel button           *
 *****************************************************************************/
static Widget dictSelDialog = 0;

static void popdown_dict_sel (w, client_data, cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  XtPopdown (XtParent (dictSelDialog));
}

/******************************************************************************
 *         static void dict_pick()                                            *   
 * Description:                                                               *
 *        enable user to pick up a dictionary file                            *
 *****************************************************************************/
void dict_pick(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  Widget parent=XtParent(w);

  if (!dictSelDialog){
    dictSelDialog = (Widget)XmCreateFileSelectionDialog(parent,"Files", NULL, 0);
    XtSetSensitive((Widget)XmFileSelectionBoxGetChild(dictSelDialog,
						      XmDIALOG_HELP_BUTTON),
		   FALSE);
    XtAddCallback(dictSelDialog,XmNokCallback,new_dict,(XtPointer)NULL);
    XtAddCallback(dictSelDialog,XmNcancelCallback,popdown_dict_sel,NULL);
  }
  XtManageChild(dictSelDialog);
  XtPopup(XtParent(dictSelDialog),XtGrabNone);
}

/******************************************************************************
 *                 void new_dict ( )                                          *
 * Description:                                                               *
 *     Callback function for either a text input window and file slection     *
 *     Popup Dialog                                                           *
 *****************************************************************************/
void new_dict (w,client_data,cbs)
Widget w;
XtPointer client_data;
XmFileSelectionBoxCallbackStruct *cbs;
{
  Widget   text_w;
  char     *dir,*newfile, *filename;
  char     message[80],string[80];
  XmString str;
  Widget   parent=XtParent(w);
  int      fs_or_ts;     /* 0 means text select 1 means file slection box */
  Position cur_p;
  int      status, ac = 0;
  Arg      args[5];

  fs_or_ts = 0;

  if(XtIsSubclass(w,xmTextWidgetClass)){ /* file selectred from text widget */
    strcpy(DIRC, XmTextGetString(w));
    text_w = w;
  }
  else{     /*file selected from file-selection box */
    text_w = text_in1;
    fs_or_ts = 1;
    if((XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&filename)) == FALSE){
      pop_error_message("Something is wrong with system!",parent);
      return;
    }
    else{
      strcpy(DIRC, filename);
      free (filename);
      if(DIRC[0] !='/'){
	if(XmStringGetLtoR(cbs->dir,XmSTRING_DEFAULT_CHARSET,&dir)){
	  newfile= XtMalloc(strlen(dir)+1+strlen(DIRC)+1);
	  sprintf(newfile,"%s%s",dir,DIRC);
	  XtFree(dir);
	  strcpy(DIRC, newfile);
	  XtFree (newfile);
	}
      }
    }
  }

  switch(is_regular(DIRC)){
  case 1:
    if(fs_or_ts == 1){
      XtPopdown (parent);
      if((status = open_dict(sw,string)) != 0){
	XmTextSetString(text_w,"");
	empty_string (DIRC);
      }
      else{
	XmTextSetString(text_w,DIRC);              
	cur_p=strlen(DIRC);
	XtSetArg(args[ac], XmNcursorPosition, cur_p); ac++;
	XtSetValues(text_w, args, ac);
	ac = 0;
	XmTextShowPosition(text_w,cur_p);
      }
      if (view_mode == 0){
	if(!is_string_empty (SOURCE))       /* if no data source do nothing*/
	  view_ev(NULL,0,NULL);
      }
    }
    else{
      if((status = open_dict(sw,string)) != 0){
	XmTextSetString(text_w,"");
	empty_string (DIRC);
      }
      else{
	sprintf(message,"Dictionary is %s",DIRC);
	report_message(message, 0);
      }
      if (view_mode == 0){
	if(!is_string_empty (SOURCE))       /* if no data source do nothing*/
	  view_ev(NULL,0,NULL);
      }
    }
    break;
  case 0:
    if(fs_or_ts == 1){
      str=XmStringCreateSimple(DIRC);
      XmFileSelectionDoSearch(w,str);
      XmStringFree(str);
    }
    else{
      pop_error_message("Cannot use directory name!",text_w);
      XmTextSetString(text_w,"");
      empty_string(DIRC);
    }
    break;
  case -1:
    if(fs_or_ts ==1){
      pop_error_message("Unreadable File, Try others!",parent);
      empty_string (DIRC);
    }
    else{
      pop_error_message("Unreadable File, Try others!",parent);              
      XmTextSetString(text_w,"");              
      empty_string (DIRC);
    }
    break;
  }          
}

/******************************************************************************
 *           int open_dict()                                                  *
 * Description:                                                               *
 *     Try to open a dictionary                                               *
 *****************************************************************************/
extern int parseDictionary ();

int  open_dict(base,string)
char *string;
Widget base;
{
  int   parseError = 0;
  int   errLineNum;
  char  *errLine;
  char  message[256];

  if(is_regular(DIRC) < 1)  /* taking care there is no file */
    return 1;               /* pointed by env variables */

  parseError = parseDictionary (DIRC, &errLineNum, errLine);
  if (parseError){
    sprintf(message,"Syntax error at line %d of the dictionary\n", errLineNum);
    pop_error_message (message, base);
  }
  return parseError;
}

   
/******************************************************************************
 *               void load_dict ()                                            *
 * Description:                                                               *
 *     Try to load default dictionary                                         *
 *****************************************************************************/
void load_dict(w,client_data,event)
Widget w;
XtPointer client_data;
XEvent  *event;
{
  int status;
  char *string,message[80];
  char *p,temp[200];
  Widget text_w = text_in1;

  if((p = getenv("EVTAGS")) != NULL){
    strcpy(DIRC, p);
    if((status =open_dict(text_w,string)) != 0){
      empty_string(DIRC);
      XmTextSetString(text_w,"");
      sprintf(message,"Unable to load environment variable $EVTAGS.");
      report_message(message, 1);
    }
    else{
      XmTextSetString(text_w,DIRC);
      report_message("Load environment variable $EVTAGS as a dictionary.", 0);
    }
    return;
  }
  if((p = getenv("CODA")) != NULL){
    sprintf(temp,"%s/common/lib/evTags",p);
    if(is_regular(temp) == 1){
      strcpy(DIRC, temp);
      if((status =open_dict(text_w,string)) != 0){
	empty_string (DIRC);
	XmTextSetString(text_w,"");
	sprintf(message,"Unable to load file from $CODA/common/lib/evTags.");
	report_message(message, 1);
      }
      else{
	XmTextSetString(text_w,DIRC);
	report_message("Load file $CODA/common/lib/evTags as a dictionary.", 
		       0);
      }
    }
    else{
      empty_string (DIRC);
      sprintf(message,"Cannot find $CODA/common/lib/evTags");
      report_message(message, 1);
    }
    return;
  }
  if((is_regular("evTags")) == 1)
    {
      strcpy(DIRC, "evTags");
      if((status =open_dict(text_w,string)) != 0){
	empty_string (DIRC);
	XmTextSetString(text_w,"");
	sprintf(message,"Unable to load file evTags.");
	report_message(message, 1);
      }
      else{
	XmTextSetString(text_w,DIRC);
	report_message("Load file evTags as dictionary.", 0);
      }
      return;
    }
  sprintf(message,"Cannot find any default dictionaries.");
  report_message(message, 1);
  return;
}
  
                
/****************************************************************************
 *                  void view_dict ()                                       *
 * Description:                                                             *
 *     allow user to view the content of dictionary                         *
 *     in a tree_structure                                                  *
 ***************************************************************************/
void view_dict(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  Widget base =XtParent(XtParent(w));  
  int    i,j,k;

  if(is_string_empty(DIRC)){
    report_message("Open a dictionary first", 0);
    return;
  }
    
  if(num_of_tree == 0){
    report_message ("No dictionary available yet", 0);
    return;
  }
  popup_dict_shell (base);
  XtSetSensitive(w,False);      /* only allow one view at a time */
}

/*****************************************************************************
 *           void get_tags ()                                                *
 * Description:                                                              *
 *      get tags from the tree structure of the dictionary                   *
 ****************************************************************************/
void get_tags(w,tnode,cbs)
Widget w;
DXNODE *tnode;
XmAnyCallbackStruct *cbs;
{
  TREE_NODE *q;

  q = tnode->p;
  while(q != NULL) 
    {
      printf("%s  ",q->name);
      q=q->parent;
    }
  printf("\n");

}

/****************************************************************************
 *            void input_tag ()                                             *
 * Description:                                                             *
 *     Input name tag from a text field                                     *
 ***************************************************************************/
void input_tag(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  Arg    wargs[2];
  static Position cur_p;

  strcpy (TAG, XmTextGetString(w));
  if(is_string_empty (TAG)){
    report_message("Need tag name", 0);
    empty_string (TAG);
    if(view_mode == 0){
      if(!is_string_empty (SOURCE))
	view_ev(NULL,(XtPointer)0,NULL);
      return;
    }
    else
      return;	   
  }
  if(view_mode == 0){
    if(!is_string_empty (SOURCE))
      view_ev(NULL,(XtPointer)0,NULL);
  }
}

/****************************************************************************
 *             void open_source ()                                          *
 * Description:                                                             *
 *      open data source according to SOURCE and TAG                        *
 *      for current event                                                   *
 ***************************************************************************/
void open_source()
{
  int   i,j,num_of_event,status, fd, bd;
  char  message[80];
  Arg   wargs[10];

  if(fseq_d){  /* close old file descriptor if neccessary */
    evClose(fseq_d);
    fseq_d = 0;
    last_seq_evn = 0;
  }
  if((status = evOpen(SOURCE,"r",&fd)) != S_SUCCESS){
    if(status == 0x80730003){
      sprintf(message,"Wrong data format");
    }
    else
      sprintf(message,"Cannot open %s named datasource",SOURCE);
    empty_string (SOURCE);
    XmTextSetString(text_in0," ");
    pop_error_message(message,sw);
    return;
  }
   
  if(event_mode != 0){
    j=0;
    XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel),busy_cursor);
    XmUpdateDisplay(toplevel);
    while((status = evRead(fd,ev,50000)) == S_SUCCESS && j < EVN_INC)
      j++;
    XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
    XmUpdateDisplay(toplevel);
    num_of_event= j;
    n_of_ev = num_of_event;
    if(num_of_event >= EVN_INC)
      sprintf(message,"Number of events is at least %d",EVN_INC);
    else
      sprintf(message,"Number of events: %d",num_of_event);
    report_message(message, 0);
    evClose(fd);
    /* reopen the file stream */
    evOpen(SOURCE, "r", &fseq_d);
    evRead(fseq_d,ev,50000);
   }
   else{
    XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel),busy_cursor);
    XmUpdateDisplay(toplevel);
    num_of_event = evOpenSearch(fd, &bd);
    evCloseSearch(bd);
    evClose(fd);
    if (num_of_event <=0){
      pop_error_message("Total number of physics events is less than one!",sw);
      empty_string (SOURCE);
      XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
      XmUpdateDisplay(toplevel);
      return;
    }
    n_of_ev = num_of_event;
    sprintf(message,"Number of events: %d",num_of_event);
    report_message(message, 0);
    XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
    XmUpdateDisplay(toplevel);
  }

  start =0;
  ending = num_of_event -1;
  
  evn = start;
  sprintf(message,"%d",evn+1);
  XmTextSetString(text_in3,message);
  
  if(n_of_ev == 1){
    XtSetArg(wargs[0],XmNshowValue,False);
    XtSetValues(scale,wargs,1);
    XtSetSensitive(scale,False);
  }
  else{
    if(event_mode == 0){ /* binary search */
      XtSetSensitive(scale,True);
      XtSetArg(wargs[0],XmNmaximum,ending + 1);
      XtSetArg(wargs[1],XmNminimum,start + 1);
      XtSetArg(wargs[2],XmNscaleMultiple,num_of_event/100);
      XtSetArg(wargs[3],XmNshowValue,True);
      XtSetArg(wargs[4],XmNvalue, 1);
      XtSetValues(scale,wargs,5);
    }
  }

/* allow all dialog_shell can be used , ie. erase old memory */
  for(i=0; i<MAX_LEAF_NODE; i++){
    rm[i].used = 0;
    strcpy(rm[i].name, "-JIE");
    if(d_shell[i].count == 1 && d_shell[i].dialog_shell != NULL
       && (XtIsRealized(d_shell[i].dialog_shell)) == True){
      d_shell[i].count = 0;
      d_shell[i].map_or_not = 0;
      d_shell[i].mask_value = 0xffffffff;
      d_shell[i].rshift_bit = 0;
      d_shell[i].mask_mode = 0;
      if (d_shell[i].buffer != NULL){
	free(d_shell[i].buffer);
      }
      d_shell[i].buffer = (char *)NULL;
      XtDestroyWidget(d_shell[i].dialog_shell);
      d_shell[i].mask_shell = (Widget)NULL;
      d_shell[i].dialog_shell = (Widget)NULL;
    }
    else{
      d_shell[i].count = 0;
      d_shell[i].map_or_not = 0;
      d_shell[i].mask_value = 0xffffffff;
      d_shell[i].rshift_bit = 0;
      d_shell[i].mask_mode = 0;
      if(d_shell[i].buffer != NULL){
	free(d_shell[i].buffer);
      }
      d_shell[i].buffer = (char *)NULL;
      d_shell[i].dialog_shell = (Widget)NULL;
    }
  }
  view_ev(NULL,0,NULL);
}


/*****************************************************************************
 *                     void view_ev()                                        *
 * Description:                                                              *
 *     view current next and previous event tree structure                   *
 ****************************************************************************/
void view_ev(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
  evTreeNode *root;
  int   curr=(int)client_data;
  int   ev_size,t_length, fd, bd, status;
  char  message[80],temp[4];
  short t_type;
  XNODE node[MAX_NODE];
  int   *i,j, ac = 0;
  int   event_num_inc,event_num_dec;
  Arg   args[5];

  if(is_string_empty (SOURCE)){
    report_message("Please open a data source", 0);
    return;
  }
  
  if(curr == 0)
    evn = evn;
  else if(curr == 1){
    evn = evn + 1;
    if(event_mode == 0){ /* binary search */
      if(evn <= n_of_ev -1){
	XtSetArg(args[ac], XmNvalue,    evn + 1); ac++;
	XtSetValues(scale, args, ac);
	ac = 0;
      }
      if(evn > n_of_ev-1){
	sprintf(message,"You are looking at the last event");
	report_message(message, 1);
	evn = evn - 1;
	return;
      }
      XmScaleSetValue(scale,evn+1);
    }
    sprintf(message,"%d",evn+1);
    XmTextSetString(text_in3,message);     
  }
  else {
    evn = evn - 1;
    if(event_mode == 0){ /* binary search */
      if(evn > start){
	XtSetArg(args[ac], XmNvalue,    evn + 1); ac++;
	XtSetValues(scale, args, ac);
	ac = 0;
      }
      if(evn < start){
	sprintf(message,"You are looking at the first event");
	report_message(message, 1);
	evn = evn + 1;
	return;
      }
      XmScaleSetValue(scale,evn+1);
    }
    else{  /* sequential search */
      if(evn < start){
	sprintf(message,"You are looking at the first event");
	report_message(message, 1);
	evn = evn + 1;
	return;
      }
    }
    sprintf(message,"%d",evn+1);
    XmTextSetString(text_in3,message);     
  }
  
  if(event_mode != 0){
    XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel),busy_cursor);
    XmUpdateDisplay(toplevel);
    if(!fseq_d)
      evOpen(SOURCE,"r",&fseq_d);
    if(evn > last_seq_evn){      /* view next     */
      for(j = 0;j < evn - last_seq_evn;j++){
	if((evRead(fseq_d,ev,50000)) != S_SUCCESS){
	  pop_error_message("You have reached last event of this file",sw);
	  evn = last_seq_evn + j;
	  sprintf(message,"%d",evn+1);
	  XmTextSetString(text_in3,message);     
	  break;
	}
      }
    }
    else if(evn < last_seq_evn){ /* view previous */
      evClose(fseq_d);
      evOpen(SOURCE,"r",&fseq_d);
      for(j = start; j < evn + 1; j++)
	evRead(fseq_d, ev, 50000);
    }
    bufcpy(temp,ev);
    ev_size= *(int *)(temp)+1;
    t_type=0xC;
    t_length=ev_size;
    root=EvTreeConstruct(ev,t_type,t_length);
    XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
    XmUpdateDisplay(toplevel);
    /* update last event number */
    last_seq_evn = evn;
  }
  else{
    XDefineCursor(XtDisplay(toplevel), XtWindow(toplevel),busy_cursor);
    XmUpdateDisplay(toplevel);
    evOpen(SOURCE, "r", &fd);
    evOpenSearch(fd, &bd);
    bzero(ev, sizeof(ev));
    status = evSearch(fd, bd, evn+1, ev, 10000, &t_length);
    evCloseSearch(bd);
    evClose(fd);
    t_type=0xC;
    if(status == 0){
      t_type=0xC;
      root=EvTreeConstruct(ev,t_type,t_length);
    }
    else{
      pop_error_message("Cannot find this event", sw);
      return;
    }
    XUndefineCursor(XtDisplay(toplevel), XtWindow(toplevel));
    XmUpdateDisplay(toplevel);
  }
  if (!root){
    pop_error_message ("Bad event. Check your event please !\n", toplevel);
    return;
  }
  next_prev_tree (root);
}

/***************************************************************************
 *              void new_evn ()                                            *
 * Description:                                                            *
 *       allow user to input from text widegt                              *
 *       and select from slide bar                                         *
 **************************************************************************/
void new_evn(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmScaleCallbackStruct *cbs;
{
  char *te,message[80];
  int  ac = 0;
  Arg  args[5];

  if(view_mode == 0){
    if(is_string_empty (SOURCE)){
      report_message("Please open a data source", 0);
      return;
    }
    
    if(XtIsSubclass(w,xmTextWidgetClass)){
      te = XmTextGetString(w);
      if(!te || !*te){
	report_message("Need event number", 0);
	return;
      }
      evn = atoi(te);
      if(evn <= 0){
	pop_error_message("Event number must be greater than 0",w);
	XmTextSetString(w,"1");
	evn = 0;
	XmScaleSetValue(scale,evn+1);
	view_ev(NULL,(XtPointer)0,NULL);
	return;
      }
      if(event_mode == 0){ /* binary search */
	if( evn <= n_of_ev){
	  XtSetArg(args[ac], XmNvalue, evn); ac++;
	  XtSetValues(scale, args, ac);
	  ac = 0;
	}
	else {
	  sprintf(message,"Max event number is %d, Yours is too big.",n_of_ev);
	  pop_error_message(message,w);
	  evn = n_of_ev-1;
	  sprintf(message,"%d",evn+1);
	  XmTextSetString(w,message);
	  XtSetArg(args[ac], XmNvalue, evn + 1); ac++;
	  XtSetValues(scale, args, ac);
	  ac = 0;
	  view_ev(NULL,(XtPointer)0,NULL);
	  return;
	}
      }
      evn = evn - 1;
      view_ev(NULL,(XtPointer)0,NULL);
    }
    else if(XtIsSubclass(w,xmScaleWidgetClass)){
      evn = cbs->value;
      sprintf(message,"%d",evn);
      XmTextSetString(text_in3,message);
      evn = evn -1;
      view_ev(NULL,(XtPointer)0,NULL);
    }
    else
      ;
  }
  else{ /* look at live stream */
    spy_rate = cbs->value;
  }
}


/***************************************************************************
 *                void view_mode_changed()                                 *
 * Description:                                                            *
 *     Change view mode from viewing a file to spying a live stream        *
 **************************************************************************/
void view_mode_changed(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmToggleButtonCallbackStruct *cbs;
{
  int which = (int)client_data;
  XmString str;
  int rpc_suc,conv_suc;
  int tag_value, ac = 0;
  Arg args[5];
  Pixel fg, bg;

  XtSetArg(args[ac], XmNbackground, &bg); ac++;
  XtSetArg(args[ac], XmNforeground, &fg); ac++;
  XtGetValues(sw, args, ac);
  ac = 0;
  if(which == 1){ /* view file */
#ifdef WITH_ET
    if(et_init > 0) {
      if (et_alive(et_sys)) {
	char       *obj_name;
	obj_name = strsave(SOURCE);
	
	if (et_stat != -1) {
          et_station_detach(et_sys, et_my_attach);
	  et_station_remove(et_sys, et_stat);
	}
	et_close(et_sys);
	et_init = 0;
	free (obj_name);
      }
    }
#else
    if (ddu_attached()) {
      ddu_stop();
      printf("call ddu_close\n");
      ddu_close();
    }
#endif
    if(cbs->set){
      XtSetArg(args[ac], XmNforeground, bg); ac++;
      XtSetArg(args[ac], XmNbackground, fg); ac++;
      XtSetValues(tog_source, args, ac);
      ac = 0;
      XtSetArg(args[ac], XmNset, FALSE); ac++;
      XtSetArg(args[ac], XmNforeground, fg); ac++;
      XtSetArg(args[ac], XmNbackground, bg); ac++;
      XtSetValues(tog_stream, args, ac);
      ac = 0;
      view_mode = 0;
      if(spy_id)
	XtRemoveTimeOut(spy_id);
      
      spy_go_pause = 0;
      spy_rate = 1;
      
      str = XmStringCreateSimple("Event Number Slider");
      XtSetArg(args[ac], XmNvalue, 1); ac++;
      XtSetArg(args[ac], XmNtitleString, str); ac++;
      XtSetValues(scale, args, ac);
      ac = 0;
      XmStringFree(str);

      XtSetSensitive(scale,FALSE);
      XtSetSensitive(m_cas0,TRUE);
      XtSetSensitive(pushb0,TRUE);
      XtSetSensitive(pushb1,TRUE);

      str = XmStringCreateSimple("Reserved");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(pushb2, args, ac);
      ac = 0;
      XmStringFree(str);
      XtSetSensitive(pushb2,FALSE);

      str = XmStringCreateSimple("Data Source:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm0, args, ac);
      ac = 0;
      XmStringFree(str);

      str = XmStringCreateSimple("Tag Name:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm2, args, ac);
      ac = 0;
      XmStringFree(str);

      mode_change_reset();
      report_message("To start, enter a file name", 0);
    }
    else{
      XtSetArg(args[ac], XmNforeground, fg); ac++;
      XtSetArg(args[ac], XmNbackground, bg); ac++;
      XtSetValues(tog_source, args, ac);
      ac = 0;

      XtSetArg(args[ac], XmNset, TRUE); ac++;
      XtSetArg(args[ac], XmNforeground, bg); ac++;
      XtSetArg(args[ac], XmNbackground, fg); ac++;
      XtSetValues(tog_stream, args, ac);
      ac = 0;
      view_mode = 1;
      spy_go_pause = 0;
      spy_rate = 1;

      str = XmStringCreateSimple("Update Rate (Sec)");
      XtSetArg(args[ac], XmNminimum, 1); ac++;
      XtSetArg(args[ac], XmNmaximum, 20); ac++;
      XtSetArg(args[ac], XmNvalue, 1); ac++;
      XtSetArg(args[ac], XmNtitleString, str); ac++;
      XtSetValues(scale, args, ac);
      ac = 0;
      XmStringFree(str);

      XtSetSensitive(scale,TRUE);
      XtSetSensitive(m_cas0,FALSE);
      XtSetSensitive(pushb0,FALSE);
      XtSetSensitive(pushb1,FALSE);

      ac = 0;
      str = XmStringCreateSimple("Go");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(pushb2, args, ac);
      ac = 0;
      XmStringFree(str);
      XtSetSensitive(pushb2,TRUE);

      str = XmStringCreateSimple("Fifo Name:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm0, args, ac);
      ac = 0;
      XmStringFree(str);

      str = XmStringCreateSimple("Event Type:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm2, args, ac);
      ac = 0;
      XmStringFree(str);

      mode_change_reset();
      report_message("To start, enter an object name and a tag name (value)", 0);
    }
  }
  else{           /* view stream */
    if(cbs->set){
      XtSetArg(args[ac], XmNset, FALSE); ac++;
      XtSetArg(args[ac], XmNforeground, fg); ac++;
      XtSetArg(args[ac], XmNbackground, bg); ac++;
      XtSetValues(tog_source, args, ac);
      ac = 0;

      XtSetArg(args[ac], XmNforeground, bg); ac++;
      XtSetArg(args[ac], XmNbackground, fg); ac++;
      XtSetValues(tog_stream, args, ac);
      ac = 0;
      view_mode = 1;
      spy_go_pause = 0;
      spy_rate = 1;

      str = XmStringCreateSimple("Update Rate (Sec)");
      XtSetArg(args[ac], XmNminimum, 1); ac++;
      XtSetArg(args[ac], XmNmaximum, 20); ac++;
      XtSetArg(args[ac], XmNvalue, 1); ac++;
      XtSetArg(args[ac], XmNtitleString, str); ac++;
      XtSetValues(scale, args, ac);
      ac = 0;
      XmStringFree(str);

      XtSetSensitive(scale,TRUE);
      XtSetSensitive(m_cas0,FALSE);
      XtSetSensitive(pushb0,FALSE);
      XtSetSensitive(pushb1,FALSE);

      str = XmStringCreateSimple("Go");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(pushb2, args, ac);
      ac = 0;
      XmStringFree(str);
      XtSetSensitive(pushb2,TRUE);

      str = XmStringCreateSimple("Fifo Name:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm0, args, ac);
      ac = 0;
      XmStringFree(str);

      str = XmStringCreateSimple("Event Type:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm2, args, ac);
      ac = 0;
      XmStringFree(str);

      mode_change_reset();
      XmTextSetString(text_in0,"SPY");
      strcpy (SOURCE, "SPY");
      XmTextSetString(text_in2,"-1");
      strcpy (TAG, "-1");

      report_message("To start, enter an object name and a tag name (value)", 0);
    }
    else{
      XtSetArg(args[ac], XmNforeground, fg); ac++;
      XtSetArg(args[ac], XmNbackground, bg); ac++;
      XtSetValues(tog_stream, args, ac);
      ac = 0;

      XtSetArg(args[ac], XmNforeground, bg); ac++;
      XtSetArg(args[ac], XmNbackground, fg); ac++;
      XtSetArg(args[ac], XmNset, TRUE); ac++;
      XtSetValues(tog_source, args, ac);
      ac = 0;
      view_mode = 0;
      XtRemoveTimeOut(spy_id);
      spy_go_pause = 0;
      spy_rate = 1;

      str = XmStringCreateSimple("Event Number Slider");
      XtSetArg(args[ac], XmNvalue, 1); ac++;
      XtSetArg(args[ac], XmNtitleString, str); ac++;
      XtSetValues(scale, args, ac);
      ac = 0;
      XmStringFree(str);

      XtSetSensitive(scale,FALSE);
      XtSetSensitive(m_cas0,TRUE);
      XtSetSensitive(pushb0,TRUE);
      XtSetSensitive(pushb1,TRUE);

      str = XmStringCreateSimple("Reserved");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(pushb2, args, ac);
      ac = 0;
      XmStringFree(str);
      XtSetSensitive(pushb2,FALSE);

      str = XmStringCreateSimple("Data Source:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm0, args, ac);
      ac = 0;
      XmStringFree(str);

      str = XmStringCreateSimple("Tag Name:");
      XtSetArg(args[ac], XmNlabelString, str); ac++;
      XtSetValues(comm2, args, ac); ac++;
      XmStringFree(str);

      mode_change_reset();
      report_message("To start, enter a file name", 0);
    }
  }
}

/***************************************************************************
 *               void start_spy_timer ( )                                  *
 * Description:                                                            *
 *      Go button call back and startup a loop update event                *
 **************************************************************************/
void start_spy_timer(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  XmString    str;
  char        *obj_name,*tag_name;
  int         tag_value,conv_suc;
  int         rpc_suc, ac = 0;
  Arg         args[10];

  if(spy_go_pause == 0){  
    empty_string (SOURCE);
    strcpy (SOURCE, XmTextGetString (text_in0));
    if (is_string_empty (SOURCE)){
      report_message ("Need object name", 0);
      return;
    }
    empty_string (TAG);
    strcpy (TAG, XmTextGetString(text_in2));
    if(is_string_empty (TAG)){
      report_message("Need tag value", 0);
      return;
    }
    conv_suc = conv_tag_int(&tag_value,TAG);
    if(conv_suc != 0)
      return;

    str = XmStringCreateSimple("Pause");
    XtSetArg(args[ac], XmNlabelString, str); ac++;
    XtSetValues(pushb2, args, ac);
    ac = 0;
    XmStringFree(str);
    spy_id = XtAppAddTimeOut(app_context,spy_rate*1000,spy_timer,
			     (XtPointer)tag_value);
    spy_go_pause = 1;
  }
  else{  
    XtRemoveTimeOut(spy_id);
    str = XmStringCreateSimple("Go");
    XtSetArg(args[ac], XmNlabelString, str); ac++;
    XtSetValues(pushb2, args, ac);
    ac = 0;
    XmStringFree(str);
    spy_go_pause = 0;
  }
}

/****************************************************************************
 *               void quit ()                                               *
 * description:                                                             *
 *     Well, you guessed it, exit here                                      *
 ***************************************************************************/
void quit(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  int i;

  for(i=0;i<MAX_LEAF_NODE;i++){
    if(d_shell[i].buffer != NULL)
      free(d_shell[i].buffer);
    d_shell[i].buffer = (char *)NULL;
  }

  XtDestroyApplicationContext(app_context);
  exit(0);
}

/*****************************************************************************
 *                void dict_mode ()                                          *
 * Description:                                                              *
 * allow user to disable dictionary and enable dictionary                    *
 ****************************************************************************/
void dict_mode(w,client_data,cbs)
Widget w;
XtPointer client_data;
XmToggleButtonCallbackStruct *cbs;
{
  int item_no = (int)client_data;
  int old_dict_mode, ac = 0;
  evTreeNode *root;
  char       temp[4];
  int        header1;
  Arg        args[5];

  old_dict_mode = disable_dict;
  if(item_no ==0){/* enable dict button */
    if(cbs->set)
      disable_dict = 0;
    else
      disable_dict = 1;
  }
  else{ /*disable dict utton */
    if(cbs->set)
      disable_dict = 1;
    else
      disable_dict = 0;
  }
  if(old_dict_mode == disable_dict)
    return;
  
  if(disable_dict == 0){
    XtSetArg(args[ac], XmNset, TRUE); ac++;
    XtSetValues(dict_op0, args, ac);
    ac = 0;

    XtSetArg(args[ac], XmNset, FALSE); ac++;
    XtSetValues(dict_op1, args, ac);
    ac = 0;
  }
  else{
    XtSetArg(args[ac], XmNset, FALSE); ac++;
    XtSetValues(dict_op0, args, ac);
    ac = 0;

    XtSetArg(args[ac], XmNset, TRUE); ac++;
    XtSetValues(dict_op1, args, ac);
    ac = 0;
  }
  if(is_string_empty(SOURCE))/* source empty */
    return;

  if(view_mode == 0){ /* view a file */
    bufcpy(temp,ev);
    header1 = *(int *)(temp) + 1;

    root = EvTreeConstruct(ev, 0xC, header1);
    disp_tree_dict_mode (root);
  }
}

/***************************************************************************
 *                void do_seq_search()                                     *
 * Description:                                                            *
 *     Start doing sequential search                                       *
 **************************************************************************/
static void do_seq_search(w, client_data, cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  char msg[20];

  /* disable scale to select event */
  XtSetSensitive(scale, False);
  /* close old file descriptor if neccessary */
  if (fseq_d){
    evClose(fseq_d);
    fseq_d = 0;
    last_seq_evn = 0;
  }
  /* reset event number */
  evn = 0;
  sprintf(msg,"%d",evn + 1);
  XmTextSetString(text_in3, msg);
  XmScaleSetValue(scale, evn + 1);

  event_mode = 1;
  XtDestroyWidget(XtParent(w));
}

/***************************************************************************
 *                 static void do_binary_search()                          *
 * Description:                                                            *
 *     Start doing binary search                                           *
 **************************************************************************/
static void do_binary_search(w, client_data, cbs)
Widget w;
XtPointer client_data;
XmAnyCallbackStruct *cbs;
{
  char msg[20];

  /* allow to select event number from the scale */
  XtSetSensitive(scale, True);
  /* close old seq file descriptor if neccessary */
  if (fseq_d){
    evClose(fseq_d);
    fseq_d = 0;
    last_seq_evn = 0;
  }
  /* reset event number */
  evn = 0;
  XmScaleSetValue(scale, evn + 1);
  sprintf(msg,"%d",evn + 1);
  XmTextSetString(text_in3, msg);

  event_mode = 0;
  XtDestroyWidget(XtParent(w));
}

/****************************************************************************
 *           static void warn_sequentail_method ()                          *
 * Description:                                                             *
 *     Warn user a long process for sequential search                       *
 ***************************************************************************/
static void warn_sequential_method(base)
Widget base;
{
  XmString message, yes, no;
  char     temp[256];
  Widget   dialog, help_w, label_w;
  Arg      args[10];
  int      ac = 0;

  strcpy(temp,"Viewing all special events\nwill dramatically slow the process\n");
  strcat(temp,"Are you sure?");
  message = XmStringCreateLtoR(temp,XmSTRING_DEFAULT_CHARSET);
  yes = XmStringCreateSimple("Yes");
  no = XmStringCreateSimple("No");
  
  XtSetArg(args[ac], XmNmessageString, message); ac++;
  XtSetArg(args[ac], XmNokLabelString, yes); ac++;
  XtSetArg(args[ac], XmNcancelLabelString, no); ac++;
  XtSetArg(args[ac], XmNtitle, "Seq_search Warning"); ac++;
  XtSetArg(args[ac], XmNdefaultButtonType, XmDIALOG_CANCEL_BUTTON); ac++;
  XtSetArg(args[ac], XmNautoUnmanage, FALSE); ac++;
  XtSetArg(args[ac], XmNbackground, normal_bg); ac++;
  dialog = (Widget)XmCreateWarningDialog(base,"warning", args, ac);
  ac = 0;
  XmStringFree(message);
  XmStringFree(yes);
  XmStringFree(no);
  
  help_w = (Widget)XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON);
  XtSetSensitive(help_w, FALSE);
  label_w = (Widget)XmMessageBoxGetChild(dialog, XmDIALOG_MESSAGE_LABEL);
  XtSetArg(args[ac], XmNalignment, XmALIGNMENT_CENTER); ac++;
  XtSetValues(label_w, args, ac);
  ac = 0;
  
  XtAddCallback(dialog, XmNokCallback, do_seq_search, (XtPointer)NULL);
  XtAddCallback(dialog, XmNcancelCallback, do_binary_search, (XtPointer)NULL);
  
  XtManageChild(dialog);
  XtPopup(XtParent(dialog), XtGrabNone);
}

/****************************************************************************
 *            void change_event_mode ()                                     *
 * Description:                                                             *
 *     Change Search Event Mode                                             *
 ***************************************************************************/
void change_event_mode(w, client_data, cbs)
Widget w;
XtPointer client_data;
XmToggleButtonCallbackStruct *cbs;
{
  char msg[20];

  if(cbs->set){
    /* use scale to select event */
    XtSetSensitive(scale, True);
    /* reset event number */
    evn = 0;
    sprintf(msg,"%d",evn + 1);
    XmScaleSetValue(scale, evn + 1);
    XmTextSetString(text_in3, msg);
    event_mode = 0;
  }
  else{
    warn_sequential_method(XtParent(XtParent(w)));
  }
}


