/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	 print out each item icase of repeating structure to a buffer
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: sprint_item.c,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:24  chen
 *   original port to solaris
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include "xcef.h"

void sprint_item(evin,ev_node,data_start,format,format_num,buffer)
Event evin[];
evTreeNode *ev_node;
int data_start;
FORMAT *format[];
int    format_num;
char   *buffer;
{
  int i,j,m;
  char temp[4],temp2[2],str[50],*q;
  int  i_temp;
  short s_temp;
  unsigned short us_temp;
  float f_temp;
  void bufcpy(),bufcpy2();

  q = buffer;
  i = data_start;
  j = 0;  /*pointer to format*/
  while( i < ev_node->start + ev_node->length)
    {
      switch(format[j]->type)
	{
	case 0x0:      /*unknown*/
	  bufcpy2(temp2,&evin[2*i]);
	  us_temp = *(unsigned short *)(temp2);
	  if(format[j]->new_line == 1)
	    sprintf(str,"0x%-9.4x\n",us_temp);
	  else
	    sprintf(str,"0x%-10.4x",us_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  j++;
	  i = i + 1;
	  break;
	case 0x1:     /*integer*/
	  bufcpy(temp,&evin[i*2]);
	  i_temp = *(int *)(temp);
	  if(format[j]->new_line == 1)
	    {
	      if(hex_or_decimal == 0)
		sprintf(str,"%-11d\n",i_temp);
	      else
		sprintf(str,"0x%-9.8x\n",i_temp);	      
	    }
	  else
	    {
	      if(hex_or_decimal == 0)
		sprintf(str,"%-12d",i_temp);
	      else
		sprintf(str,"0x%-10.8x",i_temp);	      
	    }
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  j++;
	  i = i +2;
	  break;
	case 0x2:    /*floating point*/
	  bufcpy(temp,&evin[i*2]);
	  f_temp = *(float *)(temp);
	  if(format[j]->new_line == 1)
	    sprintf(str,"%-11.5f\n",f_temp);
	  else
	    sprintf(str,"%-12.5f",f_temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  j++;
	  i= i + 2;
	  break;
	case 0x3:   /* ascii string*/
	  bufcpy(temp,&evin[i*2]);
	  if(format[j]->new_line == 1)
	    sprintf(str,"%-11s\n",temp);
	  else
	    sprintf(str,"%-12s",temp);
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }	  
	  i = i + 2;
	  j++;
	  break;
	case 0x4:  /* short integer most commonly used*/
	  bufcpy2(temp2,&evin[2*i]);
	  s_temp = *(short *)(temp2);
	  if(format[j]->new_line == 1)
	    {
	      if(hex_or_decimal == 0)
		sprintf(str,"%-11d\n",s_temp);
	      else
		sprintf(str,"0x%-9.4x\n",s_temp);
	    }
	  else
	    {
	      if(hex_or_decimal == 0)
		sprintf(str,"%-12d",s_temp);
	      else
		sprintf(str,"0x%-10.4x",s_temp);
	    }
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  j++;
	  i++;
	  break;
	case 0x5:
	  bufcpy2(temp2,&evin[i*2]);
	  us_temp = *(unsigned short *)(temp2);
	  if(format[j]->new_line == 1)
	    {
	      if(hex_or_decimal == 0)
		sprintf(str,"%-11d\n",us_temp);
	      else
		sprintf(str,"0x%-9.4x\n",us_temp);
	    }
	  else
	    {
	      if(hex_or_decimal == 0)
		sprintf(str,"%-12d",us_temp);
	      else
		sprintf(str,"0x%-10.4x",us_temp);
	    }
	  for(m=0;m<12;m++)
	    {
	      *q = str[m];
	      q++;
	    }
	  j++;
	  i++;
	  break;
	default:
	  break;
	}
      if(j >= format_num)  /*j is greater or = to total formats, repeat again*/
	j = 0;
    }
  *q = '\0';
}


