/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA Integer Value Mask Widget
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: ValueMaskP.h,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:25  chen
 *   original port to solaris
 *
 *	  Revision 1.1  1994/12/08  19:55:44  chen
 *	  Initial revision
 *
 *	  Revision 1.2  1994/09/09  16:10:50  chen
 *	  add comment
 *
 *	  Revision 1.1  1994/04/06  14:35:23  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1994/02/07  15:25:15  chen
 *	  Initial revision
 *
 *	  
 */
#ifndef _VALUE_MASK_P_H
#define _VALUE_MASK_P_H

#include "ValueMask.h"

#define  MAX_NUM_BITS  32

/* Value Mask is Derived from core, so no need to include the
 * super class private header file, no internal types need to be defined
 */
/* new fields for the value mask widget */
typedef struct {
  /* resources  */
  Dimension        num_bit;
  Pixel            foreground;
  XtCallbackList   callback;
  /* internal  */
  GC               gc;
  GC               selected_gc;
  GC               erase_gc;
  int              bit_set[MAX_NUM_BITS];
  int              mask_value;
  Dimension        bit_size;
  Dimension        space;
  Position         bit_x_pos[MAX_NUM_BITS];
  Position         bit_y_pos[MAX_NUM_BITS];
  Position         pre_x;
  Position         pre_y;
}XcodaValueMaskPart;

/* default full instance record */
typedef struct _XcodaValueMaskRec{
  CorePart             core;
  XcodaValueMaskPart   valueMask;
}XcodaValueMaskRec;

/* Define class part */
typedef struct _XcodaValueMaskClassPart{
  XtPointer        extension;
}XcodaValueMaskClassPart;

/* define whole class part */
typedef struct _XcodaValueMaskClassRec{
  CoreClassPart           core_class;
  XcodaValueMaskClassPart valueMask_class;
}XcodaValueMaskClassRec;

extern XcodaValueMaskClassRec xcodaValueMaskClassRec;

#endif /* ValueMaskP.h" */

