/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	CODA Value Mask Widget
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: ValueMask.h,v $
 *   Revision 1.1.1.1  1996/09/19 18:26:25  chen
 *   original port to solaris
 *
 *	  Revision 1.1  1994/12/08  19:55:36  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1994/04/06  14:35:16  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1994/02/07  15:25:00  chen
 *	  Initial revision
 *
 *	  
 */
#ifndef _VALUE_MASK_H
#define _VALUE_MASK_H

/* value mask is derived from core widget, so no need to include
   the super class public header file */
/* new resources */
#define XcodaNbitSelectCallback "bitSelectCallback"
#define XcodaNnumBit            "numBit"
#define XcodaNforeground        "foreground"

#define XcodaCBitSelectCallback "BitSelectCallback"
#define XcodaCNumBit            "NumBit"
#define XcodaCForeground        "Foreground"

/*extern reference to the class record pointer */
extern WidgetClass xcodaValueMaskWidgetClass;

/* type definition for value mask widget */
typedef struct _XcodaValueMaskClassRec * XcodaValueMaskWidgetClass;
typedef struct _XcodaValueMaskRec      * XcodaValueMaskWidget;

#define XcodaIsValueMask(w) XtIsSubclass(w, xcodaValueMaskWidgetClass)

extern int  XcodaValueMaskGetValue();
extern void XcodaValueMaskSetValue();

#endif /*ValueMask.h */
