/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	
 *	
 * Author:  Jie Chen and Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: print_item.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:28  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:45:26  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1994/05/17  13:48:28  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1992/11/03  15:44:36  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include <string.h>
#include "cef.h"

void print_item(ev,ev_node,data_start,format,format_num,blank)
Event ev[];
evTreeNode *ev_node;
int data_start;
FORMAT *format[];
int    format_num;
char   *blank;
{
  int i,j;
  char temp[4],temp2[2];
  int  i_temp;
  short s_temp;
  unsigned short us_temp;
  float f_temp;
  void bufcpy(),bufcpy2();

  i = data_start;
  j = 0;  /*pointer to format*/
  while( i < ev_node->start + ev_node->length)
    {
      switch(format[j]->type)
	{
	case 0x0:      /*unknown*/
	  bufcpy2(temp2,&ev[2*i]);
	  us_temp = *(unsigned short *)(temp2);
	  if(j == 0 || format[j-1]->new_line == 1)  /* start new line*/
	    {
	      if(format[j]->new_line == 1)
		printf("%s 0x%-6.4x\n",blank,us_temp);
	      else
		printf("%s 0x%-6.4x",blank,us_temp);
	    }
	  else
	    {
	      if(format[j]->new_line == 1)
		printf("0x%-6.4x\n",us_temp);
	      else
		printf("0x%-6.4x",us_temp);
	    }
	  j++;
	  i = i + 1;
	  break;
	case 0x1:     /*integer*/
	  bufcpy(temp,&ev[i*2]);
	  i_temp = *(int *)(temp);
	  if(j == 0 || format[j-1]->new_line == 1)  /* start new line*/
	    {
	      if(format[j]->new_line == 1)
		{
		  if(hex_or_decimal == 0)
		    printf("%s %-12d\n",blank,i_temp);
		  else
		    printf("%s 0x%-10.8x\n",blank,i_temp);	      
		}
	      else
		{
		  if(hex_or_decimal == 0)
		    printf("%s %-12d",blank,i_temp);
		  else
		    printf("%s 0x%-10.8x",blank,i_temp); 
		}
	    }
	  else
	    {
	      if(format[j]->new_line == 1)
		{
		  if(hex_or_decimal == 0)
		    printf("%-12d\n",i_temp);
		  else
		    printf("0x%-10.8x\n",i_temp);	      
		}
	      else
		{
		  if(hex_or_decimal == 0)
		    printf("%-12d",i_temp);
		  else
		    printf("0x%-10.8x",i_temp);	      
		}
	    }
	  j++;
	  i = i +2;
	  break;
	case 0x2:    /*floating point*/
	  bufcpy(temp,&ev[i*2]);
	  f_temp = *(float *)(temp);
	  if(j == 0 || format[j-1]->new_line == 1)  /* start new line*/
	    {
	      if(format[j]->new_line == 1)
		printf("%s %f\n",blank,f_temp);
	      else
		printf("%s %f",blank,f_temp);
	    }
	  else
	    {
	      if(format[j]->new_line == 1)
		printf("%f\n",f_temp);
	      else
		printf("%f",f_temp);
	    }
	  j++;
	  i= i + 2;
	  break;
	case 0x3:   /* ascii string*/
	  bufcpy(temp,&ev[i*2]);
	  if(j == 0 || format[j-1]->new_line == 1)  /* start new line*/
	    {
	      if(format[j]->new_line == 1)
		printf("%s %s\n",blank,temp);
	      else
		printf("%s %s",blank,temp);
	    }
	  else
	    {
	      if(format[j]->new_line == 1)
		printf("%s\n",temp);
	      else
		printf("%s",temp);
	    }
	  i = i + 2;
	  j++;
	  break;
	case 0x4:  /* short integer most commonly used*/
	  bufcpy2(temp2,&ev[2*i]);
	  s_temp = *(short *)(temp2);
	  if(j == 0 || format[j-1]->new_line == 1)  /* start new line*/
	    {
	      if(format[j]->new_line == 1)
		{
		  if(hex_or_decimal == 0)
		    printf("%s %-8d\n",blank,s_temp);
		  else
		    printf("%s 0x%-6.4x\n",blank,s_temp);
		}
	      else
		{
		  if(hex_or_decimal == 0)
		    printf("%s %-8d",blank,s_temp);
		  else
		    printf("%s 0x%-6.4x",blank,s_temp);
		}
	    }
	  else
	    {
	      if(format[j]->new_line == 1)
		{
		  if(hex_or_decimal == 0)
		    printf("%-8d\n",s_temp);
		  else
		    printf("0x%-6.4x\n",s_temp);
		}
	      else
		{
		  if(hex_or_decimal == 0)
		    printf("%-8d",s_temp);
		  else
		    printf("0x%-6.4x",s_temp);
		}
	    }
	  j++;
	  i++;
	  break;
	case 0x5:
	  bufcpy2(temp2,&ev[i*2]);
	  us_temp = *(unsigned short *)(temp2);
	  if(j == 0 || format[j-1]->new_line == 1)  /* start new line*/
	    {
	      if(format[j]->new_line == 1)
		{
		  if(hex_or_decimal == 0)
		    printf("%s %-8d\n",blank,us_temp);
		  else
		    printf("%s 0x%-6.4x\n",blank,us_temp);
		}
	      else
		{
		  if(hex_or_decimal == 0)
		    printf("%s %-8d",blank,us_temp);
		  else
		    printf("%s 0x%-6.4x",blank,us_temp);
		}
	    }
	  else
	    {
	      if(format[j]->new_line == 1)
		{
		  if(hex_or_decimal == 0)
		    printf("%-8d\n",us_temp);
		  else
		    printf("0x%-6.4x\n",us_temp);
		}
	      else
		{
		  if(hex_or_decimal == 0)
		    printf("%-8d",us_temp);
		  else
		    printf("0x%-6.4x",us_temp);
		}
	    }
	  j++;
	  i++;
	  break;
	default:
	  break;
	}
      if(j >= format_num)  /*j is greater or = to total formats, repeat again*/
	j = 0;
    }

}


