/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Find default dictionary
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: ev_dict.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:44:45  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include <string.h>
#include "cef.h"

extern char *strsave();
/**********************************************************************
 *           void evFindDefaultDict ()                                *
 * Description:                                                       *
 *    Find default dictionary pointed by $RCDATABASE env              *
 *********************************************************************/
void evFindDefaultDict()
{
  extern char *getenv();
  char temp[200],*p;
  FILE *fdict;

  if((p=getenv("EVTAGS")) != NULL){
    fdict = fopen(p,"r");
    if(fdict != NULL){
      strcpy (DIRC, p);
      fclose(fdict);
      return;
    }
  }

  if((p=getenv("RCDATABASE")) != NULL){
    sprintf(temp,"%s/evTags",p);
    fdict = fopen(temp,"r");
    if(fdict != NULL){
      strcpy (DIRC, temp);
      fclose(fdict);
      return;
    }
  }
  
  fdict = fopen("./evTags","r");
  if(fdict != NULL){
    strcpy(DIRC, "./evTags");
    fclose(fdict);
    return;
  }
  empty_string (DIRC);
}

    
  
  

