/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Print out formatted event to stdout
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: dump_tree.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:44:25  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include "cef.h"

typedef struct
{
  int  ind;
  char *type;
}D_TYPE;

D_TYPE d_type[]= {{0x0,"unknown"},
                  {0x1,"integer"},
                  {0x2,"IEEE Floating"},
                  {0x3,"ASCII string"},
                  {0x4,"short int"},
                  {0x5,"unsigned short"},
                  {0x6,"8 bit singed int"},
                  {0x7,"8 bit unsigned int"},
                  {0x8,"double IEEE folating"},
                  {0x9,"VAX floating"},
                  {0xA,"VAX double floating"},
                  {0xF,"Repeating Structure"},
                  {0x10,"bank"},
                  {0x20,"segment"},
                  {0x30,"packet unknown"},
                  {0x33,"packet ASCII string"},
                  {0x34,"packet short int"},
                  {0x35,"packet short unsigned int"},
                  {0x36,"packet 8 bit signed int"},
                  {0x37,"packet 8 bit unsigned int"}
		};

extern void parse_format();
/*******************************************************************
 *        void prod_blank (depth, blank)                           *
 * Description:                                                    *
 *    Produce blank output according to the depth of a tree        *
 ******************************************************************/
static void prod_blank(depth,blank)
int depth;
char blank[];
{
  int i;

  for(i=0;i<4*(depth+1);i++){
    blank[i]=' ';
  }
  blank[4*(depth+1)-1]='\0';
}

/******************************************************************
 *          void dump_tree (root, ev)                             *
 * Description:                                                   *
 *    Dump event to output                                        *
 *****************************************************************/
void dump_tree(root,ev)
evTreeNode *root;
Event ev[];
{
  evTreeNode *p,*q;
  int         depth;     /* depth of a node */
  int         i,j,k,header1,header2;
  float       f_temp;
  double      d_temp;
  short       s_temp;
  char        blank[80];
  unsigned short thead;
  short       temp2;
  int         temp;
  char        ctemp[4], ctemp2[2];
  FORMAT      *format[100];
  int         format_num;    /*format num in the format array*/
  int         format_len;    /*format des in 16 bit words*/

  p = root;
  q = root;

  if(p != NULL){
    depth = 0;
    while(q->parent != NULL){
      q= q->parent;
      depth = depth +1;
    }
    prod_blank(depth,blank);
    for(k=0; k<20;k++){
      if(p->type == d_type[k].ind)
	break;
    }
    if(p->type <0x30)
      printf("%s %s length=%d %s\n",blank,p->name,p->length/2,d_type[k].type);
    else
      printf("%s %s length=%d %s\n",blank,p->name,p->length,d_type[k].type);


    if(p->type < 0x10 || (p->type >= 0x30 && p->mleft == NULL)){
      prod_blank(depth+1,blank);
      switch(p->type){
      case 0x0:
      case 0x30:
	fprintf(stderr,"Unknown data type.\n");
	if(hex_or_decimal == 0)
	  hex_or_decimal = 1;
	if(p->parent_type == 0x10){
	  i = p->start;
	  i = i+4;   /* i is pointing to 16bit size*/
	}
	else{
	  i = p->start;
	  i = i+2;
	}
	j = i*2;
	k = 0;
	while(i < (p->start + p->length) ){
	  bufcpy2((char *)&temp2,&ev[j]);
	  thead = (unsigned short)temp2;
	  if(k == 0)
	    printf("%s 0x%-6.4x",blank,thead);
	  else{
	    if(k < 3)
	      printf("0x%-6.4x",thead);
	    else{
	      k = -1;
	      printf("0x%-6.4x\n",thead);
	    }
	  }
	  k++;
	  j=j+2;
	  i=j/2;
	}
	printf("\n");
	break;
      case 0x1:
	if(p->parent_type == 0x10){         /* bank type*/
	  i = p->start;
	  i = i+4;
	}
	else{                            /*segment */
	  i = p->start;
	  i = i+2;
	}
	k = 0;
	while(i < p->start + p->length){
	  bufcpy((char *)&temp,&ev[i*2]);
	  header1 = temp;
	  if(k == 0){
	    if(hex_or_decimal == 0)
	      printf("%s %-12d",blank,header1);
	    else
	      printf("%s 0x%-10.8x",blank,header1);
	  }
	  else {
	    if(k < 3){
	      if(hex_or_decimal == 0)
		printf("%-12d",header1);
	      else
		printf("0x%-10.8x",header1);
	    }
	    else{
	      k = -1;
	      if(hex_or_decimal == 0)
		printf("%-12d\n",header1);
	      else
		printf("0x%-10.8x\n",header1);
	    }
	  }
	  k++;
	  i = i +2;
	}
	printf("\n");
	break;
      case 0x2:             /*IEEE floating point*/
	if(p->parent_type == 0x10){   /*bank type*/
	  i = p->start;
	  i = i + 4;
	}
	else{       /* for both packet and segment*/
	  i = p->start;
	  i = i + 2;
	}
	k = 0;
	while(i < p->start + p->length){
	  bufcpy((char *)&temp,&ev[i*2]);
	  f_temp = (float)temp;
	  if(k == 0)
	    printf("%s %f",blank,f_temp);
	  else {
	    if ( k < 3)
	      printf("%f",f_temp);
	    else{
	      k = -1;
	      printf("%f\n",f_temp);
	    }
	  }
	  k++;
	  i = i + 2;
	}
	printf("\n");
	break;
      case 0x3:  /* NULL terminated string*/
	if(p->parent_type == 0x10){
	  i = p->start;
	  i = i + 4;
	}
	else{
	  i = p->start;
	  i = i + 2;
	}
	k = 0;
	while(i < p->start + p->length){
	  bufcpy(ctemp,&ev[i*2]);
	  if(k == 0)
	    printf("%s %s",blank,ctemp);
	  else{
	    if( k < 3)
	      printf("%s",ctemp);
	    else{
	      k = -1;
	      printf("%s\n",ctemp);
	    }
	  }
	  k++;
	  i = i + 2;
	}
	printf("\n");
	break;
      case 0x4:       /* 16 bit signed integer*/
	if(p->parent_type == 0x10){  /*bank*/
	  i = p->start;
	  i = i + 4;
	}
	else{
	  i = p->start;
	  i = i + 2;
	}
	k = 0;
	j = i*2;
	while(i < p->start + p->length){
	  bufcpy2((char *)&temp2,&ev[j]);
	  s_temp = temp2;
	  if(k == 0){
	    if(hex_or_decimal == 0)
	      printf("%s %-8d",blank,s_temp);
	    else
	      printf("%s 0x%-6.4x",blank,s_temp);
	  }
	  else{
	    if(k < 3){
	      if(hex_or_decimal == 0)
		printf("%-8d",s_temp);
	      else
		printf("0x%-6.4x",s_temp);
	    }
	    else{
	      k = -1;
	      if(hex_or_decimal == 0)
		printf("%-8d\n",s_temp);
	      else
		printf("0x%-6.4x\n",s_temp);
	    }
	  }
	  k++;
	  j = j + 2;
	  i = j/2;
	}
	printf("\n");
	break;
      case 0x5:   /* unsigned short*/
	if(p->parent_type == 0x10){  /*bank*/
	  i = p->start;
	  i = i + 4;
	}
	else{
	  i = p->start;
	  i = i + 2;
	}
	k = 0;
	j = i*2;
	while(i < p->start + p->length){
	  bufcpy2((char *)&temp2,&ev[j]);
	  thead = (unsigned short)temp2;
	  if(k == 0){
	    if(hex_or_decimal == 0)
	      printf("%s %-8d",blank,thead);
	    else
	      printf("%s 0x%-6.4x",blank,thead);
	  }
	  else{
	    if(k < 3){
	      if(hex_or_decimal == 0)
		printf("%-8d",thead);
	      else
		printf("0x%-6.4x",thead);
	    }
	    else{
	      k = -1;
	      if(hex_or_decimal == 0)
		printf("%-8d\n",thead);
	      else
		printf("0x%-6.4x\n",thead);
	    }
	  }
	  k++;
	  j = j + 2;
	  i = j/2;
	}
	printf("\n");
	break;
      case 0x33:       /*PACKET with data type 0x3 string*/
	i = p->start;    /* parent type is same as data type*/
	j = i*2;
	k = 0;
	i = i + 1;
	j= j + 2;
	while(i < (p->start + p->length)){
	  bufcpy(ctemp2,&ev[j]);
	  if(k == 0)
	    printf("%s %s",blank,ctemp2);
	  else{
	    if(k < 3)
	      printf("%s",ctemp2);
	    else{
	      k = -1;
	      printf("%s\n",ctemp2);
	    }
	  }
	  k++;
	  j = j + 2;
	  i = j/2;
	}
	printf("\n");
	break;
      case 0x34:        /*packet with data type 0x4 short integer*/
	i = p->start;
	j = i*2;
	k = 0;
	i = i + 1;
	j = j + 2;
	while(i < p->start + p->length){
	  bufcpy2((char *)&temp2,&ev[j]);
	  s_temp = temp2;
	  if(k == 0){
	    if(hex_or_decimal == 0)
	      printf("%s %-8d",blank,s_temp);
	    else
	      printf("%s 0x%-6.4x",blank,s_temp);
	  }
	  else{
	    if(k < 3){
	      if(hex_or_decimal == 0)
		printf("%-8d",s_temp);
	      else
		printf("0x%-6.4x",s_temp);
	    }
	    else{
	      k = -1;
	      if(hex_or_decimal == 0)
		printf("%-8d\n",s_temp);
	      else
		printf("0x%-6.4x\n",s_temp);
	    }
	  }
	  k++;
	  j = j + 2;
	  i = j/2;
	}
	printf("\n");
	break;
      case 0x35:
	i = p->start;
	j = i*2;
	k = 0;
	i = i + 1;
	j = j + 2;
	while(i < p->start + p->length){
	  bufcpy2( (char *)&temp2,&ev[j]);
	  thead = (unsigned short)temp2;
	  if(k == 0){
	    if(hex_or_decimal == 0)
	      printf("%s %-8d",blank,thead);
	    else
	      printf("%s 0x%-6.4x",blank,thead);
	  }
	  else{
	    if(k < 3){
	      if(hex_or_decimal == 0)
		printf("%-8d",thead);
	      else
		printf("0x%-6.4x",thead);
	    }
	    else{
	      k = -1;
	      if(hex_or_decimal == 0)
		printf("%-8d\n",thead);
	      else
		printf("0x%-6.4x\n",thead);
	    }
	  }
	  k++;
	  j = j + 2;
	  i = j/2;
	}
	printf("\n");
	break;
      case 0xF:      /*repeating structure*/
	for(i=0;i<100;i++)
	  format[i] = (FORMAT *)malloc(1*sizeof(FORMAT));
            
	parse_format(ev,p,format,&format_num,&format_len);
      
	i = p->start;
	if(p->parent_type == 0x10)
	  i = i + 4;
	else
	  i = i + 2;
	
	i = i + format_len; /* position to start real data*/
	
	print_item(ev,p,i,format,format_num,blank);  /*print out each item*/
	/* Free memory */
	for(i=0;i<100;i++)
	  free (format[i]);
	break;
      default:
	break;
      }
    }
    dump_tree(p->mleft,ev);
    dump_tree(p->rsibling,ev);
  }
}


