/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *          construct tree structure using most left
 *          child and right sibling data structure
 *          accrording to the dictionary
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: dict_tree.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:44:00  chen
 *	  Initial revision
 *
 *	  Revision 1.3  1994/05/13  18:38:19  chen
 *	  free title and name
 *
 *	  Revision 1.2  1994/05/12  18:28:26  chen
 *	  Free tree memory and remove global variables
 *
 *	  Revision 1.1  1994/04/12  16:19:51  chen
 *	  Initial revision
 *
 *	  Revision 1.1  1992/07/28  19:06:25  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include "cef.h"

extern char  *strsave();
extern int   lrcur_conf(), name_match();
extern void  process_string();
/*************************************************************
 *        TREE_NODE *DictTreeConstruct ()                    *
 * Description:                                              *
 *     Create a TreeNode Structure from a dictionary which   *
 *     has been converted to array of input char *           *
 ************************************************************/
TREE_NODE *DictTreeConstruct(string, s, e, input, n_input_dict)
char  *string;        /* string match                        */
int   s;              /* starting line index                 */
int   *e;             /* after a tree, return line index     */
char  **input;        /* array of strings of dictionary file */
int   n_input_dict;   /* dimension of array                  */
{
  char   *q, line[80];
  char   name[32],title[64];
  int    i,j,start,next_conf;
  int    tag,confg,next_child;    /* next_child denote next line will be */
                                  /* a child of current */
  TREE_NODE *parent,*p,*root;

  next_child = 0;
  for(i=s;i<n_input_dict;i++){
    if(string == NULL){
      process_string(input[s],&tag, name, title);
      break;
    }
    else{
      if((name_match(input[i],string)) == 0){
	process_string(input[i],&tag, name, title);
	break;
      }
    }
  }
  start=i;

  parent=(TREE_NODE *)calloc(1,sizeof(TREE_NODE));
  if(parent == NULL){
    fprintf(stderr,"Cannot allocate memory for tree node \n");
    exit(1);
  }
  parent->tag_v = tag;
  parent->name = strsave(name);
  parent->title = strsave(title);
  parent->mleft = NULL;
  parent->rsibling = NULL;
  parent->parent = NULL;
  root= parent;

  confg = lrcur_conf(input[start]);
  switch(confg){
  case 0:
    *e = i+1;      
    return(root);
    break;
  case 1:
    next_conf = lrcur_conf(input[start+1]);
    if(next_conf == 2 || next_conf == 5 || next_conf == 7 ||
       next_conf == 3){
      *e = i+1;
      return(root);
    }
    break;
  case 2:
    *e = i+1;
    return(root);
    break;
  case 3:
    next_child=1;
    break;
  case 6:
    next_child=1;
    break;
  case 7:
    next_conf = lrcur_conf(input[start+1]);
    if(next_conf == 2 || next_conf == 5 || next_conf == 7 ||
       next_conf == 3){
      *e = i+1;
      return(root);
    }
    break;
  }      
  
  start=start+1;
  i=start;
  while( i < n_input_dict){
    confg = lrcur_conf(input[i]);
    switch(confg){
    case 0:
      if((p=(TREE_NODE *)calloc(1,sizeof(TREE_NODE))) !=NULL){
	process_string(input[i],&tag, name, title);
	p->tag_v=tag;
	p->name=strsave(name);
	p->title=strsave(title);
	parent->mleft=p;
	p->parent=parent;
	p->rsibling=NULL;
	free (name); free (title);
      }
      break;
    case 1:
      if((p=(TREE_NODE *)calloc(1,sizeof(TREE_NODE))) !=NULL){
	process_string(input[i],&tag, name, title);
	p->tag_v=tag;
	p->name=strsave(name);
	p->title=strsave(title);
	p->parent=parent;
	p->mleft=NULL;
	p->rsibling=NULL;
	parent->mleft=p;
	parent=p;
      }
      break;
    case 2:
      if((p=(TREE_NODE *)calloc(1,sizeof(TREE_NODE))) !=NULL){
	process_string(input[i],&tag,name,title);
	p->tag_v=tag;
	p->name=strsave(name);
	p->title=strsave(title);
	if(next_child == 1){        /* immediate child */
	  p->parent = parent;
	  parent->mleft = p;
	  parent->rsibling = NULL;
	  next_child = 0;
	}
	else{
	  p->parent=parent->parent;
	  parent->rsibling=p;
	  p->mleft=NULL;
	  p->rsibling=NULL;
	  parent=parent->parent;
	  next_child = 0;
	}
      }
      break;
    case 3:
      if((p=(TREE_NODE *)calloc(1,sizeof(TREE_NODE))) !=NULL){
	process_string(input[i],&tag,name,title);
	p->tag_v=tag;
	p->name=strsave(name);
	p->title=strsave(title);
	if(next_child == 1){          /* immediat child */
	  parent->mleft = p;
	  parent->rsibling = NULL;
	  p->parent = parent;
	  parent = p;
	  next_child = 1;
	}
	else{
	  parent->rsibling=p;
	  p->parent=parent->parent;
	  p->mleft=NULL;
	  p->rsibling=NULL;
	  parent=p;
	  next_child=1;
	}
      }
      break;
    case 4:
      next_child = 1;
      break;
    case 5:
      if(parent->parent !=NULL)
	parent=parent->parent;
      break;
    case 6:
      if((p=(TREE_NODE *)calloc(1,sizeof(TREE_NODE))) !=NULL){
	process_string(input[i],&tag,name,title);
	p->tag_v=tag;
	p->name=strsave(name);
	p->title=strsave(title);
	p->parent=parent;
	parent->mleft=p;
	p->rsibling=NULL;
	p->mleft=NULL;
	parent=p;
	next_child=1;
      }
      break;
    case 7:
      if((p=(TREE_NODE *)calloc(1,sizeof(TREE_NODE))) !=NULL){
	process_string(input[i],&tag,name,title);
	p->tag_v=tag;
	p->name=strsave(name);
	p->title=strsave(title);
	if(next_child == 1){
	  p->parent=parent;
	  parent->mleft=p;
	  p->rsibling=NULL;
	  p->mleft=NULL;
	  parent=p;
	  next_child =0;
	}
	else{
	  p->parent=parent->parent;
	  parent->rsibling=p;
	  p->mleft=NULL;
	  p->rsibling=NULL;
	  parent=p;
	}
      }
      break;
    case -1:
      fprintf(stderr,"wrong format in dictionary.\n");
      exit(1);
      break;
    }                       

    i++;
    if(parent == root && next_child == 0)
      break;
  }
 
  *e = i;    
  return(root);               
}

/****************************************************************
 *               void free_dict_tree ()                         *
 * Description:                                                 *
 *     Free TREE_NODE Structure Pointed by root                 *
 ***************************************************************/
void free_dict_tree(dr)
TREE_NODE *dr;
{
  TREE_NODE *mleft, *rsibling;

  mleft = dr->mleft;
  rsibling = dr->rsibling;
  if (dr->name != NULL)
    free (dr->name);
  if (dr->title != NULL)
    free (dr->title);
  free (dr);
  if(mleft != NULL)
    free_dict_tree (mleft);
  if(rsibling != NULL)
    free_dict_tree (rsibling);
}

/****************************************************************
 *           void tree_d_print ()                               *
 * Description:                                                 *
 *      Print out tree format recursively                       *
 ***************************************************************/
void tree_d_print(root)
TREE_NODE *root;
{
  TREE_NODE *p;

  p = root;
   
  if(p!=NULL){
    if(p->parent != NULL)
      printf("node is %s  and its parent is %s\n",p->name,p->parent->name);
    else
      printf("node is %s \n",p->name);
    tree_d_print(p->mleft);
    tree_d_print(p->rsibling);
  }
}
