/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:main program for cefdmp
 *	
 *	
 * Author: Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cefdmp.c,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:27  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.2  1995/03/17  14:55:58  chen
 *	  fix a bug
 *
 *	  Revision 1.1  1994/12/08  14:43:52  chen
 *	  Initial revision
 *
 */
#include <stdio.h>
#include <string.h>
#include "cef.h"

extern void  EvInit();
extern void  dump_content();
extern void  spy_event();

main(argc,argv)
int argc;
char **argv;
{
  char *progname,*filename,*objname;
  int   i;
  int   type = -1, spy_timer = 1;
  
  progname=argv[0];
  EvInit();

  if(argc == 1){
    /*    fprintf(stderr,"Usage: %s filename | -o objectname [-d dictionary] [-t type] [-p spy_period]\n",progname);*/
    fprintf(stderr,"Usage: %s filename [-d dictionary] [-t type] \n",progname);
    fprintf(stderr,"[-u tagname] [-s start] [-e end] [-x]\n");
    exit(1);
  }
  else if(argc == 2){
    if(argv[1][0] == '-'){
      fprintf(stderr,"Filename must be provided before options.\n");
      exit(1);
    }
    else{
      filename = argv[1];
    }
  }
  else{
    if(argv[1][0] == '-'){
      fprintf(stderr,"Filename must be provided before options.\n");
      exit(1);
    }
    else
      filename = argv[1];

    if(view_mode == 0) {  /* always true for now coda_2.0 */
      i=2;
      while(i < argc){
	if((strcmp(argv[i],"-u")) == 0){
	  i++;
	  if( i >= argc){
	    fprintf(stderr,"Usage: %s filename -u tag\n",progname);
	    exit(1);
	  }
	  else{
	    if(argv[i][0] == '-'){
	      fprintf(stderr,"Usage: %s -u tag \n", progname);
	      exit(1);
	    }
	    else{
	      strcpy(TAG, argv[i]);
	      i++;
	    }
	  }
	}
	else if((strcmp(argv[i],"-x")) == 0){
	  i++;
	  hex_or_decimal = 1;
	}
	else if((strcmp(argv[i],"-d")) == 0){
	  i++;
	  if(i >= argc){
	    fprintf(stderr," Usage: %s filename -d dictionary\n",progname);
	    exit(1);
	  }
	  else{
	    if(argv[i][0] == '-'){
	      fprintf(stderr,"Usage: %s filename -d dictionary\n",progname);
	      exit(1);
	    }
	    else{
	      strcpy(DIRC, argv[i]);
	      i++;
	    }
	  }
	}
	else if((strcmp(argv[i],"-s")) == 0){
	  i++;
	  if( i >=argc){
	    fprintf(stderr,"Usage: %s filename -s start\n",progname);
	    exit(1);
	  }
	  else{
	    if(argv[i][0] == '-'){
	      fprintf(stderr,"Usage: %s filename -s start\n",progname);
	      exit(1);
	    }
	    else{
	      start=atoi(argv[i]);
	      if( ending == 0)
		ending = -1;
	      i++;
	    }
	  }
	}
	else if((strcmp(argv[i],"-e")) == 0){
	  i++;
	  if(i >= argc){
	    fprintf(stderr,"Usage: %s filename -e end\n",progname);
	    exit(1);
	  }
	  else{
	    if(argv[i][0] == '-'){
	      fprintf(stderr,"Usage: %s filename -e end\n",progname);
	      exit(1);
	    }
	    else{
	      ending =atoi(argv[i]);
	      quick_dump_mode = 1;
	      i++;
	    }
	  }
	}
	else
	  i++;
      }
    }
    else{  /* spy event */
      i=2;
      if(argv[i][0] == '-'){
	fprintf(stderr,"Usage: %s -o objectname -t type\n",progname);
	exit(1);
      }  
      else{
	objname = argv[i];
	i++;
      }
      while(i < argc){
	if(strcmp(argv[i],"-t") == 0){
	  i++;
	  if(i >= argc){
	    fprintf(stderr,"Usage:%s -o objectname -t type\n",progname);
	    exit(1);
	  }
	  else{
	    if(argv[i][0] == '-'){
	      fprintf(stderr,"Usage:%s -o objectname -t type\n",progname);
	      exit (1);
	    }
	    else{
	      type = atoi(argv[i]);
	      i++;
	    }
	  }
	}
	else if (strcmp(argv[i], "-p") == 0){
	  i++;
	  if (i >= argc){
	    fprintf(stderr,"Usage:%s -o objectname -p period\n",progname);
	    exit(1);	    
	  }
	  else{
	    if(argv[i][0] == '-'){
	      fprintf(stderr,"Usage: %s -o objectname -p period\n",progname);
	      exit(1);
	    }
	    else{
	      spy_timer = atoi (argv[i]);
	      i++;
	    }
	  }
	}
	else if (strcmp(argv[i],"-x") == 0){
	  i++;
	  hex_or_decimal = 1;
	}
      }
    }
  }
  if(view_mode == 0){
    if(is_string_empty (DIRC))
      evFindDefaultDict();
    dump_content(filename,TAG);  
  }
  else
    spy_event(objname,type, spy_timer);
}
