/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	 header file for dictionary tree structure
 *	
 * Author:  Jie Chen
 *          CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cefDictTree.h,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:28  chen
 *   Initial import to coda_2.0
 *
*	  Revision 1.1  1995/03/17  15:00:19  chen
*	  Initial revision
*
 *
 */
#ifndef _CEFDICT_TREE_H
#define _CEFDICT_TREE_H

#define MAX_NUM_CHILDREN 50

typedef struct TREE_NODE     /*tree structure related to dictionary*/
{
  int                tag_v;
  char               *name;
  char               *title;
  struct TREE_NODE   *mleft;
  struct TREE_NODE   *rsibling;
  struct TREE_NODE   *parent;
}TREE_NODE;

typedef struct forest_
{
  TREE_NODE         *root[MAX_NUM_CHILDREN];
  int               numTrees;
}FOREST;

extern FOREST *glbForest;

extern void      updateGlbTreeNode ();
extern TREE_NODE *newTreeNode ();
extern void      updateTreeNoe ();
extern void      deleteDictTree ();
extern FOREST    *newForest();
extern void      addTreeToForest ();
extern void      deleteForest ();
extern void      mleftOfTree ();
extern void      parentOfForest ();
extern void      print_forest ();
extern int       parseDictionary ();

extern TREE_NODE *root_d[20];
extern int       num_of_tree;
#endif
