/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	
 *	
 * Author:  Jie Chen, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: cef.h,v $
 *   Revision 1.1.1.1  1996/09/24 14:21:28  chen
 *   Initial import to coda_2.0
 *
 *	  Revision 1.1  1994/12/08  14:42:29  chen
 *	  Initial revision
 *
 */
#ifndef _cef_h
#define _cef_h


#define MAXLEN 1000
#define NUM_BLOCK 100
#define NUM_EVENT 2000
#define MAX_BLOCK_SIZE 0x00000f00
#define MAXCHAR 4*MAX_BLOCK_SIZE*NUM_BLOCK
#define lcur '{'
#define rcur '}'

typedef struct _pst
{
  int            length;     /*inlclude size +1*/
  int            posi;       /* event start posi */
  int            type;
  int            tag;
  int            num;
  struct _pst    *next;
}EvStack;

typedef struct
{
  int           head_pos;
  int           type;
}Look_Ahead;                 /* find out which is header */

typedef struct _evTree
{
  int           length;      /*include size +1*/
  int           start;       /*where it starts inside a event */
  int           tag_v;
  char          *name;
  char          *title;
  int           type;        /*type for its own content       */
  int           num;         /*number in bank header          */
  int           parent_type; /*type of its parent             */
			     /*which will help header recognition*/
  struct _evTree *parent;
  struct _evTree *mleft;
  struct _evTree *rsibling;
}evTreeNode;

typedef struct _dictTree        /*tree structure related to dictionary*/
{
  int                tag_v;     /* tag value                          */
  char               *name;     /* name must be here                  */
  char               *title;    /* title may be empty                 */
  struct _dictTree   *mleft;
  struct _dictTree   *rsibling;
  struct _dictTree   *parent;
}TREE_NODE;

typedef struct _format
{
  short type;
  int new_line;                 /*type newline or not*/
}FORMAT;

typedef struct _sdw
{
  short first_bit;
  short repeat;
  short arb;                   /* either type or number of words*/
}SDW;                          /*format descripotor*/

typedef char Bank;
typedef char Event;

extern char DIRC[];            /* dictionary name allocated memory  */
extern char SOURCE[];          /* data source name allocated memory */
extern char TAG[];             /* tag name momory allocated         */
extern int  quick_dump_mode;   /* 1 no waiting, 0 interactive       */
extern int  hex_or_decimal;    /* tell hex or decimal dump          */
extern int  start;             /* which event we start at           */
extern int  ending;            /* which event we are going to end at*/
extern int  num_of_tree;       /* number of trees in the forest     */
                               /* of dictionary                     */
extern int  view_mode;         /* o view file, 1 spy_event          */
extern TREE_NODE  *root_d[20]; /* Dictionary tree forest            */

#endif
