#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "chandata.h"
#include <alarmString.h>

extern chandata *pchandata;

FILE *fr,*fw;

chid pchid[1000];
struct dbr_ctrl_double dbr[1000];

main(argc,argv)
int argc;
char **argv;
{
int noName,i,type;
char *str,pvName[1000][NAME_LENGTH];
double value[1000];
struct dbr_ctrl_double *db;

for (i=0;i<1000;i++) value[i]=0.;

if (argc == 1) {
	printf("Usage:  caInfo1 <infile> <outfile>\n\n");
        printf("  <infile>   -   Required, which contains a list of channel names,\n");
        printf("                 each line contains a single channel name followed\n");
        printf("                 with a carriage return.\n");
        printf("  <outfile>  -   Optional, which records the obtained operating infomation\n");
        printf("                 from IOC for the corresponding <infile> list,\n");
	exit(1);
	}

	noName = readFile(argv[1],pvName); 
	
	caGetInfoArray(noName,pvName,pchid);

	printf("\n");
	for (i=0;i<noName;i++)  {
	type = ca_field_type(pchid[i]);
	if (type == TYPENOTCONN) {
		printf("%d %-30s *** NOT FOUND / NOT CONNECTED ***\n",type,pvName[i]);
		continue;
		}
	if (type > DBR_STRING) {
	db = (struct dbr_ctrl_double *)(dbr+i);
	value[i] = db->value; 
	printf("%2d ",ca_field_type(pchid[i]));
	printf("%-30s ",pvName[i]);
	printf("%10.2f ",db->value);
	printf("%-9s ",alarmStatusString[db->status]);
	printf("%-12s",alarmSeverityString[db->severity]);
	printf("%10.2f ",db->upper_disp_limit);
	printf("%10.2f ",db->lower_disp_limit);
	printf("%s\n ",db->units);
		}
	else printf("%d %-30s *** UNKNOWN:wrong type of record requested ***\n",type,pvName[i]);

	}

	if (argc < 3) exit(0);
	if ((fw = fopen(argv[2],"w")) == NULL ) {
	printf("Error: caInfo failed to open the output file '%s'\n",argv[2]);
	exit(1);
	}

	for (i=0;i<noName;i++) { 
		type = ca_field_type(pchid[i]);
		if (type == TYPENOTCONN) {
			fprintf(fw,"%2d ",type);
			fprintf(fw,"%-30s ",pvName[i]);
			fprintf(fw," *** NOT FOUND / NOT CONNECTED ***\n");
			continue;
			}
		if (type > DBR_STRING) {
	db = (struct dbr_ctrl_double *)(dbr+i);
		fprintf(fw,"%2d ",type);
		fprintf(fw,"%-30s ",pvName[i]);
		fprintf(fw,"%10.2f ",db->value);
		fprintf(fw,"%-9s ",alarmStatusString[db->status]);
		fprintf(fw,"%-12s",alarmSeverityString[db->severity]);
		fprintf(fw,"%10.2f ",db->upper_disp_limit);
		fprintf(fw,"%10.2f ",db->lower_disp_limit);
		fprintf(fw,"%s\n ",db->units);
		}
		else {
			fprintf(fw,"%2d ",type);
			fprintf(fw,"%-30s ",pvName[i]);
			fprintf(fw," *** UNKNOWN:wrong type of record requested ***\n");
			}
		}
	fclose(fw);
	
	printf(" *** caInfo completed normally ***\n");


}

caGetInfoArray(noName,pvName,pchid)
int noName;
char pvName[][NAME_LENGTH];
chid pchid[];
{
int i;

	ca_task_initialize();

	for (i=0;i<noName;i++) 
		ca_search(pvName[i],&pchid[i]);
	ca_pend_io(30.0);

	for (i=0;i<noName;i++) { 
		if (ca_field_type(pchid[i]) > DBR_STRING)
		ca_get(DBR_CTRL_DOUBLE,pchid[i],&dbr[i]);
		}
	ca_pend_io(30.0);

	ca_task_exit();
}

int readFile(filename,pvName)
char *filename;
char pvName[][NAME_LENGTH];
{
struct stat buf;
off_t filesize;
char *ptr,buff[81];
int l,i;

if ((fr = fopen(filename,"r")) == NULL ) {
	printf("Error: caInfo failed to open the input file  '%s'\n",filename);
	exit(1);
	}
	l =0;
	while( fscanf(fr,"%s",pvName[l]) == 1)  l++;
        return l;
}
