#include <tcl.h>
#include <tclInt.h>
#include <msql.h>
#include <tk.h>
#include <dp.h>
#include <signal.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#ifndef VXWORKS
#include <sys/resource.h>
#endif

static Tcl_HashTable NS_cache;
static int NS_db;
static char PM_address[100];
static char PM_socket[100];

typedef struct DP_FileHandle {
    Tcl_Interp *interp;
    FILE *filePtr;		/* Open file descriptor (file or socket) */
    int mask;			/* Mask of file descriptor conditions */
    char *rCmd;			/* Command to call on readable condition */
    char *wCmd;			/* Command to call on writable condition */
    char *eCmd;			/* Command to call on exception condition */
    char *fileId;		/* Represents filePtr */

} DP_FileHandle;

extern DP_FileHandle *DP_handlers[];
extern int Tdp_FreeHandler();
extern int Tdp_HandleEvent();

typedef struct NS_entry *NS_entryPtr;

typedef struct NS_entry {
  char name[80];
  char filehandle[20];
} NS_entry_s;

int msqlDoQuery(char *query) 
{
  int res;
  
  res = msqlQuery(NS_db,query);

  if (res == -1) {
    int tries = 0;
    
    while (tries++ < 5) {
      NS_db = msqlConnect(NULL);
      
      if (NS_db >=0 ) {
	if (msqlSelectDB(NS_db,getenv("EXPID")) < 0) {
	  printf("msql error : %s\n", msqlErrMsg);
	  return -1;
	}
	return msqlQuery(NS_db,query);
      }
      printf("msql error : %s\n", msqlErrMsg);
#ifdef VXWORKS
      taskDelay(60*(1<<tries));
#else
      sleep(1<<tries);
#endif
    } 
  } else {
    return res;
  }
  return -1;
}

#define TCL_PROC(name) int name (void *object, Tcl_Interp *interp, int argc, char **argv)

TCL_PROC(NS_FindServiceByFile)
{
  Tcl_HashEntry *entryPtr;
  Tcl_HashSearch search;
  NS_entryPtr NS_entry;
  int res;
  
  entryPtr = Tcl_FirstHashEntry(&NS_cache, &search);

  while (entryPtr) {
    NS_entry = (NS_entryPtr) Tcl_GetHashValue(entryPtr);
    if (strcmp(NS_entry->filehandle,argv[1]) == 0) {
      Tcl_ResetResult (interp);
      Tcl_AppendResult (interp,NS_entry->name ,NULL);
      return TCL_OK;
    }    
    entryPtr = Tcl_NextHashEntry(&search);
    
  }
  Tcl_ResetResult (interp);
  Tcl_AppendResult (interp,argv[1]," not connected" ,NULL);
  return TCL_ERROR;
}

TCL_PROC(NS_FindServiceByName)
{
  Tcl_HashEntry *entryPtr;
  Tcl_HashSearch search;
  NS_entryPtr NS_entry;
  int res;
  
  entryPtr = Tcl_FirstHashEntry(&NS_cache, &search);

  while (entryPtr) {
    NS_entry = (NS_entryPtr) Tcl_GetHashValue(entryPtr);
    if (strcmp(NS_entry->name,argv[1]) == 0) {
      Tcl_ResetResult (interp);
      Tcl_AppendResult (interp,NS_entry->filehandle ,NULL);
      return TCL_OK;
    }    
    entryPtr = Tcl_NextHashEntry(&search);
    
  }
  Tcl_ResetResult (interp);
  Tcl_AppendResult (interp,argv[1]," not connected" ,NULL);
  return TCL_ERROR;
}

void sigalrm_handler(int sig)
{
  return;
}

TCL_PROC(DP_ask_cmd)
{
  NS_entryPtr ns_entry;
  Tcl_HashEntry *entryPtr;
  char *fileHandle;
  char *command = NULL;
  int result,new;

  int events = 0;		/* Default: RPC will block. 	*/
  int timeout = 0;		/* Default: no timeout. 	*/
  char *timeoutReturn = NULL;	/* Default: no timeoutReturn. 	*/
  
  int rpc_argc;		/* Passed to Tdp_RPC. */
  char **rpc_argv;		/* Passed to Tdp_RPC. */
  
  if (argc < 3) {
  error_args:
    Tcl_AppendResult(interp,
		     "wrong # args: should be \"", argv[0],
		     " ?-events events?",
		     " ?-timeout millisecs ??-timeoutReturn callback??",
		     " name ", 
		     "command",
		     (char *) NULL);
    return TCL_ERROR;
  }

  /* Process the parameter flags as long as we see a '-' character;
   */

  rpc_argc = argc -1;
  rpc_argv = argv + 1;
 
  while (rpc_argv[0][0] == '-') {
    
    if (rpc_argc < 3) {
      goto error_args;
    }
    /* Process a parameter flag by either:
     *   Constructing events mask from "-events" parameter;
     *   Retrieving timeout value from "-timeout" parameter;
     *   Retrieving timeoutReturn value from "-timeoutReturn" parameter;
     */
    
    if (strcmp(rpc_argv[0], "-events") == 0) {
      int i;
      int eventc;
      char **eventv;
      
      int none = 0;
      
      if (Tcl_SplitList(interp, rpc_argv[1], &eventc, &eventv) != TCL_OK) {
	Tcl_AppendResult(interp, "bad parameter \"", rpc_argv[1],
			 "\" for -events flag of ", argv[0],
			 (char *) NULL);
	result = TCL_ERROR;
	goto done;
      }
      events = TK_FILE_EVENTS;
      
      for (i = 0; i < eventc; i++) {
	if (strcmp(eventv[i], "x") == 0)
	  events = events | TK_X_EVENTS;
	else if (strcmp(eventv[i], "rpc") == 0)
	  events = events | TK_FILE_EVENTS;
	else if (strcmp(eventv[i], "file") == 0)
	  events = events | TK_FILE_EVENTS;
	else if (strcmp(eventv[i], "timer") == 0)
	  events = events | TK_TIMER_EVENTS;
	else if (strcmp(eventv[i], "idle") == 0)
	  events = events | TK_IDLE_EVENTS;
	else if (strcmp(eventv[i], "all") == 0)
	  events = TK_ALL_EVENTS;
	else if (strcmp(eventv[i], "none") == 0)
	  none = 1;
	else {
	  Tcl_AppendResult(interp, "unknown event type \"",
			   eventv[i], "\" : should be ",
			   "x, rpc, file, timer, idle, all, or none",
			   (char *) NULL);
	  free((char *) eventv);
	  
	  result = TCL_ERROR;
	  goto done;
	}
      }
      
      if ((none) || (eventc <= 0))
	events = -1;
      
      ckfree((char *) eventv);
    } else if (strcmp(rpc_argv[0], "-timeout") == 0) {
      if (Tcl_GetInt(interp, rpc_argv[1], &timeout) != TCL_OK) {
	result = TCL_ERROR;
	goto done;
	    }
    } else if (strcmp(rpc_argv[0], "-timeoutReturn") == 0) {
      if (timeoutReturn) {
	ckfree((char *) timeoutReturn);
	timeoutReturn = NULL;
      }
      
      timeoutReturn = (char *) ckalloc(strlen(rpc_argv[1]) + 1);
      strcpy(timeoutReturn, rpc_argv[1]);
    } else {
      Tcl_AppendResult(interp, "unknown parameter flag \"",
		       rpc_argv[0], "\" : should be ",
		       "-events, -timeout, or -timeoutReturn",
		       (char *) NULL);
      result = TCL_ERROR;
      goto done;
    }
    
    rpc_argc = rpc_argc - 2;
    rpc_argv = rpc_argv + 2;
  }
  /* 
   * First look in cache then in database for argv[1]
   */

retry_ask:

  entryPtr = Tcl_FindHashEntry(&NS_cache, rpc_argv[0]);

  if (entryPtr == NULL) {
    int res;
    char tmp[200],host[100],port[100];
    m_result *result;
    m_row    row;
 
    sprintf(tmp,"select host,port from process where name='%s'",rpc_argv[0]);
    res = msqlDoQuery( tmp); 
    if (res < 0) {
      Tcl_AppendResult(interp,"DP_ask (msql error : ", msqlErrMsg," )", (char *) NULL);
      return TCL_ERROR;
    }   
    result = msqlStoreResult();

    if (msqlNumRows(result) == 0) {
      Tcl_AppendResult(interp,"DP_ask (server ", rpc_argv[0]," not in database)", (char *) NULL);
      msqlFreeResult(result);
      return TCL_ERROR;
    }
    row = msqlFetchRow(result);

    strcpy(host,row[0]);
    strcpy(port,row[1]);

    msqlFreeResult(result);

    {
      int tmp_argc,fd,len;
      char *tmp_argv[4];
      char ret[200];
      FILE *filePtr;
      DP_FileHandle *handler;
      
      tmp_argv[0] = "dp_connect";
      tmp_argv[1] = host;
      tmp_argv[2] = port;
      tmp_argc = 3;
#ifndef VXWORKS
      signal(14,sigalrm_handler);
      alarm(5);
#endif

      if (Tdp_ConnectCmd(NULL,interp, tmp_argc, tmp_argv) != TCL_OK) {
#ifndef VXWORKS
	alarm(0);
#endif
	Tcl_ResetResult (interp);
	Tcl_AppendResult (interp,"cannot connect to ",rpc_argv[0]," on ",host,":",port,NULL);
	return TCL_ERROR;
      }
      strtok(interp->result," ");

      ns_entry = (NS_entryPtr) malloc(sizeof(NS_entry_s));
      
      strcpy(ns_entry->name,rpc_argv[0]);
      strcpy(ns_entry->filehandle,interp->result);

      new = 0;

      entryPtr = Tcl_CreateHashEntry(&NS_cache,ns_entry->name,&new);

      if (!new) {
	char *p;

	entryPtr = Tcl_FindHashEntry(&NS_cache, ns_entry->name);
	p = Tcl_GetHashValue(entryPtr);
	free(p);
      }

      Tcl_SetHashValue(entryPtr,ns_entry);
            
      if (Tcl_GetOpenFile(interp, ns_entry->filehandle, 1, 1, &filePtr) != TCL_OK) {
	printf("Tcl_GetOpenFile failed\n");
#ifndef VXWORKS
	alarm(0);
#endif
	return TCL_ERROR;
      }

      fd = fileno(filePtr);    
      {
        char *p=ret;
        int l,ix=0;

        for (;ix<199;ix++,p++) {
	  
          l = read(fd,p,1);
          if ((*p == '\n') || (l <= 0)) break;
        }
        *p=0;
        len = ix;
      }
#ifndef VXWORKS
      alarm(0);
#endif
      
      if (strncmp(ret,"Connection refused",18) == 0) {
	close(fd);
	Tcl_ResetResult (interp);
	Tcl_AppendResult (interp,rpc_argv[0]," on ",host,":",port," refuses connection",NULL);
	return TCL_ERROR;
      }

      {
	int val = 1;
	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,&val,4);
      }
      if ((handler = DP_handlers [fd]) != NULL) {
	DP_handlers[fd] = (DP_FileHandle *) NULL;
	Tk_EventuallyFree((ClientData)handler,
			  (Tk_FreeProc *)Tdp_FreeHandler);
	handler = NULL;
      }
      

      Tk_DeleteFileHandler (fd);
      
      /*
       * Create a new handler.
       */
      handler = (DP_FileHandle *) ckalloc (sizeof (DP_FileHandle));
      handler->interp  = interp;
      handler->filePtr = filePtr;
      handler->fileId  = (char *) ckalloc (strlen (ns_entry->filehandle) + 1);

      handler->rCmd = (char *) ckalloc(strlen( "dp_ProcessRPCCommand 0") + 1);
      handler->eCmd = (char *) ckalloc(strlen( "dp_ProcessRPCCommand 0") + 1);
      strcpy(handler->rCmd,  "dp_ProcessRPCCommand 0");
      strcpy(handler->eCmd,  "dp_ProcessRPCCommand 0");
      
      handler->wCmd = NULL;
      handler->mask = 0;
      strcpy (handler->fileId, ns_entry->filehandle);
      handler->mask = TK_READABLE;
      
      DP_handlers[fd] = handler;

      Tk_CreateFileHandler (fd, TK_READABLE, (Tk_FileProc *)Tdp_HandleEvent,
			    (ClientData) handler);
      

      Tcl_VarEval(interp,"dp_atclose ",
		  ns_entry->filehandle,
		  " appendUnique \"DP_ShutdownRPC ", ns_entry->filehandle,"\"",NULL);

      Tcl_VarEval(interp,"dp_atexit appendUnique \"close ",
		  ns_entry->filehandle,"\"",NULL);

      fileHandle = ns_entry->filehandle;
    }
  } else {
    NS_entryPtr entry;
    entry = (NS_entryPtr) Tcl_GetHashValue(entryPtr);
    fileHandle = entry->filehandle;
  }

  rpc_argc = rpc_argc -1;
  rpc_argv = rpc_argv +1;

  command = Tcl_Merge(rpc_argc, rpc_argv);
  {
    char temp[100];
    strcpy(temp,fileHandle);
    Tcl_ResetResult (interp);
    if (timeout != -1) {
      result = Tdp_RPC(interp, temp, command, events,
		       timeout, timeoutReturn);
      ckfree((char *) command);     /* Tdp_RPC does not free the command */
      if (result == 2) {            /* Connection Broken - go back and try again */
	printf("retry DP_ask\n");
	entryPtr = NULL;            /* Hash table entry got deleted */
	rpc_argc = rpc_argc +1;     
	rpc_argv = rpc_argv -1;
	goto retry_ask;
      }	
    } else {
      result = Tdp_RDO(interp, fileHandle, command);  
      if (result == TCL_OK) {
	Tcl_ResetResult (interp);
	Tcl_AppendResult (interp,"ok",NULL);
      } 
    }
  }
    
done:
  
  return result;
}

TCL_PROC(DP_shutdownCmd)
{
  Tcl_HashEntry *entryPtr;
  Tcl_HashSearch search;
  NS_entryPtr NS_entry;
  int res;

  entryPtr = Tcl_FirstHashEntry(&NS_cache, &search);

  while (entryPtr) {
    
    NS_entry = (NS_entryPtr) Tcl_GetHashValue(entryPtr);
    if (strcmp(NS_entry->filehandle,argv[1]) == 0) {
      Tcl_DeleteHashEntry(entryPtr);
      free(NS_entry);
      break;
    }

    entryPtr = Tcl_NextHashEntry(&search);
    
  }

  Tcl_VarEval(interp,"dp_CancelRPC ",argv[1]," ;dp_ShutdownRPC ", argv[1],NULL);

  return TCL_OK;
}


TCL_PROC(DP_tell)
{
  int i,rpc_argc;
  char *rpc_argv[30];
  
  rpc_argc = argc+2;

  rpc_argv[0] = argv[0];
  rpc_argv[1] = "-timeout";
  rpc_argv[2] = "-1";
  for (i=3;i<rpc_argc;i++)
    rpc_argv[i] = argv[i-2];

  return DP_ask_cmd(object,interp,rpc_argc,rpc_argv);
}

TCL_PROC(PM_heartbeat)
{
  char *argv2[6],tmp[100],tmp2[100],*tmp3 = NULL;
  int argc2;
  int ok=1;
  int result;
  sprintf(tmp,"%s:monitor",argv[2]);
  Tcl_Eval(interp,"ns_systime");
  sprintf(tmp2,"%s",interp->result);
  if (Tcl_VarEval(interp, argv[1], " configure",NULL) != TCL_OK) {
    ok = 0;
  } else {
    tmp3 = strdup(interp->result);
  }
  argc2 = 5;
  argv2[0] = "DP_tell";
  argv2[1] = tmp;
  argv2[2] = "heartbeat_callback";;
  argv2[3] = argv[1];
  argv2[4] = tmp2;
  if (ok) {
    argc2=6;
    argv2[5] = tmp3;
  }
  
  DP_tell(object, interp, argc2, argv2);

  if (ok)
    free (tmp3);

  /*Tcl_VarEval(interp,"dp_after 5000 PM_heartbeat ", argv[1]," ",argv[2], NULL);*/
  return TCL_OK;
}

TCL_PROC(NS_ServerInit)
{
  char host[40];
  char port[20];
  char tmp[200];
  char tmp2[200];

  int res;

  if (argc < 2) {
    Tcl_AppendResult(interp,
		     "wrong # args: should be \"", argv[0], " name [session]",
		     (char *) NULL);
    
    return TCL_ERROR;
  }
  if (argv[1][0] == '-') {
    if (strcmp(argv[1],"-host")==0) {
      strcpy(host,argv[2]);
    }
    argc -= 1;
    argv += 1;
  } else {
    gethostname(host,40);
  }


  if (Tcl_Eval(interp,"dp_MakeRPCServer 0 dp_CheckHost none 1") == TCL_ERROR) {
    Tcl_AppendResult(interp,"NS_ServerInit (dp_MakeRPCServererror : ", interp->result," )", (char *) NULL);
    return TCL_ERROR;
  }
  strcpy(tmp,interp->result);

  Tcl_VarEval(interp,"lindex \"",tmp,"\" 0",NULL);
  strcpy(tmp2,interp->result);

  Tcl_VarEval(interp,"dp_SetNsCmd ",tmp2,NULL);

  Tcl_VarEval(interp,"lindex \"",tmp,"\" 1",NULL);
  strcpy(port,interp->result);

#ifdef VXWORKS
  sprintf(tmp,"insert into process (name,id,cmd,type,host,port,state,pid,inuse,clone) values ('%s',-1,' ','USER','%s',%s,'alive',%d,'yes','no')",
	  argv[1],host,port,0);
/*printf("NS_ServerInit: insert to msql database, port = %s, fileID = %s,\n",port,tmp2);*/
#else
  sprintf(tmp,"insert into process (name,id,cmd,type,host,port,state,pid,inuse,clone) values ('%s',-1,' ','USER','%s',%s,'alive',%d,'yes','no')",
	  argv[1],host,port,getpid());
#endif
  res = msqlDoQuery( tmp); 
/*printf("NS_ServerInit: insert result = %d\n",res);*/

  if (res < 0) {
#ifdef VXWORKS
     sprintf(tmp,"update process set name='%s',host='%s',port=%s,state='alive',inuse='no' where name='%s'",
	  argv[1],host,port,argv[1]);
/*printf("NS_ServerInit: update to msql database, port = %s, fileID = %s,\n",port,tmp2);*/
#else
     sprintf(tmp,"update process set name='%s',host='%s',port=%s,state='alive',inuse='no',pid=%d where name='%s'",
	  argv[1],host,port,getpid(),argv[1]);
#endif
     res = msqlDoQuery( tmp);
/*printf("NS_ServerInit: update result = %d\n",res);*/
     if (res<0) {
       Tcl_AppendResult(interp,"NS_ServerInit (msql error : ", msqlErrMsg," )", (char *) NULL);
       return TCL_ERROR;
     }
  }

  Tcl_VarEval(interp,"dp_atexit appendUnique \"NS_ServerShutdown ",argv[1],"\"",NULL);
  Tcl_VarEval(interp,"dp_atclose ",tmp2," appendUnique \"NS_ServerShutdown ",argv[1],"\"",NULL);
  
  Tcl_ResetResult(interp);
  sprintf(interp->result,"%s",port);
  return TCL_OK;
}

TCL_PROC(NS_ServerShutdown)
{
  char tmp[200];
  int res;
  printf("server shutdown\n");
  sprintf(tmp,"update process set port=0,state='down',inuse='no',pid=-1 where name='%s'"
	  ,argv[1]);  
  msqlDoQuery(tmp);
  sprintf(tmp,"delete from process  where name='%s' and type='USER'",argv[1]);
  msqlDoQuery(tmp);
  return TCL_OK;
}


int DPNS_Init(Tcl_Interp *interp) 
{
  static int once = 0;
  char *db;

  if (once) return TCL_OK;
  once = 1;
  {
#ifndef VXWORKS
    sigset_t set,oset;
    struct rlimit rls;
    
    /*getrlimit(RLIMIT_CORE , &rls);
      rls.rlim_cur = 0;
      setrlimit(RLIMIT_CORE , &rls);*/
    
    getrlimit( RLIMIT_NOFILE, &rls);

    rls.rlim_cur = 400;
    setrlimit( RLIMIT_NOFILE, &rls);

    sigaddset(&set, SIGPIPE);
    sigprocmask(SIG_BLOCK, &set, &oset);
#endif
  }

  Tcl_InitHashTable(&NS_cache, TCL_STRING_KEYS);
  
  NS_db = msqlConnect(NULL);

  if (NS_db < 0) {
     printf("msql error : %s\n", msqlErrMsg);
     return -1;
  }
  db = (char *) getenv("EXPID");
  if (db == NULL) {
    printf("Must set EXPID variable\n");
    return -1;
  }
  if (msqlSelectDB(NS_db,db) < 0) {
    printf("msql error : %s\n", msqlErrMsg);
    return -1;
  }
  Tcl_CreateCommand(interp, "NS_ServerInit",
		    NS_ServerInit,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "DP_ask",
		    DP_ask_cmd,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "DP_tell",
		    DP_tell,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "DP_ShutdownRPC",
		    DP_shutdownCmd,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "NS_ServerShutdown",
		    NS_ServerShutdown,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "PM_heartbeat",
		    PM_heartbeat,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "NS_FindServiceByFile",
		    NS_FindServiceByFile,
		    (ClientData) NULL, (void (*)()) NULL);
  Tcl_CreateCommand(interp, "NS_FindServiceByName",
		    NS_FindServiceByName,
		    (ClientData) NULL, (void (*)()) NULL);

  /*Tcl_Eval(interp,"dp_connect -udp");

  strcpy(PM_socket,interp->result);
  strtok(PM_socket," ");*/
  return TCL_OK;
}

