
#include <stdio.h>
#include <db.h>
#include <fifo.h>
#include <dd_dcom.h>
#include <dbfi.h>

void change_fifo_header(int which_fifo)
{
  struct fifo_header fhdr;
  char c[2];

  fifo_print_header(which_fifo);

  printf("\n\n");
  printf(" fifo number ");
  scanf("%i",&fhdr.fnumber);
  printf(" fifo name ");
  scanf("%s",&fhdr.fname);
  printf(" fifo type ");
  scanf("%s",&fhdr.ftype);
  printf(" fifo status 0=UNUSED, 1=IDLE, 2=ACTIVE ");
  scanf("%i",&fhdr.fstatus);
  printf(" fifo mode (0=ALL, 1=COND, 2=ONREQ ");
  scanf("%i",&fhdr.fmode);
  printf(" fifo control word 1 ");
  scanf("%i",&fhdr.fctlw1);
  printf(" fifo control bit word 2 ");
  scanf("%i",&fhdr.fctlb1);
  printf(" fifo control word 2 ");
  scanf("%i",&fhdr.fctlw2);
  printf(" fifo control bit word 2 ");
  scanf("%i",&fhdr.fctlb2);
  printf(" number of proc att ");
  scanf("%i",&fhdr.fnproc_att);
  printf(" fifo wait mode (0=SLEEP, 1=ASYNC)");
  scanf("%i",&fhdr.fwait_mode);
  printf(" fifo pid to signal ");
  scanf("%i",&fhdr.freqcnt);
  printf(" fifo creater id ");
  scanf("%i",&fhdr.fpidcreat);

  printf("\n");
  printf(" ok to go on and change the header [y/n] def=n \n");
  scanf("%s",&c);
  if ( c[0] == 'y'){
    if (fifo_set_header(which_fifo,fhdr) != 0){
      perror(" change_fhdr: error in fifo_set_hdr");
      return;
    }
  }
  return;
}
      

void print_fifos()
{
  int which_fifo;
  int first,last;
  char c[2];

  printf("  enter h to print the header of a fifo \n");
  printf("       p to print a fifo \n");
  printf("       s to print semaphore status \n");
  printf("       o to print an overview of the fifos \n");
  printf("       i to print this info panel \n");
  printf("       q to quit \n");
  printf(" \n");

  while ( ( scanf("%s",c) >0) && (c[0] != 'q') ) {
    switch(c[0]){
    case 'h':
      printf(" enter fifo number \n");
      scanf("%i",&which_fifo);
      if (which_fifo == -1){
	for (which_fifo = 0;which_fifo<MAX_FIFO_NB;which_fifo++)
	  fifo_print_header(which_fifo);
      }
      else
	fifo_print_header(which_fifo);
      break;
    case 'p':
      printf(" enter fifo number \n");
      scanf("%i",&which_fifo);
      printf(" enter first entry to print \n");
      scanf("%i",&first);
      printf(" enter last entry to print \n");
      scanf("%i",&last);
      fifo_print(which_fifo, first, last);
      break;
    case 's':
      fifo_sem_status();
      break;
    case 'i':
      printf(" enter h to print the header of a fifo \n");
      printf("       p to print a fifo \n");
      printf("       s to print semaphore status \n");
      printf("       o to print an overview of the fifos \n");
      printf("       i to print this info panel \n");
      printf("       q to quit \n");
      printf(" \n");
      break;
    }
  }
}


main()
{

  static int init;
  int i,p,j,imax;
  int *ip;
  int *ipp;
  int ififo,ififo1,ififo2;
  char c[2];
  int val[10000];
  int istat;
  int iloop;
  int ctl[4];
  char ftype[4];
  char fname[7];

  struct fifo_entry fev;
/*
  int size;
  int shmid[100], *shmaddr[100];
*/
  printf("\n\n");
  printf(" ************************************************************\n");
  printf(" *                                                          *\n");
  printf(" *           welcome to the FIFO control program            *\n");
  printf(" *                                                          *\n");
  printf(" ************************************************************\n");
  printf("\n\n");

/*
  for (i=0;i<10;i++){
    size = 10000;
    db_getmem(&size,&shmid[i]);
    db_attmem(shmid[i],&shmaddr[i]);
    printf(" attached shm %i %i %p \n",i,shmid[i],shmaddr[i]);
  }
*/

  printf(" do you want to create the semaphores and shared memory (y/n) ?\n");
  while ( ( scanf("%s",c) >0) && (c[0] != 'y') && (c[0] !='n') ) {
    printf(" enter 'y' or 'n' \n");
  }
  init = 0;
  if (c[0] == 'y')
    init = 1;

  printf("attaching the fifos %i  \n",fifo_attach(init));

  if ( init ){
    for (ififo=0;ififo<MAX_FIFO_NB;ififo++){
      if (fifo_init(ififo) ){
	perror(" fifos_init: error in initialising fifo");
	return -1;
      }
    }
  }

  db_init(init);

  ififo1 = 0;
  ififo2 = 0;
  printf("input/output fifo %i %i \n",ififo1,ififo2);
  printf("type h for help ... \n");

    while ( ( scanf("%s",c) >0) && (c[0] != 'q') ) {
      switch(c[0]){
      case 'p':
	printf(" enter number of events to enter \n");
	scanf("%i",&imax);
	for (j=0;j<imax;j++){
	  printf("i = %i %i \n",j,imax);
	  fev.shmid = -1;
	  fev.dboff = (i%DB_MAXNBEV)*DB_MAXEVSIZE;
	  fev.p2da = db_ptr_shm + (i%DB_MAXNBEV)*DB_MAXEVSIZE;
	  *fev.p2da = (i%DB_MAXNBEV)*1000;
	  printf(" enter event length ");
	  scanf("%i",fev.len);
	  printf(" enter event ctlw1 ");
	  scanf("%i",fev.ctlw1);
	  printf(" enter event ctlb1 ");
	  scanf("%i",fev.ctlb1);
	  printf(" enter event ctlw2 ");
	  scanf("%i",fev.ctlw2);
	  printf(" enter event ctlb2 ");
	  scanf("%i",fev.ctlb2);
	  printf("input to fifo %i status %i \n",ififo1,fifo_write(ififo1,fev));
	}
	break;
      case 'g':
	istat = fifo_read(ififo2,&fev, -1); 
        my_own_fifo = ififo2;
	printf(" read from fifo %i \n",ififo2);
        printf(" fifo event: shmid %4i dboff %10i p2da %p \n",fev.shmid, 
	       fev.dboff, fev.p2da);
	printf("len %8i ctl words %4i %4i %4i %4i \n",fev.len,fev.ctlw1,fev.ctlb1, 
	       fev.ctlw2,fev.ctlb2);
	break;
      case 'x':
	istat = fifo_read(ififo2,&fev, -1);
	printf(" read from fifo %i \n",ififo2);
        printf(" fifo event: shmid %4i dboff %10i p2da %p \n",
	       fev.shmid,fev.dboff,fev.p2da);
	printf("len %8i ctl words %4i %4i %4i %4i \n",fev.len,
	       fev.ctlw1,fev.ctlb1, fev.ctlw2,fev.ctlb2);
	printf("input to fifo %i status %i \n",ififo1,fifo_write(ififo1,fev));
	break;
      case 's':
	print_fifos();
	break;
      case 'w':
	printf("enter read fifo ");
	scanf("%i",&ififo2);
        printf(" ---> reading from fifo %i \n",ififo2);
	printf("enter write fifo ");
	scanf("%i",&ififo1);
	printf(" ---> writing into fifo %i \n",ififo1);
        break;
      case 'm':
	printf("enter fifo name (6 characters long) \n");
	scanf("%s",&fname);
	printf("enter fifo type (STA or DYN) \n");
	scanf("%s",&ftype);
	ctl[0] = 0;
	ctl[1] = 0;
	ctl[2] = 0;
	ctl[3] = 0;
	my_own_fifo = fifo_make(fname,ftype,0,0,ctl);
	printf("new fifo has number %i \n",my_own_fifo);
	break;
      case 'r':
	printf("enter fifo number to remove \n");
	scanf("%i",&my_own_fifo);
        printf(" fifo remove status %i \n",fifo_remove(my_own_fifo));
	break;
      case 'c':
	printf(" enter fifo number to change header \n");
	scanf("%i",&ififo1);
	change_fifo_header(ififo1);
	break;
      case 'e':
	printf(" enter fifo number to empty \n");
	scanf("%i",&ififo1);
/*	change_fifo_header(ififo1); */
	break;
 case 'h':
	printf(" type: \n");
	printf("    w: to select read/write fifo \n");
	printf("    f: to fill some initial values into fifo 0 \n");
	printf("    p: to put a pointer into the fifo \n");
	printf("    g: to get a pointer into the fifo \n");
	printf("    s: to print fifos  \n");
	printf("    x: to read the read_fifo and write into write_fifo \n"); 
	printf("    m: to make a fifo \n");
	printf("    r: to remove a fifo \n");
	printf("    c: to change fifo header values \n");
	printf("    e: to empty a fifo \n");
	break;
      default:
	break;
      }
    }
  fifo_close(init);
  db_close(init);

  return;
}
       


