class DDR_UI {
    constructor {} {}
    destructor {}
    
    method DDR_start {} @DDR_start_cmd
    method DDR_start_tcl {} {}
    method DDR_stop  {} @DDR_stop_cmd
    method DDR_update {} @DDR_update

    public variable max_fifo_nb @max_fifo_nb
    public variable fifo_depth  @fifo_depth
}

body DDR_UI::DDR_start_tcl {} {
    after 1000 itcl_context $this DDR_UI DDR_update;
}

body DDR_UI::constructor {} {
    set interp_name mainInterp
    global env
    global tkVersion
    global tk_library
    wm positionfrom . user
    wm sizefrom . ""
    #wm geometry . 372x279
    #wm maxsize . 372 279
    #wm minsize . 372 279
    set image_library $env(CODA)/common/images
    wm title . {data distribution status}

    set w [frame .f1 -bd 2 -relief raised]
    set coda_logo [image create photo -file $image_library/gif/RCLogo.gif]
    label $w.logo -bg grey -padx 0 -pady 0 -image $coda_logo 
    
    menubutton $w.file -menu $w.file.m -text File -underline 0 \
	-takefocus 0

    menu $w.file.m
    $w.file.m add command -label "Exit     " -command exit -underline 1 \
	-accelerator "Ctrl+X"
	
    # Accelerator bindings

    bind all <Control-x> "exit"

    frame .f2 -bd 2 -relief flat

    set graph1 [GRAPH graph  .f2.graph $max_fifo_nb $fifo_depth "Fifo name" "buffers"]
    set graph2 [GRAPH graph2 .f2.graph2 $max_fifo_nb 10 "Fifo name" "k events/Sec"]

    pack $w.file -in $w -side left
    pack $w.logo -side left  -padx 6 -expand yes
    pack $w -side top -fill x -expand yes

    pack [$graph1 widget] -in .f2 -side left
    pack [$graph2 widget] -in .f2 -side left
    pack .f2 -side bottom -fill x -expand yes

}

class GRAPH {
    constructor {w x y xtitle ytitle} {}
    destructor {} 
    method plot { element data } {}
    method label { element label }

    private variable widget

    method widget {} { return $widget }
    private method FormatLabel { w value } {} 
}

body GRAPH::plot { element data } {
    $widget element configure $element -ydata $data
    
}

body GRAPH::label { element label } {
    $widget element configure $element -label $label
}

body GRAPH::constructor {w x y xtitle ytitle} {
    
    set widget $w

    blt_barchart $widget -invertxy 1 -width 500 -height 250

    $widget xaxis configure -title $xtitle -command "itcl_context $this GRAPH FormatLabel"    

    $widget legend configure -mapped 0
    $widget yaxis configure  -title $ytitle -max $y
    for { set i 0 } { $i <= $x } { incr i } {
	$widget element create $i \
	    -data { $i 0 } \
	    -relief raised \
	    -label "FIFO $i" \
	    -foreground blue \
	    -bd 2
    }

    $widget element configure 0 -foreground red
    $widget element configure $x -foreground green
}

body GRAPH::FormatLabel { w value } {
    # Determine the element name from the value
    set displaylist [$w element show]
    set index [expr round($value)]
    set name [lindex $displaylist $index]
    if { $name == "" } { 
        return $name
    }
    # Return the element label
    set info [$w element configure $name -label]
    return [lindex $info 4]
}

DDR_UI main

main DDR_start
