#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/signal.h>
#include <stdio.h>

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <e787util.h>

extern XtAppContext  app_context;
extern Display       *display;

extern Widget     DD_Text;
extern Widget     DD_InTF;

pid_t    DD_pid =  0;
FILE     *toDD, *fromDD;

static int DD_TextLen;

static char *terminator = "\n\n\n\n\n\n\n\n\n \
         ***********************************\n\
         *                                 *\n\
         *     HASTA LA VISTA .... BABE    *\n\
         *                                 *\n\
         ***********************************\n";


void DD_OutputCallbackHandler( client_data, fid, id )
   caddr_t  client_data;   /* Not used */
   int      *fid, id;      /* Not used */
{
   char     DD_buf[133], *bp;
   XmTextPosition 
            lastPos;
   Arg      al[64];
   int      ac;

   while (bp = fgets( DD_buf, 133, fromDD ))
   {
      lastPos = XmTextGetLastPosition( DD_Text );
      XmTextInsert( DD_Text, lastPos, DD_buf );
      lastPos = XmTextGetLastPosition( DD_Text );
		XmTextSetInsertionPosition(DD_Text,lastPos);
   }
   XFlush( display );

	if (lastPos > 0.9*DD_TextLen)
	  XmTextSetString(DD_Text,"");
}



void DD_Startserver()
{
   extern void CatchPipeSignal();

   int         to[2], from[2], *childStat;
   char        buf[133];
	char        pname[100];
   XtInputId   xid;
   Arg         al[64];
   pid_t       child;
   FILE        *dum1, *dum2;
   
	strcpy(pname,getenv("DD_BIN"));
	strcat(pname,"/dd_ctl");

   DD_pid = spawn(pname, &toDD, &fromDD );
   if (DD_pid == -1)
     fprintf(stderr," dd_ctl not spawned!\n" );
   else{
     fcntl( fileno( fromDD ), F_SETFL, O_NDELAY );
     xid = XtAppAddInput(app_context, fileno(fromDD), (XtPointer)XtInputReadMask,
			(XtInputCallbackProc)DD_OutputCallbackHandler, NULL);
   }

	DD_TextLen = XmTextGetMaxLength(DD_Text);
}

void DD_Init()
{
  if (DD_pid == 0){
    DD_Startserver();
  }

  fprintf(toDD,"init \n");
  fflush(toDD);

}

void DD_Reset()
{
  if (DD_pid == 0){
    DD_Startserver();
  }

  fprintf(toDD,"reset \n");
  fflush(toDD);
}

void DD_Connect()
{
  if (DD_pid == 0){
    DD_Startserver();
  }
  fprintf(toDD,"connect \n");
  fflush(toDD);
}

void DD_Wakeup()
{
  if (DD_pid == 0){
    DD_Startserver();
  }
  fprintf(toDD,"wakeup \n");
  fflush(toDD);
}

void DD_Help()
{
  if (DD_pid == 0){
    DD_Startserver();
  }
  fprintf(toDD,"help \n ");
  fflush(toDD);
}

void DD_Exit()
{
  if (DD_pid == 0){
    DD_Startserver();
  }
  
  fprintf(toDD,"exit");
  fflush(toDD);

  sleep(1);

  fclose( toDD );
  fclose( fromDD );

  exit(0);
}

void DD_Startfmon()
{
  pid_t pid_fmon;
  char pname[80];
   
  if (DD_pid == 0){
    DD_Startserver();
  }

  strcpy(pname,getenv("DD_BIN"));
  strcat(pname,"/ddr_ui");
    
  if ( (pid_fmon = fork()) == 0)
	 execl(pname,pname,(char*)NULL);

  if (pid_fmon == -1)
	 fprintf(stderr,"cannot fork ddr_ui off \n");
}

void DD_Startpmon()
{
  pid_t pid_pmon;
  char pname[80];

  if (DD_pid == 0){
    DD_Startserver();
  }
   
  strcpy(pname,getenv("DD_BIN"));
  strcat(pname,"/ddp_ui");
    
  if ( (pid_pmon = fork()) == 0){
	 execl(pname,pname,(char*)NULL);
  }
  if (pid_pmon == -1)
	 fprintf(stderr,"cannot fork ddp off \n ");
}


void DD_Quit()
{
  int rstatus;
  char buf[133];
  XmTextPosition lastPos;

  if ( DD_pid <= 0 )
	 exit(0);

  fprintf(toDD,"quit \n");
  fflush(toDD);

  wait(&rstatus);
  sprintf(buf," dd_ctl child terminated - status %i \n",rstatus);
  DD_pid = 0;

  lastPos = XmTextGetLastPosition( DD_Text );
  XmTextInsert( DD_Text, lastPos, buf );
  XFlush( display );
  sleep(1);

  fclose( toDD );
  fclose( fromDD );

  exit(0);
}

void DD_Showproc()
{
  if (DD_pid == 0){
    DD_Startserver();
  }

  fprintf(toDD,"status proc \n ");
  fflush(toDD);
}

void DD_Showfheadall()
{
  if (DD_pid == 0){
    DD_Startserver();
  }

  fprintf(toDD,"status fifo header -1 \n");
  fflush(toDD);
}

void DD_Showfsem()
{
  if (DD_pid == 0){
    DD_Startserver();
  }

  fprintf(toDD,"status fifo semaphore \n");
  fflush(toDD);
}

void DD_Input()
{
  char *p2c;
  char command[100];
  int i,len,fi,saddr,eaddr;

  if (DD_pid == 0){
    DD_Startserver();
  }

  p2c = XmTextFieldGetString(DD_InTF);
  len = XmTextFieldGetLastPosition(DD_InTF) -1;

  if (strstr(p2c,"fp") == p2c){
	 sscanf(p2c,"fp %i %i %i",&fi,&saddr,&eaddr);
	 sprintf(command,"sta fif pri %i %i %i \n",fi,saddr,eaddr);
  }
  else if (strstr(p2c,"fh") == p2c){
	 sscanf(p2c,"fh %i",&fi);
	 sprintf(command,"sta fif head %i \n",fi);
  }
  else if (strstr(p2c,"ter") == p2c) 
	 DD_Exit();
  else{
	 strcpy(command,p2c);
	 strcat(command,"\n");
  }

  fprintf(toDD,"%s",command);
  fflush(toDD);

  XmTextFieldSetString(DD_InTF,"");

}
