/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <dd_sys.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

int go_on;

void
sig_handler ()
{
  printf("signal received\n");
  fflush(stdout);
  go_on = 0;
  return;
}

main(int argc,char **argv)
{
  int i,i1,i2,i3, imax;
  int *p;
  int j,len, dump, brc_flag, error;
  void show_sys();
  int status;
  char what2do[100];
  char what1[100],what2[100],what3[100], answer;
  char fname[100];
  int reqcnt, ctl[4];
  struct fifo_entry fev, fev_example;
  struct fifo_mode fmode;
  int stime,etime;

  strcpy(fname,"INPUT");

  fmode.mode = FMODE_ALL;
  fmode.wait = FWAIT_SLEEP;
  fmode.prescale = 1;
  fmode.suser = FMODE_MULTI_USER;
  fmode.p2ctl = ctl;

  for (i=0;i<4;i++)
    ctl[i] = -1;

  if ( (status = dds_create()) != 0 ) {
    printf("dds_create: status returned %d\n",status);
    exit(1);
  }

  if ( (status = ddu_init(fname, fmode) ) != 0 ) {
    printf("ddu_init status %d \n",status);
    fflush(stdout);
    exit(1);
  }
/*
  signal (SIGINT, sig_handler);
*/
  go_on = 1;
  dump = 0;
  stime = time(0);

  if ( (status = ddu_set_netswap(DDN_TRF_NOSWAP) ) != 0 ) 
    printf("dd_set_netswap: status = %d\n",status);
  show_dd_dcom();
  while ( go_on && ddu_attached() ) {
    i = 0;
    printf("enter the number of events (0 to exit) \n");
    scanf("%d",&imax);
    printf("nloops = %d\n",imax);
    if ( imax <= 0 ) {
      go_on = FALSE;
    }
    len = 100;
    while ( go_on && (ddu_attached()) && (i++ < imax) ){

      if ( i%10000 == 0 ) 
	printf("after iteration %d\n",i);

      status = ddu_req_fev(len, &fev);
      if (status == 0){
	int j;
	p = fev.p2da;
	fev.len = len;
	fev.ctlw1 = i%4+1;
	fev.ctlb1 = rand() & 3;
	fev.ctlw2 = 0;
	fev.ctlb2 = 0;
	if ( ( status = ddu_put_fev(fev) ) != 0){
	  printf("ddu_put_fev: status returned %d \n",status);		  
	  go_on = FALSE;
	}
      } else {
	printf("ddu_req_fev: status returned %d \n",status);	
	go_on = FALSE;
      }
      
      /*if ( i%10000 == 0 ) {
	etime = time(0);
	printf("event %8d  %5d Sec/10k\n",i,etime-stime);
	stime = etime;
	}*/
    }
  }

  ddu_close();
  printf("dd cleaned up\n");
  return;
}
       
 

