/*
 * dd_ctl.c : This program is the main control program for the DD
 *          : system. It is used in two different ways:
 *          : 1. Directly from DUI. 
 *          : 2. As a server to the standalone dd_ui program.
 *          : Note: the difference between "exit" and "quit" command:
 *          :       exit is used by DUI and removes the DD completely.
 *          :       quit is used by dd_ui and only deattaches from the DD.  
 *
 * Author   :  C.Witzig
 * Date     :  Apr ?, 1992
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <dd_sys.h>
#include <dd_user.h>

#define TRUE 1
#define FALSE 0

int go_on;

void
sig_handler (int sig)
{
  go_on = 0;
printf("In consumer sig handler, set go_on to 0\n");
  return;
}

void cmd_fcn1(int w1, int b1)
{
  printf("cmd_fcn1: w1=%d b1=%d\n",w1,b1);
  return;
}

void cmd_fcn2(int w1, int b1)
{
  printf("cmd_fcn2: w1=%d b1=%d\n",w1, b1);
  return;
}

main(int argc,char **argv)
{
  int i,i1,i2,i3;
  int *p;
  int j,len, dump, brc_flag, error;
  void show_sys();
  int status;
  char what2do[100];
  char what1[100],what2[100],what3[100], answer;
  char fname[100];
  int reqcnt, ctl[4];
  struct fifo_entry fev, fev_example;
  struct fifo_mode fmode;
  int stime, etime;

  if (argc < 2) {
    printf("syntax: dd_test_c <fifo name>\n");
    exit(1);
  }
/*
  ddu_attach();
*/
  strcpy(fname,argv[1]);
  if (argc==2) {
    fmode.mode = FMODE_USER;
  } else {
    fmode.mode = FMODE_ONREQ;
  }
  fmode.wait = FWAIT_SLEEP;
  fmode.prescale = 1;
  fmode.suser = FMODE_MULTI_USER;
  fmode.p2ctl = ctl;
  ctl[0] = -1;
  ctl[1] = -1;
  ctl[2] = -1;
  ctl[3] = -1;
  
retry:
  if ( (status = ddu_init(fname, fmode) ) != 0 ) {
    printf("ddu_init: status returned %d\n",status);
    exit(1);
  }
/* 
  ddu_close();
  ddu_attach();
*/
  signal (SIGINT, sig_handler);
/*
  ddu_set_protection(FIFO_PROTECTED);
  ddu_set_brccmd(1, &cmd_fcn1);
  ddu_set_brccmd(3, &cmd_fcn2);

  ddu_set_brc(DD_BRC_SIGNAL); 
*/

  ddu_start();
  printf("start done\n");
  stime = time(0);
  go_on = 1;
  dump = 0;
  i=0;

  while (ddu_attached() && go_on){
    status = ddu_get_fev(&fev);
    if (status == 0){
      if ( (status = ddu_put_fev(fev)) != 0 ) {
	printf("ddu_put_fev: status1 returned %d\n",status);
	go_on = FALSE;
      }
/*
      if ( (status = ddu_put_fev(fev)) != 0 ) {
	printf("ddu_put_fev: status2 returned %d\n",status);
	go_on = FALSE;
      }
*/
      i++;
      if ( i%1 == 0 ) {
	etime = time(0);
	printf("event %8d  %5d Sec/1k\n",i,etime-stime);
	stime = etime;
      }
    } else {
      printf("ddu_get_fev: status returned %d\n",status);
      go_on = FALSE;
    }
  }
  
printf("consumer attachment = %d, go_on = %d\n",ddu_attached(), go_on);

/*
  while (!ddu_attached()) {
  while (ddu_attach() != 0) {
  while (ddu_init(fname, fmode) != 0) {
*/

  while (ddu_attach() != 0) {
     sleep(1);
     printf("Tring to reattach consumer\n\n");
  }
  goto retry;
  /* goto retry; */
  /* goto pastinit; */
 
  
stop:  
  ddu_stop();
  ddu_close();
  return;
}
       


