
/*
 * dd_server_test : Main server loop for dd2tcp.
 * Author         :  C.Witzig
 * Date           :  Jan 6, 1996
 */

/*
 * DD server TEST program:
 * ------------------------
 * The DD server gets spawned on a host (e.g. by the script 
 * start_dd_server and then waits for a request
 * 
 * This program is just a test program, there are no hooks
 * to the DD code except the network calls. It is intended
 * for use with the dd_client_test program.
 *
 * See W.Steven's book "UNIX NETWORK PROGRAMMING" page 284ff
 * for details
 */

/*
 * Mods          :
 *
 */

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <time.h>

#include <dd_user.h>

#define TRUE 1
#define FALSE 0

#define DD_SERVER_TCP_PORT 6499
#define MAX_NBADCMD 100


FILE *logfile;
int  buffer[1000000];
int  nbuf_sent;
int checking = TRUE;



int resocket(int fdes, void *p2dest, int nbytes, int swap)
{
  int i, *p;
  int iread, status;
  char *c;

  iread = 0;
  status = 0;
  while ( iread != nbytes ) { 
    if ( (status = read(fdes, (char*)p2dest+iread, nbytes-iread)) < 0){
      sprintf(dd_log_msg," resocket: error in read - status = %d \n",status, strerror(errno));
      dd_log(DD_ERROR, dd_log_msg);
      return -1;
    }
    else if ( status == 0 ) {
      sprintf(dd_log_msg," resocket: read sees EOF -  status = %d \n",status, strerror(errno));
      dd_log(DD_ERROR, dd_log_msg);
      break;
    }
    iread+= status;
  }

  if ( swap ) {
    int i, *p = (int*) p2dest;
    for (i=0; i++ <nbytes/4; p++)
      *p = ntohl(*p);
  }

  return 0;
}



void rec_mtrf()
{
}


void dd2tcp_server()
{
  int go_on;
  int i, *p, status, iread, icmd, nbadcmd;
  struct ddn_cmd ddn_cmd;
  time_t t;

  for (i=0; i<sizeof(buffer)/4; i++)
    buffer[i] = 0;

  go_on = TRUE;
  nbadcmd = 0;
  logfile = stdout;
  nbuf_sent = 0;

  do {
    int *p_i = (int*) &ddn_cmd;
    iread = 0;
    fflush(stdout);

    if ( resocket(dd_sockfd, p_i, sizeof(ddn_cmd),TRUE) < 0 ) {
      printf("error in reading command \n");
      go_on = FALSE;
    }

    printf("ddn_command: header %x cmd %d len %d\n",
	   ddn_cmd.header, ddn_cmd.cmd, ddn_cmd.len);
    
    if ( ddn_cmd.header != DDN_HEADER ) {
      fprintf(logfile,"dd2tcp_server pid %i: header %x not found \n",
	      getpid(),ddn_cmd.header);
      go_on = FALSE;
    }
    else{
      if ( ddn_cmd.cmd == 1 ) {
	char a_string[1024];
	resocket(dd_sockfd, a_string, ddn_cmd.len, FALSE);
	printf("Received a string %s\n", a_string);
      }
      else if ( ddn_cmd.cmd == 2 ) {
	int a_int;
	resocket(dd_sockfd, &a_int, ddn_cmd.len, TRUE);
	printf("Received a int %d\n", a_int);
      }
      else if ( ddn_cmd.cmd == 3 ) {
	nbuf_sent++;
	if ( nbuf_sent%10 == 0 )
	  printf("dd2tcp_server: %d: command received %x %d %d\n",
		 getpid(), ddn_cmd.header, ddn_cmd.cmd, ddn_cmd.len);
	fflush(logfile);
	if ( ddn_cmd.cmd == DDN_CMD_EXIT ) {
	  printf("dd2tcp_server: %d: exit command seen\n",getpid());
	  go_on = FALSE;
	}
	if ( ddn_cmd.len > 0 ) {
	  if ( ddn_cmd.len < DDN_MAX_BLOCKSIZE ) {
	    if ( checking ) {
	      for (i=0; i<sizeof(buffer)/4; i++)
		buffer[i] = 0;
	    }
	    resocket(dd_sockfd, buffer, ddn_cmd.len, TRUE);
	    if ( checking ) {
	      for (i=0; i<ddn_cmd.len/4;i++) {
		printf("buffer dump: %x %x\n",i, buffer[i]);
		if ( buffer[i] != i ) {
		  printf("dd2tcp_server: transmission error seen at event %d %x %x\n",
			 nbuf_sent, i,buffer[i]);
		  /*
		     go_on = FALSE; 
		     break; 
		     */
		}
	      }
	    }
	  }
	else
	  printf("dd2tcp_server: %d: bad length received\n",getpid(), ddn_cmd.len);
	}
      }
      else if ( ddn_cmd.cmd == 4 ) 
	rec_mtrf();
      else if ( ddn_cmd.cmd == DDN_CMD_EXIT ) {
	printf("dd2tcp_server: %d: exit command seen\n",getpid());
	go_on = FALSE;
      }
    }
  } while ( go_on );

  t = time(NULL);
  fprintf(logfile,"dd2tcp_server pid %i : host %s to peer %s exit at %s \n",
	  getpid(), my_hostname, dd_peername,ctime(&t));
  fclose(logfile);

  exit(0);
}





main()
{
  int sockfd;
  struct sockaddr_in client_addr, server_addr;
  int client_addr_len = sizeof(client_addr);
  int go_on = 1;
  time_t now;

  time(&now);
  fprintf(stdout ,"DD_server: pid %d LOGFILE \n",getpid() );
  fprintf(stdout ,"---------------------------------------\n");
  fprintf(stdout ,"DD_server: pid %d starts at %s",getpid(), ctime(&now));
  fflush(stdout);

  if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0 ) {
    now = time(NULL);
    printf("DD_server: pid %d cannot open socket at %s ",getpid(),ctime(&now)) ;
    printf("DD_server: pid %d exits at %s",getpid(),ctime(&now));
    exit(1);
  }

  bzero( (char*)&server_addr, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  server_addr.sin_port = htons(DD_SERVER_TCP_PORT);
  if ( bind(sockfd, (struct sockaddr*) &server_addr, sizeof(server_addr)) < 0 ) {
    now = time(NULL);
    printf("DD_server: pid %d cannot bind socket %s at %s",getpid(), strerror(errno),ctime(&now));
    printf("DD_server: pid %d exits at %s",getpid(),ctime(&now));
    exit(1);
  }

  listen(sockfd, 5);


  while (go_on ) {
    pid_t pid;
    struct hostent *hp_new;
    void *p2v;

    dd_sockfd = accept(sockfd, (struct sockaddr *)&client_addr, &client_addr_len);
    if ( dd_sockfd < 0 ) {
      printf("DD_server: pid %d error in accept socket\n",getpid());
      go_on = 0;
    }
    now = time(NULL);
    p2v = (void*) &client_addr.sin_addr;
    hp_new = gethostbyaddr(p2v, client_addr_len, AF_INET);
    printf("dd_server: %d: connection established to %s at %s",
	    getpid(), hp_new->h_name,ctime(&now));
    fflush(stdout);

    if ( ( pid = fork() ) < 0 ) {
      printf("DD_server: pid %d error in fork \n",getpid());
      go_on = 0;
    }
    else if ( pid == 0 ) {
      close(sockfd);
      dd2tcp_server();
    }
    close(dd_sockfd);
    fflush(stdout);
  }
  now = time(NULL);
  printf("DD_server: %d exit at %s",getpid(), ctime(&now));


}


