/*
 * dd_nap.c
 *==========
 * 
 * Provides a sleep on a fraction of a second, without using
 * the timer. Stolen from W.R.Stevens, UNIX network programming
 * and named according to sginap. p330
 *
 * CW Feb 15, 1996
 */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>

int dd_nap(sleep_time)
float sleep_time;
{
  static struct timeval timeout;

  timeout.tv_sec = (int) sleep_time;
  timeout.tv_usec = (sleep_time - timeout.tv_sec ) * 1000000;

#ifdef UNAME_HPUX 
  if ( select(0, (int*) 0, (int*) 0, (int*) 0, &timeout) < 0 ) {
#else
  if ( select(0, (fd_set*) 0, (fd_set*) 0, (fd_set*) 0, &timeout) < 0 ) {
#endif
    perror("dd_nap");
    return -1;
  }

  return 0;
}
    

